/*
 * Decompiled with CFR 0.152.
 */
package com.integ.websocket.helpers;

import com.integ.websocket.WebSocketClient;
import com.integ.websocket.WebSocketClientMessageListener;
import com.integ.websocket.WebSocketClientMessageReceivedEvent;
import com.integ.websocket.messages.FileListing;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPFile;
import org.json.JSONObject;

public class GetFileListing {
    private final WebSocketClient _websocketClient;
    private final String _directory;

    public GetFileListing(WebSocketClient websocketClient, String directory) {
        this._websocketClient = websocketClient;
        if (!directory.endsWith("/")) {
            directory = directory + "/";
        }
        this._directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<FTPFile> getFiles() {
        final ArrayList<FTPFile> files = new ArrayList<FTPFile>();
        this._websocketClient.send(new FileListing(this._directory), new WebSocketClientMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMessage(WebSocketClientMessageReceivedEvent event) {
                JSONObject json = event.getJsonMessage();
                System.out.println("json = " + json.toString(2));
                if (!"File List Response".equals(json.getString("Message"))) {
                    throw new RuntimeException("Not a file listing response");
                }
                for (Object fileObject : json.getJSONArray("Content")) {
                    JSONObject fileJson = (JSONObject)fileObject;
                    String name = fileJson.getString("Name");
                    SimpleDateFormat ModParse = new SimpleDateFormat("dd MMM yyyy HH:mm");
                    Date lastModDate = null;
                    try {
                        lastModDate = ModParse.parse(fileJson.getString("Mod"));
                    }
                    catch (ParseException ex) {
                        Logger.getLogger(GetFileListing.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    long lastModMillis = lastModDate.getTime();
                    Calendar lastModCalendar = Calendar.getInstance();
                    lastModCalendar.setTimeInMillis(lastModDate.getTime());
                    FTPFile ftpFile = new FTPFile();
                    ftpFile.setName(name);
                    ftpFile.setRawListing(name);
                    ftpFile.setSize(fileJson.getLong("Size"));
                    ftpFile.setTimestamp(lastModCalendar);
                    ftpFile.setType(name.endsWith("/") ? 1 : 0);
                    files.add(ftpFile);
                }
                WebSocketClient webSocketClient = GetFileListing.this._websocketClient;
                synchronized (webSocketClient) {
                    GetFileListing.this._websocketClient.notify();
                }
            }
        });
        WebSocketClient webSocketClient = this._websocketClient;
        synchronized (webSocketClient) {
            try {
                System.out.println("websocket client wait");
                this._websocketClient.wait();
                System.out.println("websocket client notified");
            }
            catch (InterruptedException ex) {
                Logger.getGlobal().severe(ex.getMessage());
            }
        }
        return files;
    }
}

