/*
 * Decompiled with CFR 0.152.
 */
package com.integ.websocket;

import com.integ.websocket.ConsoleSession;
import com.integ.websocket.ConsoleSessionAuthenticationEvent;
import com.integ.websocket.ConsoleSessionAuthenticationListener;
import com.integ.websocket.Credentials;
import com.integ.websocket.WebSocketClientAuthenticationEvent;
import com.integ.websocket.WebSocketClientAuthenticationListener;
import com.integ.websocket.WebSocketClientErrorEvent;
import com.integ.websocket.WebSocketClientEvent;
import com.integ.websocket.WebSocketClientEventListener;
import com.integ.websocket.WebSocketClientMessageListener;
import com.integ.websocket.WebSocketClientMessageReceivedEvent;
import com.integ.websocket.messages.JniorMessage;
import com.integ.websocket.messages.Login;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public class WebSocketClient
implements Runnable {
    private final Pattern PATTERN = Pattern.compile("^\\s*(.*?):(\\d+)\\s*$");
    private final Object _websocketClientOpenLock = new Object();
    private final Object _websocketClientLoginLock = new Object();
    private final String _host;
    private final int _port;
    private final StringBuilder _stringBuilder = new StringBuilder();
    private final Object _consoleLoginLock = new Object();
    private Socket _client;
    private Thread _thread;
    private InputStream _inputStream;
    private DataInputStream _dataInputStream;
    private OutputStream _outputStream;
    private boolean _connected = false;
    private boolean _gracefulClose;
    private Logger _commLog;
    private final byte[] _readBuffer = new byte[4096];
    private byte[] _writeBuffer = new byte[4096];
    private final ArrayList<WebSocketClientEventListener> _eventListeners = new ArrayList();
    private final ArrayList<WebSocketClientAuthenticationListener> _authenticationListeners = new ArrayList();
    private final ArrayList<WebSocketClientMessageListener> _messageListeners = new ArrayList();
    private final HashMap<String, WebSocketClientMessageListener> _responseMap = new HashMap();
    private Login _login;
    private JSONObject _monitorPacketJson;
    private ConsoleSession _consoleSession;
    private Credentials _credentials = new Credentials("jnior", "jnior");
    private boolean _loggedIn;

    public WebSocketClient(String hostString) {
        Matcher matcher = this.PATTERN.matcher(hostString);
        String host = null;
        int port = 80;
        if (matcher.matches()) {
            host = matcher.group(1);
            port = Integer.parseInt(matcher.group(2));
        }
        this._host = host;
        this._port = port;
    }

    public WebSocketClient(String host, int port) {
        this(String.format("%s:%d", host, port));
    }

    public String getIpAddress() {
        return this._host;
    }

    public boolean getGracefulClose() {
        return this._gracefulClose;
    }

    public void addEventListener(WebSocketClientEventListener eventListener) {
        this._eventListeners.add(eventListener);
    }

    public void addAuthenticationListener(WebSocketClientAuthenticationListener listener) {
        this._authenticationListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(WebSocketClientMessageListener listener) {
        ArrayList<WebSocketClientMessageListener> arrayList = this._messageListeners;
        synchronized (arrayList) {
            this._messageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(WebSocketClientMessageListener listener) {
        ArrayList<WebSocketClientMessageListener> arrayList = this._messageListeners;
        synchronized (arrayList) {
            this._messageListeners.remove(listener);
        }
    }

    public boolean isConnected() {
        return this._connected;
    }

    public void login(Login login) {
        System.out.println("login as " + login.getUsername());
        this._login = login;
        this.send(login);
    }

    public boolean isLoggedIn() {
        return this._loggedIn;
    }

    public Login getLoginCredentials() {
        return this._login;
    }

    public void open() {
        if (null == this._thread) {
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName() + ":" + this._host);
            this._thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openAndWait() {
        this.open();
        Object object = this._websocketClientOpenLock;
        synchronized (object) {
            try {
                this._websocketClientOpenLock.wait(5000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        if (null != this._credentials) {
            object = this._websocketClientLoginLock;
            synchronized (object) {
                try {
                    this._websocketClientLoginLock.wait(5000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this._connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            System.out.println(String.format("create new websocket %s:%d", this._host, this._port));
            InetAddress ip = InetAddress.getByName(this._host);
            System.out.println("ip = " + ip);
            this._client = new Socket(ip.getHostAddress(), this._port);
            this._commLog = Logger.getLogger(String.format("../temp/ws%s", this._host));
            this.createStreams();
            String getRequest = "GET / HTTP/1.1\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Version: 13\r\nSec-WebSocket-Key: ZTUxNjYwYTYtOTk1OS00Mw==\r\nHost: " + this._host + "\r\nOrigin: ws://" + this._host + "\r\n\r\n";
            byte[] getRequestBytes = getRequest.getBytes();
            this._outputStream.write(getRequestBytes);
            this._outputStream.flush();
            this._connected = true;
            this._gracefulClose = false;
            int bytesRead = this._inputStream.read(this._readBuffer, 0, this._readBuffer.length);
            String upgradeResponse = new String(this._readBuffer, 0, bytesRead);
            System.out.println(upgradeResponse);
        }
        catch (ConnectException ex) {
            ex.printStackTrace();
            for (WebSocketClientEventListener eventListener : this._eventListeners) {
                eventListener.onError(new WebSocketClientErrorEvent(this, ex));
            }
            return;
        }
        catch (IOException ex) {
            for (WebSocketClientEventListener eventListener : this._eventListeners) {
                eventListener.onError(new WebSocketClientErrorEvent(this, ex));
            }
            this.close(false);
            return;
        }
        this.send(JniorMessage.Empty);
        Iterator<WebSocketClientEventListener> ex = this._websocketClientOpenLock;
        synchronized (ex) {
            this._websocketClientOpenLock.notifyAll();
        }
        for (WebSocketClientEventListener eventListener : this._eventListeners) {
            eventListener.onOpen(new WebSocketClientEvent(this));
        }
        try {
            while (true) {
                this.processFrame();
            }
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
            if (this._connected) {
                for (WebSocketClientEventListener eventListener : this._eventListeners) {
                    eventListener.onError(new WebSocketClientErrorEvent(this, ex2));
                }
            }
            this.close(false);
            return;
        }
    }

    public void disconnect() {
        if (this._connected) {
            try {
                if (null != this._client) {
                    if (null != this._consoleSession) {
                        this._consoleSession.close();
                        this._consoleSession = null;
                    }
                    this._client.close();
                    this._connected = false;
                    this._client = null;
                }
            }
            catch (IOException ex) {
                Logger.getLogger(WebSocketClient.class.getName()).severe(ex.getMessage());
            }
        }
    }

    public ConsoleSession getConsoleSession() {
        if (null == this._consoleSession) {
            this.openConsole();
        }
        return this._consoleSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openConsole() {
        this._consoleSession = new ConsoleSession(this);
        this._consoleSession.addAuthenticationListener(new ConsoleSessionAuthenticationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSuccess(ConsoleSessionAuthenticationEvent event) {
                Object object = WebSocketClient.this._consoleLoginLock;
                synchronized (object) {
                    System.out.println(new Date() + " " + this + " " + event.toString() + " notify console lock");
                    WebSocketClient.this._consoleLoginLock.notifyAll();
                }
            }

            @Override
            public void onAuthenticationFailed(ConsoleSessionAuthenticationEvent event) {
                System.out.println("uh oh");
            }
        });
        this._consoleSession.open();
        Object object = this._consoleLoginLock;
        synchronized (object) {
            try {
                this._consoleLoginLock.wait(5000L);
                System.out.println("console login notified");
            }
            catch (InterruptedException ex) {
                Logger.getLogger(WebSocketClient.class.getName()).severe(ex.getMessage());
            }
        }
    }

    private void createStreams() {
        try {
            this._inputStream = this._client.getInputStream();
            this._dataInputStream = new DataInputStream(this._inputStream);
            this._outputStream = this._client.getOutputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException("unable to create streams", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFrame() throws IOException {
        block33: {
            byte byte1 = this._dataInputStream.readByte();
            boolean fin = 1 == (byte1 >> 7 & 1);
            int opCode = byte1 & 0xF;
            switch (opCode) {
                case 0: {
                    break;
                }
                case 1: {
                    this._stringBuilder.setLength(0);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    throw new IOException("connection closed");
                }
                case 9: {
                    this.sendPong();
                    return;
                }
            }
            byte byte2 = this._dataInputStream.readByte();
            long len = byte2 & 0x7F;
            if (len == 126L) {
                len = this._dataInputStream.readUnsignedShort();
            } else if (len == 127L) {
                len = this._dataInputStream.readLong();
            }
            byte[] readBuffer = new byte[(int)len];
            int pos = 0;
            while ((long)pos < len) {
                pos += this._dataInputStream.read(readBuffer, pos, (int)(len - (long)pos));
            }
            String message = new String(readBuffer, 0, (int)len);
            this._stringBuilder.append(message);
            if (fin) {
                message = this._stringBuilder.toString();
                String logMessage = String.format("RECV <--: %s", message.replaceAll("\r\n", ""));
                this._commLog.info(logMessage);
                try {
                    String hash;
                    JSONObject metaJson;
                    JSONObject json = new JSONObject(message);
                    String jsonMessage = json.getString("Message");
                    if ("Monitor".equalsIgnoreCase(jsonMessage)) {
                        this._monitorPacketJson = json;
                        for (WebSocketClientEventListener eventListener : this._eventListeners) {
                            eventListener.onMonitorUpdate(new WebSocketClientMessageReceivedEvent(this, json));
                        }
                        break block33;
                    }
                    if ("Error".equalsIgnoreCase(jsonMessage)) {
                        String nonce = json.getString("Nonce");
                        if (null != this._credentials && null == this._login) {
                            this.login(new Login(this._credentials.getUsername(), this._credentials.getPassword(), nonce));
                            break block33;
                        }
                        Iterator<WebSocketClientAuthenticationListener> eventListener = this._websocketClientLoginLock;
                        synchronized (eventListener) {
                            this._websocketClientLoginLock.notifyAll();
                        }
                        for (WebSocketClientAuthenticationListener authenticationListener : this._authenticationListeners) {
                            WebSocketClientAuthenticationEvent event = new WebSocketClientAuthenticationEvent(this, nonce);
                            authenticationListener.onAuthenticationFailed(event);
                        }
                        break block33;
                    }
                    if ("Authenticated".equalsIgnoreCase(jsonMessage)) {
                        this._loggedIn = true;
                        Iterator<WebSocketClientAuthenticationListener> nonce = this._websocketClientLoginLock;
                        synchronized (nonce) {
                            this._websocketClientLoginLock.notifyAll();
                        }
                        for (WebSocketClientAuthenticationListener authenticationListener : this._authenticationListeners) {
                            WebSocketClientAuthenticationEvent event = new WebSocketClientAuthenticationEvent(this);
                            authenticationListener.onAuthenticationSuccess(event);
                        }
                        break block33;
                    }
                    if (json.has("Meta") && (metaJson = json.getJSONObject("Meta")).has("Hash") && this._responseMap.containsKey(hash = metaJson.getString("Hash"))) {
                        WebSocketClientMessageListener webSocketClientMessageListener = this._responseMap.get(hash);
                        webSocketClientMessageListener.onMessage(new WebSocketClientMessageReceivedEvent(this, json));
                    }
                    ArrayList<WebSocketClientMessageListener> arrayList = this._messageListeners;
                    synchronized (arrayList) {
                        for (WebSocketClientMessageListener messageListener : this._messageListeners) {
                            messageListener.onMessage(new WebSocketClientMessageReceivedEvent(this, json));
                        }
                    }
                }
                catch (Exception ex) {
                    System.err.println("message: " + message);
                    ex.printStackTrace();
                }
            }
        }
    }

    private void sendPong() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void send(JniorMessage jniorMessage, WebSocketClientMessageListener webSocketClientMessageListener) {
        if (null == webSocketClientMessageListener) {
            throw new RuntimeException("WebSocketClientMessageListener was not defined");
        }
        this._responseMap.put(jniorMessage.getHash(), webSocketClientMessageListener);
        this.send(jniorMessage.toString());
    }

    public void send(JSONObject jsonMessage) {
        this.send(jsonMessage.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String message) {
        String logMessage = String.format("SEND -->: %s", message.replaceAll("\r\n", ""));
        this._commLog.info(logMessage);
        OutputStream outputStream = this._outputStream;
        synchronized (outputStream) {
            try {
                int length = message.length();
                if (this._writeBuffer.length < length + 8) {
                    this._writeBuffer = new byte[length + 8];
                }
                int pos = 0;
                this._writeBuffer[pos++] = -127;
                if (length <= 125) {
                    this._writeBuffer[pos++] = (byte)length;
                } else if (length < 65536) {
                    this._writeBuffer[pos++] = 126;
                    this._writeBuffer[pos++] = (byte)(length >> 8 & 0xFF);
                    this._writeBuffer[pos++] = (byte)(length & 0xFF);
                }
                this._writeBuffer[1] = (byte)(this._writeBuffer[1] | 0x80);
                byte[] _maskingBuffer = new byte[4];
                for (int j = 0; j < 4; ++j) {
                    _maskingBuffer[j] = (byte)new Random().nextInt(255);
                }
                System.arraycopy(_maskingBuffer, 0, this._writeBuffer, pos, 4);
                pos += 4;
                byte[] messageBytes = message.getBytes();
                for (int i = 0; i < length; ++i) {
                    try {
                        this._writeBuffer[i + pos] = (byte)(messageBytes[i] ^ _maskingBuffer[i % 4]);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this._outputStream.write(this._writeBuffer, 0, length + pos);
                this._outputStream.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.close(false);
            }
        }
    }

    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean graceful) {
        block8: {
            try {
                this._gracefulClose = graceful;
                this._connected = false;
                if (null != this._inputStream) {
                    this._inputStream.close();
                }
                if (null != this._outputStream) {
                    this._outputStream.close();
                }
                if (null == this._client) break block8;
                this._client.close();
            }
            catch (IOException ex) {
                Logger.getLogger(WebSocketClient.class.getName()).severe(ex.getMessage());
            }
            finally {
                for (WebSocketClientEventListener eventListener : this._eventListeners) {
                    eventListener.onClose(new WebSocketClientEvent(this));
                }
            }
        }
    }

    public void setCredentials(String username, String password) {
        this._credentials = new Credentials(username, password);
    }
}

