/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.updater.steps.ProjectStep;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CleanupStep
extends ProjectStep {
    protected String[] _remoteFiles = new String[0];

    public CleanupStep(String name) {
        super(name);
        this._type = "CleanupProperty";
    }

    public CleanupStep(Element xmlElement) {
        super(xmlElement);
        this._remoteFiles = this.getChildNodeStrings("RemoteFiles");
        System.out.println("RemoteFiles: " + this._remoteFiles.length);
    }

    @Override
    public Element getXmlElement(Document document) {
        Element xmlElement = super.getXmlElement(document);
        Element remoteFilesElement = document.createElement("RemoteFiles");
        xmlElement.appendChild(remoteFilesElement);
        for (String remoteFile : this._remoteFiles) {
            Element remoteFileElement = document.createElement("string");
            remoteFileElement.appendChild(document.createTextNode(remoteFile));
            remoteFilesElement.appendChild(remoteFileElement);
        }
        return xmlElement;
    }

    public String[] getRemoteFiles() {
        return this._remoteFiles;
    }

    public void setRemoteFiles(String[] remoteFiles) {
        for (int i = 0; i < remoteFiles.length; ++i) {
            remoteFiles[i] = remoteFiles[i].trim();
        }
        this._remoteFiles = remoteFiles;
    }

    @Override
    public boolean execute() throws InterruptedException {
        try {
            for (String remoteFile : this._remoteFiles) {
                String command = "rm " + remoteFile;
                this._logger.info("  sending " + command);
                String rmResponse = this._jniorUpdateControlConnection.exec(command);
                System.out.println("rm response: " + rmResponse);
            }
        }
        catch (Exception ex) {
            this._logger.severe("error executing " + this.getClass().getName() + ": " + ExceptionUtils.getStackTrace(ex));
            return false;
        }
        return true;
    }
}

