/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.JniorControlConnection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.updater.UpdateProjectListener;
import com.integ.supporter.updater.steps.ProjectStep;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class UpdateProjectExecutor
implements Runnable {
    private final String _updateProjectFilePath;
    private final JniorInfo _targetJniorInfo;
    private final ArrayList<ProjectStep> _steps;
    private Logger _logger = Logger.getGlobal();
    private UpdateProjectListener _updateProjectListener;
    private Thread _thread;
    private boolean _isRunning;
    private boolean _abort;
    private JniorControlConnection _jniorControlConnection;
    private boolean _rebootRequired;

    public UpdateProjectExecutor(String updateProjectFilePath, JniorInfo targetJniorInfo, ArrayList<ProjectStep> steps) {
        this._updateProjectFilePath = updateProjectFilePath;
        this._targetJniorInfo = targetJniorInfo;
        this._steps = steps;
    }

    public UpdateProjectExecutor setLogger(Logger logger) {
        this._logger = logger;
        return this;
    }

    public void setListener(UpdateProjectListener updateProjectListener) {
        this._updateProjectListener = updateProjectListener;
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    public boolean wasAborted() {
        return this._abort;
    }

    public void start() {
        if (null == this._thread) {
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName());
            this._thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._abort = false;
        this._isRunning = true;
        this._logger.info(String.format("Publishing %s to %s", this._updateProjectFilePath, this._targetJniorInfo.IpAddress));
        long start = System.currentTimeMillis();
        this._jniorControlConnection = JniorControlConnection.getFor(this._targetJniorInfo, this._logger);
        try {
            ProjectStep step;
            int i;
            boolean projectResult = true;
            ArrayList<ProjectStep> projectStepArrayList = this._steps;
            int projectStepCount = projectStepArrayList.size();
            for (i = 0; i < projectStepCount; ++i) {
                if (this._abort) {
                    throw new Exception("User Aborted");
                }
                step = projectStepArrayList.get(i);
                this._logger.info(String.format("Execute %s", step.toString()));
                step.setExecutor(this);
                step.setLogger(this._logger);
                step.setJniorInfo(this._targetJniorInfo);
                step.setJniorUpdateControlConnection(this._jniorControlConnection);
                boolean result = step.execute();
                if (null != this._updateProjectListener) {
                    this._updateProjectListener.updateProjectStepResult(step, result, i + 1, projectStepCount);
                }
                if (result) continue;
                this._logger.severe(step + " FAILED!");
                projectResult = false;
                break;
            }
            this._isRunning = false;
            this._logger.info("Summary:");
            for (i = 0; i < projectStepCount; ++i) {
                step = projectStepArrayList.get(i);
                String summary = step.getSummary();
                if (null == summary) continue;
                this._logger.info(String.format("  %s: %s", step.getName(), summary));
            }
            long elapsed = System.currentTimeMillis() - start;
            long elapsedSeconds = elapsed / 1000L;
            long minutes = elapsedSeconds % 3600L / 60L;
            long seconds = elapsedSeconds % 60L;
            long fractionOfSecond = elapsed % 1000L / 100L;
            String resultString = String.format("Update project for %s has %s in %d:%02d.%d", this._targetJniorInfo.IpAddress, projectResult ? "completed SUCCESSFULLY" : "FAILED", minutes, seconds, fractionOfSecond);
            this._logger.info(resultString);
            SupporterMain.INSTANCE.playSound("pristine.wav");
            if (null != this._updateProjectListener) {
                this._updateProjectListener.updateProjectResult(this, projectResult);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (!this._abort) {
                this._logger.severe(String.format("error in UpdateProject.run(): %s", ExceptionUtils.getStackTrace(ex)));
                if (null != this._updateProjectListener) {
                    this._updateProjectListener.updateProjectResult(this, false);
                }
            } else {
                this._isRunning = false;
                this._logger.info("user aborted");
                if (null != this._updateProjectListener) {
                    this._updateProjectListener.updateProjectResult(this, false);
                }
            }
        }
        finally {
            if (null != this._jniorControlConnection) {
                try {
                    this._jniorControlConnection.disconnect();
                }
                catch (IOException ex) {
                    Logger.getLogger(UpdateProjectExecutor.class.getName()).severe(ex.getMessage());
                }
            }
        }
        this._isRunning = false;
        this._thread = null;
    }

    public void abort() {
        this._abort = true;
        this._thread.interrupt();
    }

    public void setRebootFlag() {
        this._rebootRequired = true;
    }

    public boolean isRebootRequired() {
        return this._rebootRequired;
    }

    public void clearRebootFlag() {
        this._rebootRequired = false;
    }

    public JniorInfo getJniorInfo() {
        return this._targetJniorInfo;
    }
}

