/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.beacon.JniorInfo;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.ProgressPercentComplete;
import com.integ.supporter.ui.TextPaneLog;
import com.integ.supporter.updater.UpdateProjectExecutor;
import com.integ.supporter.updater.UpdateProjectListener;
import com.integ.supporter.updater.steps.ProjectStep;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;

public class JniorUpdateTab
extends JPanel
implements ProgressPercentComplete,
UpdateProjectListener {
    private static final SimpleDateFormat FOLDER_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private final String _updateProjectFilePath;
    private final JniorInfo _jniorInfo;
    private final ArrayList<ProjectStep> _steps;
    private final String _folder;
    private Logger _logger = Logger.getGlobal();
    private UpdateProjectExecutor _updateProjectRunner;
    private UpdateProjectListener _updateProjectListener;
    private double _percentComplete = 0.0;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public JniorUpdateTab(String updateProjectFilePath, JniorInfo jniorInfo, ArrayList<ProjectStep> steps) throws IOException {
        this.initComponents();
        this._updateProjectFilePath = updateProjectFilePath;
        this._jniorInfo = jniorInfo;
        this._steps = steps;
        this._folder = String.format("%s/%s_%s", SupporterMain.TEMP_DIRECTORY, this._jniorInfo.getSerialNumber(), FOLDER_DATE_FORMAT.format(new Date()));
        this._logger = RollingLog.getLogger(String.format("%s/Update_%s", new File(SupporterMain.UPDATES_LOGS_DIRECTORY).getName(), jniorInfo.IpAddress));
        TextPaneLog textPaneLog = new TextPaneLog(this.jTextPane1);
        this._logger.addHandler(textPaneLog);
    }

    public void setListener(UpdateProjectListener updateProjectListener) {
        this._updateProjectListener = updateProjectListener;
    }

    public void setSelectedSteps(ArrayList<ProjectStep> selectedSteps) {
    }

    public UpdateProjectExecutor publish() {
        try {
            this._logger.info(String.format("Publish %s", this._updateProjectFilePath));
            this._updateProjectRunner = new UpdateProjectExecutor(this._updateProjectFilePath, this._jniorInfo, this._steps);
            this._updateProjectRunner.setLogger(this._logger);
            this._updateProjectRunner.setListener(this);
            this._updateProjectRunner.start();
        }
        catch (SecurityException ex) {
            this._logger.severe(ex.getMessage());
        }
        return this._updateProjectRunner;
    }

    @Override
    public double getPercentComplete() {
        return this._percentComplete;
    }

    public boolean isRunning() {
        return null != this._updateProjectRunner && this._updateProjectRunner.isRunning();
    }

    public void abort() {
        this._logger.info("Aborting " + this._updateProjectFilePath);
        this._updateProjectRunner.abort();
    }

    @Override
    public void loginFailed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void updateProjectStepResult(ProjectStep projectStep, boolean result, int index, int total) {
        if (result) {
            this._percentComplete = (double)index / (double)total * 100.0;
            JTabbedPane parentTabPane = (JTabbedPane)JniorUpdateTab.super.getParent();
            parentTabPane.repaint();
        }
    }

    @Override
    public void updateProjectResult(UpdateProjectExecutor updateProjectExecutor, boolean result) {
        if (result) {
            this.setTabBackground(Color.decode("#c0ffc0"));
        } else if (!updateProjectExecutor.wasAborted()) {
            this.setTabBackground(Color.decode("#ffc0c0"));
        } else {
            this.setTabBackground(Color.decode("#ffffc0"));
        }
        if (null != this._updateProjectListener) {
            this._updateProjectListener.updateProjectResult(updateProjectExecutor, result);
        }
    }

    public void setTabBackground(Color color) {
        JTabbedPane tabbedPane = (JTabbedPane)this.getParent();
        int index = tabbedPane.indexOfComponent(this);
        if (-1 != index) {
            tabbedPane.setBackgroundAt(index, color);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.add((Component)this.jScrollPane1, "Center");
    }
}

