/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema.macro;

import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.StringUtils;
import com.integ.supporter.cinema.macro.Action;
import com.integ.supporter.cinema.macro.LocalMacroFile;
import com.integ.supporter.cinema.macro.Macro;
import com.integ.supporter.cinema.macro.MacroAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class MacroFile {
    private static final Pattern NOT_COMMA = Pattern.compile("[^,]");
    protected File _file;
    protected final ArrayList<String> _headerRows = new ArrayList();
    protected final ArrayList<Action> _actions = new ArrayList();
    protected final ArrayList<Macro> _macros = new ArrayList();
    private ProcessState _state = ProcessState.None;

    MacroFile() {
    }

    protected void load(File file) {
        this._file = file;
        long startTime = System.currentTimeMillis();
        try {
            Matcher matcher;
            String line;
            int lineIndex;
            String fileContents = FileUtils.readAllText(this._file.getPath());
            System.out.println("fileContents = " + fileContents);
            String[] lines = fileContents.split("\r?\n");
            System.out.println("lines.length = " + lines.length);
            for (lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
                line = lines[lineIndex];
                System.out.println("line = " + line);
                matcher = NOT_COMMA.matcher(line);
                if (!matcher.find()) {
                    System.out.println("blank information line found");
                    break;
                }
                this._headerRows.add(line);
            }
            while (lineIndex < lines.length) {
                line = lines[lineIndex];
                System.out.println("line = " + line);
                matcher = NOT_COMMA.matcher(line);
                if (matcher.find()) {
                    System.out.println("blank information line NOT found");
                    this._state = ProcessState.ProcessNames;
                    break;
                }
                this._headerRows.add(line);
                ++lineIndex;
            }
            while (lineIndex < lines.length) {
                line = lines[lineIndex];
                System.out.println("line = " + line);
                if (line.startsWith("Description")) {
                    System.out.println("Description line found");
                } else {
                    if (line.startsWith("Device")) {
                        System.out.println("Device line found");
                        this._state = ProcessState.ProcessDevice;
                    } else if (line.startsWith("Action")) {
                        System.out.println("Action line found");
                        this._state = ProcessState.ProcessActions;
                    } else if (line.startsWith("Data")) {
                        System.out.println("Data line found");
                        this._state = ProcessState.ProcessData;
                    } else if (line.startsWith("Macro Name")) {
                        System.out.println("Macro Name found");
                        ++lineIndex;
                        break;
                    }
                    this.processActionInformation(line);
                }
                ++lineIndex;
            }
            while (lineIndex < lines.length) {
                line = lines[lineIndex];
                this.processMacroInfo(line);
                ++lineIndex;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(LocalMacroFile.class.getName()).severe(ex.getMessage());
        }
        long elapsed = System.currentTimeMillis() - startTime;
        System.out.println("elapsed = " + elapsed);
    }

    private void processActionInformation(String line) {
        System.out.println("line = " + line);
        String[] lineParts = StringUtils.split(line, ",");
        System.out.println("lineParts.length = " + lineParts.length);
        for (int i = 1; i < lineParts.length; ++i) {
            try {
                if (this._actions.size() < i) {
                    this._actions.add(new Action(i - 1));
                }
                Action macroAction = this._actions.get(i - 1);
                switch (this._state) {
                    case ProcessNames: {
                        macroAction.appendName(lineParts[i]);
                        break;
                    }
                    case ProcessDevice: {
                        macroAction.setDevice(lineParts[i]);
                        break;
                    }
                    case ProcessActions: {
                        macroAction.setAction(lineParts[i]);
                        break;
                    }
                    case ProcessData: {
                        macroAction.setData(lineParts[i]);
                    }
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void processMacroInfo(String line) {
        System.out.println("line = " + line);
        String[] lineParts = StringUtils.split(line, ",");
        System.out.println("lineParts.length = " + lineParts.length);
        Macro macro = new Macro(lineParts[0]);
        for (int i = 1; i < lineParts.length; ++i) {
            String linePart = lineParts[i];
            if ("".equals(linePart)) continue;
            System.out.println("i = " + i + ", linePart = " + linePart);
            Action action = this._actions.get(i - 1);
            MacroAction macroAction = new MacroAction(macro, action, 0);
            macro.assignAction(macroAction);
        }
        this.addMacro(macro);
    }

    public void addMacro(Macro macro) {
        this._macros.add(macro);
        System.out.println("loaded macro = " + macro);
    }

    public String getTitle() {
        return this._file.getName();
    }

    public ArrayList<Action> getMacroActions() {
        return this._actions;
    }

    public ArrayList<Macro> getMacros() {
        return this._macros;
    }

    public abstract void save() throws IOException;

    private static enum ProcessState {
        None,
        ProcessNames,
        ProcessDescription,
        ProcessDevice,
        ProcessActions,
        ProcessData;

    }
}

