/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.ApplicationConfig;
import com.integ.supporter.JniorItem;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class BeaconTableModel
extends AbstractTableModel {
    public static final int SERIAL_INDEX = 0;
    public static final int MODEL_INDEX = 1;
    public static final int HOSTNAME_INDEX = 2;
    public static final int IPADDRESS_INDEX = 3;
    public static final int SUBNET_INDEX = 4;
    public static final int MACADDRESS_INDEX = 5;
    public static final int OSVERSION_INDEX = 6;
    public static final int BOOTTIME_INDEX = 7;
    public static final int LAST_ANNOUNCED_INDEX = 8;
    public static final int MESSAGE_INDEX = 9;
    private final ArrayList<ColumnInfo> _columns = new ArrayList<ColumnInfo>(Arrays.asList(new ColumnInfo("Serial Number", 96), new ColumnInfo("Model", 96), new ColumnInfo("HostName", 256), new ColumnInfo("IP Address", 128), new ColumnInfo("Subnet Mask", 128), new ColumnInfo("MAC Address", 160), new ColumnInfo("OS Version", 128), new ColumnInfo("Boot Time", 224), new ColumnInfo("Last Announced", 224), new ColumnInfo("Message", 512)));
    private final ArrayList<JniorItem> _rowData = new ArrayList();
    private final Hashtable<Integer, JniorItem> _jniorsBySerial = new Hashtable();

    public BeaconTableModel() {
        int[] columnWidths = ApplicationConfig.getBeaconColumnWidths();
        for (int i = 0; i < this._columns.size() && i < columnWidths.length; ++i) {
            ColumnInfo columnInfo = this._columns.get(i);
            columnInfo.Width = columnWidths[i];
        }
    }

    @Override
    public String getColumnName(int column) {
        return this._columns.get((int)column).Name;
    }

    public int getColumnWidth(int column) {
        return this._columns.get((int)column).Width;
    }

    @Override
    public int getColumnCount() {
        return this._columns.size();
    }

    @Override
    public int getRowCount() {
        return this._rowData.size();
    }

    public JniorItem[] getJniors() {
        return this._rowData.toArray(new JniorItem[this._rowData.size()]);
    }

    public JniorItem getJniorAt(int row) {
        return this._rowData.get(row);
    }

    @Override
    public Object getValueAt(int row, int col) {
        JniorItem jniorItem = this._rowData.get(row);
        try {
            switch (col) {
                case 0: {
                    return jniorItem.getSerialNumber();
                }
                case 1: {
                    return jniorItem.getModel();
                }
                case 2: {
                    return jniorItem.getHostname();
                }
                case 3: {
                    return jniorItem.getIpAddress();
                }
                case 4: {
                    return jniorItem.getSubnetMask();
                }
                case 5: {
                    return jniorItem.getPhysicalAddress();
                }
                case 6: {
                    return jniorItem.getOsVersion();
                }
                case 7: {
                    return jniorItem.getBootTime();
                }
                case 8: {
                    return jniorItem.getLastAnnounced();
                }
                case 9: {
                    String message = jniorItem.getMessages();
                    if (!jniorItem.getJniorInfo().AccessibleFromLocalMachine) {
                        if (!"".equals(message)) {
                            message = message + ", ";
                        }
                        message = message + "Not Reachable";
                    }
                    return message;
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
        }
        return "";
    }

    public static boolean sameNetwork(String ip1, String ip2, String mask) throws Exception {
        byte[] a1 = InetAddress.getByName(ip1).getAddress();
        byte[] a2 = InetAddress.getByName(ip2).getAddress();
        byte[] m = InetAddress.getByName(mask).getAddress();
        for (int i = 0; i < a1.length; ++i) {
            if ((a1[i] & m[i]) == (a2[i] & m[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJniorInfo(JniorInfo jniorInfo) {
        Hashtable<Integer, JniorItem> hashtable = this._jniorsBySerial;
        synchronized (hashtable) {
            if (!this._jniorsBySerial.containsKey(jniorInfo.getSerialNumber())) {
                JniorItem jniorItem = new JniorItem(jniorInfo);
                this._rowData.add(jniorItem);
                this._jniorsBySerial.put(jniorInfo.getSerialNumber(), jniorItem);
            } else {
                JniorItem jniorItem = this._jniorsBySerial.get(jniorInfo.getSerialNumber());
                jniorItem.update(jniorInfo);
            }
            this.fireTableChanged(new TableModelEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Hashtable<Integer, JniorItem> hashtable = this._jniorsBySerial;
        synchronized (hashtable) {
            this._rowData.clear();
            this._jniorsBySerial.clear();
        }
    }

    public JniorItem getJniorItemBySerialNumber(int selectedSerialNumber) {
        return this._jniorsBySerial.get(selectedSerialNumber);
    }

    int getRowForJniorItem(JniorItem selectedJniorItem) {
        return this._rowData.indexOf(selectedJniorItem);
    }

    class ColumnInfo {
        public String Name;
        public int Width;

        public ColumnInfo(String name, int width) {
            this.Name = name;
            this.Width = width;
        }
    }
}

