/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.snapshot.NotSnapshotFileException;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;

public class SnapshotFile {
    private final File _file;
    private final boolean _isSnapshotFileFound;

    public SnapshotFile(File file) throws NotSnapshotFileException {
        this._file = file;
        String lowercaseFileName = file.getName().toLowerCase();
        if (!lowercaseFileName.endsWith(".zip")) {
            throw new NotSnapshotFileException(file, "not a .zip file");
        }
        try {
            ZipEntry snapshotFileEntry = ZipUtils.getEntry(file.getPath(), "_snapshot.log");
            this._isSnapshotFileFound = null != snapshotFileEntry;
        }
        catch (IOException ex) {
            throw new NotSnapshotFileException(file, ex);
        }
    }

    public boolean isSnapshotFile() {
        return this._isSnapshotFileFound;
    }

    public File getFile() {
        return this._file;
    }

    public String getName() {
        return this._file.getName();
    }

    public byte[] getFileEntry(String entryFileName) throws IOException {
        byte[] contents = ZipUtils.extractEntry(this._file.getPath(), entryFileName);
        return contents;
    }

    public boolean dumpLogExists() throws IOException {
        return ZipUtils.findEntry(this._file.getPath(), "dump.log");
    }

    public boolean errorsLogExists() throws IOException {
        return ZipUtils.findEntry(this._file.getPath(), "errors.log");
    }
}

