/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.jrget.models;

import com.integ.supporter.Constants;
import com.integ.supporter.ui.jtreetable.AbstractTreeTableNode;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;

public class ReleaseUpdateNode
extends AbstractTreeTableNode {
    private final JSONObject _releaseJson;

    public ReleaseUpdateNode(JSONObject releaseJson) {
        this._releaseJson = releaseJson;
        System.out.println(this.getReleaseDate());
    }

    public String getUrl() {
        return this._releaseJson.getString("url");
    }

    public String getLocalFilename() {
        String localFilename = String.format("%s%s", Constants.UPDATE_PROJECTS_DIRECTORY, this._releaseJson.getString("filename"));
        return localFilename;
    }

    public Date getReleaseDate() {
        try {
            String releaseDate = this._releaseJson.getString("date");
            return new SimpleDateFormat("MMM dd yyyy HH:mm").parse(releaseDate);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String getMd5() {
        return this._releaseJson.getString("md5");
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public Object getValueAt(Object node, int column) {
        if (1 == column) {
            return this._releaseJson.get("version");
        }
        if (2 == column) {
            return this._releaseJson.get("date");
        }
        if (3 == column) {
            return this._releaseJson.get("md5");
        }
        return "";
    }

    @Override
    public String toString() {
        return this._releaseJson.getString("filename");
    }
}

