/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.BeaconListener;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.net.beacon.commands.GetMemoryInfo;
import com.integ.supporter.beacon.dialogs.Graph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class MemoryPlotPane
extends JPanel
implements BeaconListener {
    private final Graph _memoryGraph = new Graph();
    private final Graph _cpuGraph = new Graph();
    private int _serialNumber;
    private String _ipAddress;
    private long _lastIdleTime = 0L;
    private long _lastUpTime = 0L;
    private double _minimumTotalFree = Double.MAX_VALUE;
    private boolean _alive = true;
    private long _lastTime = 0L;
    private Thread _thread;

    public MemoryPlotPane() {
        this.initComponents();
        this._cpuGraph.setColor("#fd6ab5");
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(this._memoryGraph);
        splitPane.setBottomComponent(this._cpuGraph);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerLocation(0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        Beacon.getInstance().addBeaconListener(this);
        new Thread(() -> this.requestMemory()).start();
    }

    @Override
    public void unitUpdated(JniorInfo jniorInfo) {
        if (jniorInfo.getSerialNumber() != this._serialNumber) {
            return;
        }
        if (0L != this._lastTime) {
            long elapsed = System.currentTimeMillis() - this._lastTime;
            System.out.println("unit updated elapsed = " + elapsed);
        }
        int durationInMinutes = 15;
        this._memoryGraph.setXDurationInMinutes(durationInMinutes);
        this._memoryGraph.setXMax(jniorInfo.MemoryTimestamp);
        this._memoryGraph.setYMax((double)jniorInfo.TotalMemory / 1024.0 / 1024.0);
        if ((double)jniorInfo.FreeMemory < this._minimumTotalFree) {
            this._minimumTotalFree = jniorInfo.FreeMemory;
            this._memoryGraph.setYMin(Math.floor(this._minimumTotalFree / 1024.0 / 1024.0));
        }
        double freeMemMB = (double)jniorInfo.FreeMemory / 1024.0 / 1024.0;
        this._memoryGraph.addDataPoint(jniorInfo.MemoryTimestamp, freeMemMB);
        this._cpuGraph.setXDurationInMinutes(durationInMinutes);
        this._cpuGraph.setXMax(jniorInfo.MemoryTimestamp);
        System.out.println(this._serialNumber + " jniorInfo.MemoryTimestamp = " + jniorInfo.MemoryTimestamp);
        double deltaIdleTime = jniorInfo.IdleTime - this._lastIdleTime;
        this._lastIdleTime = jniorInfo.IdleTime;
        double deltaUpTime = jniorInfo.UpTime - this._lastUpTime;
        this._lastUpTime = jniorInfo.UpTime;
        double cpuUsage = 100.0 - deltaIdleTime / deltaUpTime * 100.0;
        this._cpuGraph.addDataPoint(jniorInfo.MemoryTimestamp, cpuUsage);
        this._memoryGraph.repaint();
        this._cpuGraph.repaint();
        new Thread(() -> {
            try {
                Thread.sleep(1000L);
                this.requestMemory();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).start();
    }

    public void setJniorSerialNumber(int serialNumber) {
        this._serialNumber = serialNumber;
    }

    public void setIPAddress(String ipAddress) {
        this._ipAddress = ipAddress;
    }

    private void requestMemory() {
        try {
            Beacon.getInstance().sendCommand(InetAddress.getByName(this._ipAddress), new GetMemoryInfo(this._serialNumber));
            this._lastTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            Logger.getGlobal().log(Level.SEVERE, null, ex);
        }
    }

    public void start() {
        if (0 == this._serialNumber) {
            throw new RuntimeException("Serial Number is required");
        }
    }

    public void stop() {
        this._alive = false;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

