/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon;

import com.formdev.flatlaf.extras.FlatSVGIcon;
import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.JniorCollection;
import com.integ.janoslib.net.beacon.JniorInfo;
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BeaconNotificationPane
extends JPanel {
    private static final float SCALE = 0.02734375f;
    private JLabel errorsLabel;
    private JLabel warningsLabel;

    public BeaconNotificationPane() {
        this.initComponents();
        this.addErrorsButton();
        this.addWarningsButton();
        this.addNotificationCollectionListener();
    }

    private void initComponents() {
        this.errorsLabel = new JLabel();
        this.warningsLabel = new JLabel();
        this.setLayout(new FlowLayout(0, 5, 8));
        this.errorsLabel.setText("0");
        this.add(this.errorsLabel);
        this.warningsLabel.setText("0");
        this.add(this.warningsLabel);
    }

    private void addErrorsButton() {
        FlatSVGIcon svgIcon = new FlatSVGIcon("resources/circle-xmark.svg", 0.02734375f);
        FlatSVGIcon.ColorFilter grayColorFilter = new FlatSVGIcon.ColorFilter();
        grayColorFilter.add(Color.BLACK, Color.GRAY);
        svgIcon.setColorFilter(grayColorFilter);
        this.errorsLabel.setIcon(svgIcon);
    }

    private void addWarningsButton() {
        FlatSVGIcon svgIcon = new FlatSVGIcon("resources/triangle-exclamation.svg", 0.02734375f);
        FlatSVGIcon.ColorFilter grayColorFilter = new FlatSVGIcon.ColorFilter();
        grayColorFilter.add(Color.BLACK, Color.GRAY);
        svgIcon.setColorFilter(grayColorFilter);
        this.warningsLabel.setIcon(svgIcon);
    }

    private void addNotificationCollectionListener() {
        Beacon.getInstance().addBeaconListener(jniorInfo -> {
            int errorCount = 0;
            int warningCount = 0;
            ArrayList<String> errorSerialNumbers = new ArrayList<String>();
            ArrayList<String> warningSerialNumbers = new ArrayList<String>();
            ArrayList<JniorInfo> jniors = JniorCollection.getJniors();
            for (JniorInfo jniorInfo2 : jniors) {
                if (0 == jniorInfo2.AttentionInfo) continue;
                if (jniorInfo2.isError()) {
                    ++errorCount;
                    errorSerialNumbers.add(String.valueOf(jniorInfo2.getSerialNumber()));
                    continue;
                }
                if (!jniorInfo2.isWarning()) continue;
                ++warningCount;
                warningSerialNumbers.add(String.valueOf(jniorInfo2.getSerialNumber()));
            }
            this.errorsLabel.setText(String.valueOf(errorCount));
            this.warningsLabel.setText(String.valueOf(warningCount));
            if (0 != errorCount) {
                this.errorsLabel.setToolTipText("Units with Errors:\n" + String.join((CharSequence)"\n", errorSerialNumbers));
            } else {
                this.errorsLabel.setToolTipText("No Units with Errors");
            }
            if (0 != warningCount) {
                this.warningsLabel.setToolTipText("Units with Warnings:\n" + String.join((CharSequence)"\n", warningSerialNumbers));
            } else {
                this.warningsLabel.setToolTipText("No Units with Warnings");
            }
        });
    }
}

