/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.net.LoginFailedException;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.protocols.events.AuthenticationFailedEvent;
import com.integ.protocols.events.AuthenticationListener;
import com.integ.protocols.events.AuthenticationSuccessEvent;
import com.integ.protocols.events.ConnectionEvent;
import com.integ.protocols.events.ConnectionListener;
import com.integ.protocols.jmpprotocol.consolesession.ConsoleSession;
import com.integ.protocols.jmpprotocol.helpers.DownloadFileHelper;
import com.integ.protocols.jmpprotocol.helpers.FileListing;
import com.integ.protocols.jmpprotocol.helpers.FileProgressErrorEvent;
import com.integ.protocols.jmpprotocol.helpers.FileProgressListener;
import com.integ.protocols.jmpprotocol.helpers.FileProgressUpdatedEvent;
import com.integ.protocols.jmpprotocol.helpers.GetFileListingHelper;
import com.integ.protocols.jmpprotocol.helpers.UploadFile;
import com.integ.protocols.jmpprotocol.messages.LoginMessage;
import com.integ.protocols.websockets.WebSocketClient;
import com.integ.supporter.JniorControlConnectionAuthenticationEvent;
import com.integ.supporter.JniorSeries3ControlConnection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JniorSeries4ControlConnection
extends JniorSeries3ControlConnection {
    private WebSocketClient _websocketClient = null;
    private String _loginNonce = null;
    private boolean _fallback = false;
    private final Object _loggedInLock = new Object();

    protected JniorSeries4ControlConnection(JniorInfo targetJniorInfo, Logger logger) {
        super(targetJniorInfo, logger);
        System.out.println("_websocketClient = " + this._websocketClient);
    }

    @Override
    public boolean isLoggedIn() {
        return this._websocketClient.isLoggedIn();
    }

    @Override
    public boolean isCommandConnectionConnected() {
        return null != this._websocketClient && this._websocketClient.isConnected();
    }

    @Override
    public boolean connect() {
        return this.initWebSocketClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initWebSocketClient() {
        this._logger.info("Use Websockets for " + this._targetJniorInfo.IpAddress);
        this._websocketClient = new WebSocketClient(this._targetJniorInfo.IpAddress, 80);
        this._websocketClient.setCredentials(this._targetJniorInfo.Username, this._targetJniorInfo.Password);
        this._websocketClient.addConnectionListener(new ConnectionListener(){

            @Override
            public void onConnecting(ConnectionEvent connectionEvent) {
            }

            @Override
            public void onConnected(ConnectionEvent connectionEvent) {
                JniorSeries4ControlConnection.this._connectionNotifier.notifyConnected(connectionEvent);
            }

            @Override
            public void onClosed(ConnectionEvent connectionEvent) {
                System.out.println("closed.");
                JniorSeries4ControlConnection.this._connectionNotifier.notifyClosed(connectionEvent);
            }

            @Override
            public void onError(ConnectionEvent connectionEvent, Exception ex) {
                try {
                    System.out.println("error");
                }
                catch (Exception ex1) {
                    Logger.getLogger(JniorSeries4ControlConnection.class.getName()).log(Level.SEVERE, null, ex1);
                }
            }
        });
        this._websocketClient.addAuthenticationListener(new AuthenticationListener(){

            @Override
            public void onAuthenticaionFailed(AuthenticationFailedEvent event) {
                JniorSeries4ControlConnection.this._logger.info("Websocket authentication failed!");
                JniorSeries4ControlConnection.this._loginNonce = event.getNonce();
                JniorSeries4ControlConnection.this._authenticationNotifier.notifyAuthenticationFailed(new JniorControlConnectionAuthenticationEvent(JniorSeries4ControlConnection.this._this));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSuccess(AuthenticationSuccessEvent event) {
                JniorSeries4ControlConnection.this._logger.info("Websocket authentication success!");
                JniorSeries4ControlConnection.this._authenticationNotifier.notifyAuthenticationSuccess(new JniorControlConnectionAuthenticationEvent(this));
                Object object = JniorSeries4ControlConnection.this._loggedInLock;
                synchronized (object) {
                    JniorSeries4ControlConnection.this._loggedInLock.notify();
                }
            }
        });
        this._websocketClient.connect();
        Object object = this._loggedInLock;
        synchronized (object) {
            while (null != this._websocketClient && this._websocketClient.isConnected() && !this._websocketClient.isLoggedIn()) {
                try {
                    this._logger.info("Websocket wait for login");
                    this._loggedInLock.wait();
                    this._logger.info("Websocket logged in!");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this._logger.info(String.format("is logged in: %s", String.valueOf(this._websocketClient.isLoggedIn())));
        if (this._websocketClient.isLoggedIn()) {
            this._logger.info("get console session");
            ConsoleSession consoleSession = this._websocketClient.getConsoleSession();
            if (null != consoleSession) {
                this._logger.info("console session is open and logged in");
                return true;
            }
        }
        this._logger.warning("  fallback to telnet and ftp method");
        this._fallback = true;
        return super.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        if (this._fallback) {
            super.disconnect();
        }
        if (null != this._websocketClient) {
            try {
                this._websocketClient.close();
                if (this._websocketClient.isConnected()) {
                    this._logger.severe("  websocket client did not disconnect");
                } else {
                    this._logger.info("  websocket client disconnected");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object object = this._loggedInLock;
            synchronized (object) {
                this._loggedInLock.notify();
            }
        }
    }

    @Override
    public boolean login(String userName, String password) throws LoginFailedException {
        try {
            this._logger.info(String.format("login for %s", this._targetJniorInfo.IpAddress));
            this._websocketClient.send(new LoginMessage(userName, password, this._loginNonce));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return true;
    }

    @Override
    public FileListing[] listFiles(String directory) throws IOException {
        if (this._fallback) {
            return super.listFiles(directory);
        }
        GetFileListingHelper fileListingHelper = new GetFileListingHelper(this._websocketClient, directory);
        ArrayList<FileListing> ftpFiles = fileListingHelper.getFiles();
        return ftpFiles.toArray(new FileListing[ftpFiles.size()]);
    }

    @Override
    public void send(String string) throws Exception {
        if (this._fallback) {
            super.send(string);
            return;
        }
        this._websocketClient.getConsoleSession().send(string);
    }

    @Override
    public String exec(String command) throws Exception {
        return this.exec(command, 120000);
    }

    @Override
    public String exec(String command, int timeout) throws Exception {
        if (this._fallback) {
            return super.exec(command, timeout);
        }
        if (!this.isCommandConnectionConnected()) {
            this.connect();
        }
        return this._websocketClient.getConsoleSession().exec(command);
    }

    @Override
    public boolean retrieveFile(String remotePath, FileOutputStream fileOutputStream) throws IOException {
        if (this._fallback) {
            return super.retrieveFile(remotePath, fileOutputStream);
        }
        try {
            DownloadFileHelper downloadFile = new DownloadFileHelper(this._websocketClient, remotePath);
            downloadFile.addFileProgressListener(new FileProgressListener(){

                @Override
                public void fileProgressUpdated(FileProgressUpdatedEvent fileProgressUpdatedEvent) {
                    JniorSeries4ControlConnection.this._logger.info(String.format("    <--- %s: %d%%", fileProgressUpdatedEvent.getRemotePath(), (int)fileProgressUpdatedEvent.getPercent()));
                }

                @Override
                public void fileProgressError(FileProgressErrorEvent fileProgressErrorEvent) {
                    JniorSeries4ControlConnection.this._logger.severe(fileProgressErrorEvent.getError());
                }
            });
            byte[] fileContentBytes = downloadFile.getContents();
            if (null != fileContentBytes) {
                fileOutputStream.write(fileContentBytes);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        return false;
    }

    @Override
    public boolean storeFile(String remotePath, File localFile) throws IOException {
        if (this._fallback) {
            return super.storeFile(remotePath, localFile);
        }
        UploadFile uploadFile = new UploadFile(this._websocketClient, localFile, remotePath);
        uploadFile.addFileProgressListener(new FileProgressListener(){

            @Override
            public void fileProgressUpdated(FileProgressUpdatedEvent fileProgressUpdatedEvent) {
                JniorSeries4ControlConnection.this._logger.info(String.format("    ---> %s: %.0f%%", fileProgressUpdatedEvent.getRemotePath(), Float.valueOf(fileProgressUpdatedEvent.getPercent())));
            }

            @Override
            public void fileProgressError(FileProgressErrorEvent fileProgressErrorEvent) {
                JniorSeries4ControlConnection.this._logger.severe(fileProgressErrorEvent.getError());
            }
        });
        return uploadFile.putContents();
    }
}

