/*
 * Decompiled with CFR 0.152.
 */
package com.integ.protocols.jmpprotocol.helpers;

import com.integ.protocols.events.JmpProtocolMessageListener;
import com.integ.protocols.events.JmpProtocolMessageReceivedEvent;
import com.integ.protocols.jmpprotocol.JmpProtocolClient;
import com.integ.protocols.jmpprotocol.helpers.FileProgressListener;
import com.integ.protocols.jmpprotocol.helpers.FileProgressNotifier;
import com.integ.protocols.jmpprotocol.messages.FileReadWithRequestId;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

public class DownloadFileHelper
implements JmpProtocolMessageListener {
    private final JmpProtocolClient _websocketClient;
    private final String _remoteFilepath;
    private final FileReadWithRequestId _fileRead;
    private final Object _fileReceiveWaitObject = new Object();
    private final ByteArrayOutputStream _fileContents = new ByteArrayOutputStream();
    private final FileProgressNotifier _fileProgressNotifier = new FileProgressNotifier();
    private boolean _success;
    private Exception _error = null;
    private long _requestIdToWaitFor;

    public DownloadFileHelper(JmpProtocolClient websocketClient, String remoteFilepath) {
        this._websocketClient = websocketClient;
        this._remoteFilepath = remoteFilepath;
        this._fileRead = new FileReadWithRequestId(this._remoteFilepath);
    }

    public void addFileProgressListener(FileProgressListener fileProgressListener) {
        this._fileProgressNotifier.addEventListener(fileProgressListener);
    }

    public void removeFileProgressListener(FileProgressListener fileProgressListener) {
        this._fileProgressNotifier.removeEventListener(fileProgressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(JmpProtocolMessageReceivedEvent event) {
        long requestId;
        JmpProtocolClient websocketClient = (JmpProtocolClient)event.getClient();
        JSONObject jsonMessage = event.getJsonMessage();
        String message = jsonMessage.getString("Message");
        if ("File Read Response".equals(message) && jsonMessage.has("RequestID") && this._requestIdToWaitFor == (requestId = jsonMessage.getLong("RequestID"))) {
            block15: {
                String status = jsonMessage.getString("Status");
                if ("Ready".equalsIgnoreCase(status)) {
                    try {
                        URL url = new URL(String.format("http://%s/query.cgi?request=%d", websocketClient.getHostAddress(), requestId));
                        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                        connection.setRequestMethod("GET");
                        int httpGetStatus = connection.getResponseCode();
                        System.out.println(String.format("%s %s [%s] - %s %s", connection.getRequestMethod(), url, this._remoteFilepath, connection.getResponseCode(), connection.getResponseMessage()));
                        if (200 == httpGetStatus) {
                            try {
                                int bytesRead;
                                DataInputStream in = new DataInputStream(connection.getInputStream());
                                byte[] buffer = new byte[4096];
                                int contentLength = connection.getContentLength();
                                this._fileContents.reset();
                                while (0 < (bytesRead = in.read(buffer))) {
                                    this._fileContents.write(buffer, 0, bytesRead);
                                    int n = this._fileContents.size() * 100 / contentLength;
                                }
                                in.close();
                                this._fileContents.close();
                                this._success = true;
                                break block15;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                                break block15;
                            }
                            finally {
                                connection.disconnect();
                            }
                        }
                        System.out.println(url + " return code " + httpGetStatus);
                    }
                    catch (Exception ex) {
                        this._error = ex;
                    }
                } else {
                    this._error = new RuntimeException(String.format("Error reading %s: %s", this._remoteFilepath, status));
                }
            }
            Object object = this._fileReceiveWaitObject;
            synchronized (object) {
                this._fileReceiveWaitObject.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContents() {
        try {
            this._websocketClient.send(this._fileRead, this);
            this._requestIdToWaitFor = this._fileRead.getRequestId();
            Object object = this._fileReceiveWaitObject;
            synchronized (object) {
                this._fileReceiveWaitObject.wait(60000L);
            }
        }
        catch (Exception ex) {
            this._error = ex;
        }
        this._websocketClient.removeMessageListener(this);
        return this._success ? this._fileContents.toByteArray() : null;
    }

    public boolean wasError() {
        return null != this._error;
    }

    public Exception getError() {
        return this._error;
    }
}

