/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.snapshot.AnalyzeSnapshots;
import com.integ.supporter.snapshot.SnapshotFile;
import com.integ.supporter.snapshot.SnapshotLogFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SnapshotAnalysisPanel
extends JPanel {
    private final File _file;

    SnapshotAnalysisPanel(File file) {
        this._file = file;
    }

    public void doAnalysis() {
        JTextArea textArea = null;
        SnapshotFile snapshotFile = null;
        SnapshotLogFile snapshotLogFile = null;
        try {
            boolean errorsLogExists;
            textArea = new JTextArea();
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setViewportView(textArea);
            this.setLayout(new BorderLayout());
            this.add((Component)scrollPane, "Center");
            snapshotFile = new SnapshotFile(this._file);
            snapshotLogFile = new SnapshotLogFile(snapshotFile);
            snapshotLogFile.analyze();
            System.out.println("snapshotLogFile.getSnapshotLogContent() = " + snapshotLogFile.getSnapshotLogContent());
            String supportToolVersion = snapshotLogFile.getSupportToolVersion();
            textArea.append("Support Tool Version = " + supportToolVersion + "\r\n\r\n");
            textArea.append("SerialNumber = " + snapshotLogFile.getSerialNumber() + "\r\n");
            textArea.append("Series = " + snapshotLogFile.getSeries() + "\r\n");
            textArea.append("Model = " + snapshotLogFile.getModel() + "\r\n\r\n");
            String osVersion = snapshotLogFile.getOsVersion();
            textArea.append("osVersion = " + osVersion + "\r\n\r\n");
            int recordUptime = snapshotLogFile.getRecordUptime();
            textArea.append("record uptime = " + recordUptime + " days\r\n\r\n");
            int totalUptime = snapshotLogFile.getTotalUptime();
            textArea.append("total uptime = " + totalUptime + " days\r\n\r\n");
            ArrayList<String> applications = snapshotLogFile.getApplications();
            textArea.append("applications:\r\n");
            for (String string : applications) {
                textArea.append("  " + string + "\r\n");
            }
            textArea.append("\r\n");
            ArrayList<String> listeningPorts = snapshotLogFile.getListeningPorts();
            textArea.append("Listening Ports:\r\n");
            for (String listeningPort : listeningPorts) {
                textArea.append("  " + listeningPort + "\r\n");
            }
            textArea.append("\r\n");
            boolean bl = snapshotFile.dumpLogExists();
            if (bl) {
                textArea.append("dump.log exists!\r\n");
            }
            if (errorsLogExists = snapshotFile.errorsLogExists()) {
                textArea.append("errors.log exists!\r\n");
            }
        }
        catch (Exception ex) {
            if (null != snapshotFile) {
                textArea.append("error with snapshotFile = " + snapshotFile.getFile().getPath() + "\r\n");
                if (null != snapshotLogFile) {
                    textArea.append(snapshotLogFile.getSnapshotLogContent() + "\r\n");
                }
            }
            ex.printStackTrace();
            Logger.getLogger(AnalyzeSnapshots.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
        }
    }
}

