/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.RollingLog;
import com.integ.supporter.config.JniorsSavedStates;
import com.integ.supporter.snapshot.Snapshot;
import com.integ.supporter.snapshot.SnapshotInProgressCollection;
import com.integ.supporter.snapshot.SnapshotListener;
import com.integ.supporter.snapshot.SnapshotProgressCollection;
import com.integ.supporter.snapshot.SnapshotResult;
import com.integ.supporter.snapshot.SnapshotTab;
import com.integ.supporter.ui.ProgressPercentComplete;
import com.integ.supporter.ui.TextPaneLog;
import com.integ.supporter.ui.dialogs.LoginDialog2;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;

public class JniorSnapshotTab
extends JPanel
implements ProgressPercentComplete,
SnapshotListener {
    private static final SimpleDateFormat FOLDER_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private static final SimpleDateFormat SNAPSHOT_DATE_FORMAT = new SimpleDateFormat("ddMMMyyyy_HHmmss");
    private final JniorInfo _jniorInfo;
    private final String _folder;
    private Logger _logger = Logger.getGlobal();
    private SnapshotListener _snapshotListener = null;
    private Thread _thread;
    private Snapshot _snapshot;
    private boolean _complete;
    private boolean _abort;
    private long _startTime;
    private double _percentComplete;
    private final TextPaneLog _textPaneLog;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextPane textPaneSnapshotLog;

    public JniorSnapshotTab(JniorInfo jniorInfo) {
        this.initComponents();
        this._jniorInfo = jniorInfo;
        this._folder = String.format("%s%s_%s", Constants.TEMP_DIRECTORY, this._jniorInfo.getSerialNumber(), FOLDER_DATE_FORMAT.format(new Date()));
        try {
            this._logger = RollingLog.getLogger(String.format("Snapshot_%s", jniorInfo.IpAddress));
            String filename = String.format("%s%s.log", Constants.SNAPSHOT_LOGS_DIRECTORY, this._logger.getName());
            FileHandler fileHandler = new FileHandler(filename);
            fileHandler.setFormatter(new SimpleFormatter());
            this._logger.addHandler(fileHandler);
        }
        catch (IOException ex) {
            Logger.getLogger(JniorSnapshotTab.class.getName()).severe(ex.getMessage());
        }
        catch (SecurityException ex) {
            Logger.getLogger(JniorSnapshotTab.class.getName()).severe(ex.getMessage());
        }
        this._textPaneLog = new TextPaneLog(this.textPaneSnapshotLog);
        this._logger.addHandler(this._textPaneLog);
    }

    public Snapshot getSnapshot() {
        return this._snapshot;
    }

    public void setSnapshotListener(SnapshotListener listener) {
        this._snapshotListener = listener;
    }

    public boolean inProgress() {
        return !this._complete;
    }

    public boolean isComplete() {
        return this._complete;
    }

    @Override
    public double getPercentComplete() {
        return this._percentComplete;
    }

    public void start() {
        if (null == this._thread) {
            this._thread = new Thread(() -> {
                block2: {
                    try {
                        this._abort = false;
                        this.takeSnapshot();
                    }
                    catch (InterruptedException ex) {
                        if (!this._abort) break block2;
                        this._logger.severe("User Aborted");
                        this.setTabBackground(Color.decode("#ffffc0"));
                        this.snapshotResult(this._snapshot, SnapshotResult.Failed);
                    }
                }
            });
            this._thread.setName(this.getClass().getName() + ":" + this._jniorInfo.IpAddress);
            this._thread.start();
        }
    }

    public void abort() {
        this._abort = true;
        if (null != this._snapshot) {
            this._snapshot.abort();
        }
        this._thread.interrupt();
    }

    public boolean wasAborted() {
        return this._abort;
    }

    @Override
    public void loginFailed() {
        JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
        LoginDialog2 loginDialog = new LoginDialog2((Frame)topFrame, true);
        loginDialog.setTitle("Snapshot for " + this._jniorInfo.IpAddress + " needs credentials");
        loginDialog.centerParent();
        loginDialog.setVisible(true);
        if (loginDialog.getResult() == 1) {
            this._jniorInfo.Username = loginDialog.getUsername();
            this._jniorInfo.Password = loginDialog.getPassword();
            JniorsSavedStates.updateUsernamePassword(this._jniorInfo.getSerialNumber(), this._jniorInfo.Username, this._jniorInfo.Password);
        }
    }

    @Override
    public void downloadFileAttempt(int index, int total, String remoteFileName) {
        this._logger.info(String.format("downloading %d of %d: %s... ", index, total, remoteFileName));
    }

    @Override
    public void downloadFileResult(int index, int total, String remoteFileName, boolean result) {
        Exception exception = this._snapshot.getLastException();
        String exceptionString = this._snapshot.getLastExceptionString();
        if (result) {
            this._percentComplete = (double)index / (double)total * 100.0;
            this._logger.info(String.format("SUCCESS (%d / %d - %.2f%%)\n", index, total, this._percentComplete));
            JTabbedPane parentTabPane = (JTabbedPane)super.getParent();
            parentTabPane.repaint();
        } else {
            this._logger.info(String.format("FAILED (%s)\n", exceptionString));
        }
    }

    @Override
    public void snapshotResult(Snapshot snapshot, SnapshotResult result) {
        try {
            if (SnapshotResult.Success == result && !this.wasAborted()) {
                try {
                    String text = this.textPaneSnapshotLog.getText();
                    System.out.println(HexUtils.hexDump(text.getBytes()));
                    String snapshotFilePath = this._folder + "/_snapshot.log";
                    FileUtils.writeAllBytes(snapshotFilePath, text.getBytes());
                    ZipUtils.addFile(snapshot.getZipFile().getPath(), snapshotFilePath, "");
                }
                catch (IOException ex) {
                    Logger.getLogger(JniorSnapshotTab.class.getName()).severe(ex.getMessage());
                }
                this.setTabBackground(Color.decode("#c0ffc0"));
                JniorsSavedStates.updateSnapshotTime(this._jniorInfo.getSerialNumber(), System.currentTimeMillis());
            } else if (!this.wasAborted()) {
                this.setTabBackground(Color.decode("#ffc0c0"));
            } else {
                this.setTabBackground(Color.decode("#ffffc0"));
            }
            FileUtils.deleteDirectory(new File(this._folder));
        }
        catch (Exception ex) {
            this._logger.severe(ExceptionUtils.getStackTrace(ex));
        }
        this._complete = true;
        SnapshotInProgressCollection.removeSnapshot(this._jniorInfo);
        if (null != this._snapshotListener) {
            this._snapshotListener.snapshotResult(snapshot, result);
        } else {
            SnapshotTab.getInstance().updateTitle();
        }
        this._logger.removeHandler(this._textPaneLog);
    }

    public void setTabTitle(String newTitle) {
        JTabbedPane tabbedPane = (JTabbedPane)this.getParent();
        int index = tabbedPane.indexOfComponent(this);
        if (-1 != index) {
            tabbedPane.setTitleAt(index, newTitle);
        }
    }

    public void setTabBackground(Color color) {
        JTabbedPane tabbedPane = (JTabbedPane)this.getParent();
        int index = tabbedPane.indexOfComponent(this);
        if (-1 != index) {
            tabbedPane.setBackgroundAt(index, color);
        }
    }

    private void takeSnapshot() throws InterruptedException {
        try {
            this._complete = false;
            this._startTime = System.currentTimeMillis();
            this.setTabTitle("Snapshot - " + this._jniorInfo.IpAddress);
            this._snapshot = new Snapshot(this._jniorInfo);
            this._snapshot.setLogger(this._logger);
            this._snapshot.setFolder(this._folder);
            this._snapshot.setSnapshotListener(this);
            SnapshotProgressCollection.getInstance().addBackgroundAction(this._snapshot);
            this._snapshot.start();
        }
        catch (Exception ex) {
            if (!this.wasAborted()) {
                this._logger.severe(ExceptionUtils.getStackTrace(ex));
            }
            this.snapshotResult(this._snapshot, SnapshotResult.Failed);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane2 = new JScrollPane();
        this.textPaneSnapshotLog = new JTextPane();
        this.setLayout(new BorderLayout());
        this.jScrollPane2.setViewportView(this.textPaneSnapshotLog);
        this.add((Component)this.jScrollPane2, "Center");
    }
}

