/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.supporter.NotificationCollection;
import com.integ.supporter.cinema.Device;
import com.integ.supporter.cinema.DevicePane;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DevicePanel
extends JPanel {
    private final Device _device;
    private final JButton moveDeviceUpButton = new JButton();
    private final JButton moveDeviceDownButton = new JButton();

    public DevicePanel(Device device) {
        this._device = device;
        this.initComponents();
    }

    public Device getDevice() {
        return this._device;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = event.getActionCommand();
                e = new ActionEvent(this, 1001, actionCommand, event.getWhen(), event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    private void initComponents() {
        try {
            super.setLayout(new FlowLayout(0));
            super.setBorder(BorderFactory.createEmptyBorder(9, 12, 3, 12));
            JButton removeDeviceButton = new JButton();
            removeDeviceButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/delete.png")));
            removeDeviceButton.setFocusable(false);
            removeDeviceButton.setVerticalTextPosition(3);
            removeDeviceButton.addActionListener(evt -> {
                int confirmResult = JOptionPane.showConfirmDialog(null, String.format("Are you sure you want to remove the '%s' device?", this._device.getName()), "Please Confirm", 0);
                if (confirmResult == 0) {
                    this.fireActionPerformed(new ActionEvent(this, 0, "RemoveDevice"));
                }
            });
            super.add(removeDeviceButton);
            this.moveDeviceUpButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/arrow_up.png")));
            this.moveDeviceUpButton.setFocusable(false);
            this.moveDeviceUpButton.setVerticalTextPosition(3);
            this.moveDeviceUpButton.addActionListener(evt -> this.fireActionPerformed(new ActionEvent(this, 0, "MoveDeviceUp")));
            super.add(this.moveDeviceUpButton);
            this.moveDeviceDownButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/arrow_down.png")));
            this.moveDeviceDownButton.setFocusable(false);
            this.moveDeviceDownButton.setVerticalTextPosition(3);
            this.moveDeviceDownButton.addActionListener(evt -> this.fireActionPerformed(new ActionEvent(this, 0, "MoveDeviceDown")));
            super.add(this.moveDeviceDownButton);
            DevicePane devicePane = new DevicePane(this._device);
            super.add(devicePane);
        }
        catch (Exception ex) {
            NotificationCollection.addError(ex);
        }
    }

    void setMoveUpEnabled(boolean b) {
        System.out.println(this._device.getName() + " moveup enabled: " + b);
        this.moveDeviceUpButton.setEnabled(b);
    }

    void setMoveDownEnabled(boolean b) {
        System.out.println(this._device.getName() + " movedown enabled: " + b);
        this.moveDeviceDownButton.setEnabled(b);
    }
}

