/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ThreadUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.cinema.DevicesPane;
import com.integ.supporter.cinema.MacroExecutionDialog;
import com.integ.supporter.cinema.MacroPane;
import com.integ.supporter.cinema.RemoteFileOpener;
import com.integ.supporter.jrget.DescendingDateFileChooser;
import com.integ.supporter.ui.ActionableTabComponent;
import com.integ.supporter.ui.dialogs.JniorSelectionDialog;
import com.integ.supporter.ui.toasts.InProgressMessageToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;

public class CinemaMenu
extends JMenu {
    public CinemaMenu() {
        super("Cinema");
        this.addDevicesMenuItems();
        super.addSeparator();
        this.addMacroMenuItems();
    }

    private void addDevicesMenuItems() {
        this.addCreateDevicesFile();
        this.addOpenLocalDeviceFile();
        this.addOpenRemoteDevicesFile();
    }

    private void addCreateDevicesFile() {
        JMenuItem menuItem = new JMenuItem("Create Devices File");
        menuItem.addActionListener(e -> {
            DevicesPane devicePane = new DevicesPane(null);
            this.addDevicePaneTab("New Devices", devicePane);
        });
        super.add(menuItem);
    }

    private void addOpenLocalDeviceFile() {
        JMenuItem openLocalDevicesFileMenuItem = new JMenuItem("Open Local Devices File");
        openLocalDevicesFileMenuItem.addActionListener(e -> {
            DescendingDateFileChooser fileChooser = new DescendingDateFileChooser();
            fileChooser.setCurrentDirectory(new File(Constants.CINEMA_FILES_FOLDER));
            fileChooser.removeChoosableFileFilter(fileChooser.getChoosableFileFilters()[0]);
            fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String name = file.getName();
                    return file.getName().startsWith("devices_") && name.endsWith(".csv");
                }

                @Override
                public String getDescription() {
                    return "Devices Files";
                }
            });
            int option = fileChooser.showOpenDialog(SupporterMain.getMainFrame());
            if (option == 0) {
                File file = fileChooser.getSelectedFile();
                JTabbedPane rightTabPane = SupporterMain.getMainFrame().getRightTabPane();
                for (Component component : rightTabPane.getComponents()) {
                    System.out.println("component = " + component);
                    if (!(component instanceof DevicesPane)) continue;
                    DevicesPane devicePane = (DevicesPane)component;
                    System.out.println("devicePane = " + devicePane);
                    if (!file.getPath().equalsIgnoreCase(devicePane.getDeviceFilePath())) continue;
                    JOptionPane.showMessageDialog(SupporterMain.getMainFrame(), "The selected device file is already open.", "Already Open", 1);
                    rightTabPane.setSelectedComponent(component);
                    return;
                }
                DevicesPane devicePane = new DevicesPane(file.getPath());
                this.addDevicePaneTab(file.getName(), devicePane);
            }
        });
        super.add(openLocalDevicesFileMenuItem);
    }

    private void addOpenRemoteDevicesFile() {
        JMenuItem openRemoteDevicesFileMenuItem = new JMenuItem("Open Remote Devices File");
        openRemoteDevicesFileMenuItem.addActionListener(e -> {
            JniorInfo[] selectedJniors = this.getSelectedJniors();
            if (null != selectedJniors && 0 < selectedJniors.length) {
                for (JniorInfo jniorInfo : selectedJniors) {
                    RemoteFileOpener remoteFileOpener = new RemoteFileOpener(jniorInfo);
                    remoteFileOpener.setTitle("Remote Device File Opener");
                    InProgressMessageToast inProgressMessageToast = new InProgressMessageToast(remoteFileOpener);
                    ToastNotifications.getInstance().display(inProgressMessageToast);
                    remoteFileOpener.setFilenameFilter((dir, name) -> (name = name.toLowerCase()).startsWith("devices") && name.endsWith(".csv"));
                    remoteFileOpener.addProgressUpdateListener(e1 -> {
                        if (remoteFileOpener.isComplete()) {
                            try {
                                File localTempDeviceFile = remoteFileOpener.getLocalFile();
                                if (null != localTempDeviceFile) {
                                    String title = String.format("%s/%s", remoteFileOpener.getJniorInfo().IpAddress, localTempDeviceFile.getName());
                                    DevicesPane devicePane = new DevicesPane(localTempDeviceFile.getPath());
                                    this.addDevicePaneTab(title, devicePane);
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            finally {
                                ThreadUtils.sleep(500);
                                ToastNotifications.getInstance().hide(inProgressMessageToast);
                            }
                        }
                    });
                    remoteFileOpener.start();
                }
            }
        });
        super.add(openRemoteDevicesFileMenuItem);
    }

    private void addMacroMenuItems() {
        this.addCreateMacroFile();
        this.addOpenLocalMacroFile();
        this.addOpenRemoteMacroFile();
        super.addSeparator();
        this.addMacroExecutionTool();
    }

    private void addCreateMacroFile() {
        JMenuItem menuItem = new JMenuItem("Create Macro File");
        menuItem.addActionListener(e -> {
            try {
                MacroPane macroPane = new MacroPane(null);
                this.addMacroPaneTab("New Macro File", macroPane);
            }
            catch (Exception ex) {
                NotificationCollection.addError("Error creating new Macro Tab", ex);
            }
        });
        super.add(menuItem);
    }

    private void addOpenLocalMacroFile() {
        JMenuItem openLocalMacroFileMenuItem = new JMenuItem("Open Local Macro File");
        openLocalMacroFileMenuItem.addActionListener(e -> {
            DescendingDateFileChooser fileChooser = new DescendingDateFileChooser();
            fileChooser.removeChoosableFileFilter(fileChooser.getChoosableFileFilters()[0]);
            fileChooser.setCurrentDirectory(new File(Constants.CINEMA_FILES_FOLDER));
            fileChooser.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String name = file.getName();
                    return file.getName().startsWith("macro_") && name.endsWith(".csv");
                }

                @Override
                public String getDescription() {
                    return "Macro Files";
                }
            });
            int option = fileChooser.showOpenDialog(SupporterMain.getMainFrame());
            if (option == 0) {
                File file = fileChooser.getSelectedFile();
                JTabbedPane rightTabPane = SupporterMain.getMainFrame().getRightTabPane();
                for (Component component : rightTabPane.getComponents()) {
                    System.out.println("component = " + component);
                    if (!(component instanceof MacroPane)) continue;
                    MacroPane macroPane = (MacroPane)component;
                    if (!file.getPath().equalsIgnoreCase(macroPane.getMacroFilePath())) continue;
                    JOptionPane.showMessageDialog(SupporterMain.getMainFrame(), "The selected macro file is already open.", "Already Open", 1);
                    rightTabPane.setSelectedComponent(component);
                    return;
                }
                MacroPane macroPane = new MacroPane(file.getPath());
                this.addMacroPaneTab(file.getName(), macroPane);
            }
        });
        super.add(openLocalMacroFileMenuItem);
    }

    private void addOpenRemoteMacroFile() {
        JMenuItem openRemoteMacroFileMenuItem = new JMenuItem("Open Remote Macro File");
        openRemoteMacroFileMenuItem.addActionListener(e -> {
            JniorInfo[] selectedJniors = this.getSelectedJniors();
            if (null != selectedJniors && 0 < selectedJniors.length) {
                for (JniorInfo jniorInfo : selectedJniors) {
                    RemoteFileOpener remoteFileOpener = new RemoteFileOpener(jniorInfo);
                    remoteFileOpener.setTitle("Remote Macro File Opener");
                    InProgressMessageToast inProgressMessageToast = new InProgressMessageToast(remoteFileOpener);
                    ToastNotifications.getInstance().display(inProgressMessageToast);
                    remoteFileOpener.setFilenameFilter((dir, name) -> (name = name.toLowerCase()).startsWith("macro") && name.endsWith(".csv"));
                    remoteFileOpener.addProgressUpdateListener(e1 -> {
                        if (remoteFileOpener.isComplete()) {
                            try {
                                File localTempMacroFile = remoteFileOpener.getLocalFile();
                                if (null != localTempMacroFile) {
                                    String title = String.format("%s/%s", remoteFileOpener.getJniorInfo().IpAddress, localTempMacroFile.getName());
                                    MacroPane macroPane = new MacroPane(localTempMacroFile.getPath());
                                    this.addMacroPaneTab(title, macroPane);
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            finally {
                                ThreadUtils.sleep(500);
                                ToastNotifications.getInstance().hide(inProgressMessageToast);
                            }
                        }
                    });
                    remoteFileOpener.start();
                }
            }
        });
        super.add(openRemoteMacroFileMenuItem);
    }

    private void addMacroExecutionTool() {
        JMenuItem menuItem = new JMenuItem("Macro Execution Uitlity");
        menuItem.addActionListener(e -> {
            MacroExecutionDialog dialog = new MacroExecutionDialog((Frame)SupporterMain.getMainFrame(), false);
            dialog.show(true);
        });
        super.add(menuItem);
    }

    private JniorInfo[] getSelectedJniors() {
        JniorSelectionDialog jniorSelectionDialog = new JniorSelectionDialog((Frame)SupporterMain.getMainFrame(), true);
        jniorSelectionDialog.setSelectionType(0);
        jniorSelectionDialog.setVisible(true);
        JniorInfo[] selectedJniors = jniorSelectionDialog.getSelectedJniors();
        return selectedJniors;
    }

    private synchronized void addDevicePaneTab(String title, DevicesPane devicePane) {
        JTabbedPane rightTabPane = SupporterMain.getMainFrame().getRightTabPane();
        rightTabPane.addTab(title, devicePane);
        rightTabPane.setSelectedComponent(devicePane);
        ActionableTabComponent closeTabComponent = new ActionableTabComponent(rightTabPane);
        closeTabComponent.addActionListener(e -> {
            int userChoice = JOptionPane.showConfirmDialog(null, String.format("Are you sure you want to close the devices tab for '%s'?", title), "Are you sure?", 0);
            if (0 == userChoice) {
                rightTabPane.remove(devicePane);
            }
        });
        int tabIndex = rightTabPane.indexOfComponent(devicePane);
        rightTabPane.setTabComponentAt(tabIndex, closeTabComponent);
        devicePane.addPropertyChangeListener(evt -> {
            if ("title".equalsIgnoreCase(evt.getPropertyName())) {
                for (int i = 0; i < rightTabPane.getTabCount(); ++i) {
                    Component c = rightTabPane.getComponentAt(i);
                    if (c != devicePane) continue;
                    File file = new File(devicePane.getDeviceFilePath());
                    rightTabPane.setTitleAt(i, file.getName());
                    rightTabPane.updateUI();
                }
            }
        });
    }

    private synchronized void addMacroPaneTab(String title, MacroPane macroPane) {
        JTabbedPane rightTabPane = SupporterMain.getMainFrame().getRightTabPane();
        rightTabPane.addTab(title, macroPane);
        rightTabPane.setSelectedComponent(macroPane);
        ActionableTabComponent closeTabComponent = new ActionableTabComponent(rightTabPane);
        closeTabComponent.addActionListener(e -> {
            int userChoice = JOptionPane.showConfirmDialog(null, String.format("Are you sure you want to close the macro tab for '%s'?", title), "Are you sure?", 0);
            if (0 == userChoice) {
                rightTabPane.remove(macroPane);
            }
        });
        int tabIndex = rightTabPane.indexOfComponent(macroPane);
        rightTabPane.setTabComponentAt(tabIndex, closeTabComponent);
        macroPane.addPropertyChangeListener(evt -> {
            if ("title".equalsIgnoreCase(evt.getPropertyName())) {
                for (int i = 0; i < rightTabPane.getTabCount(); ++i) {
                    Component c = rightTabPane.getComponentAt(i);
                    if (c != macroPane) continue;
                    File file = new File(macroPane.getMacroFilePath());
                    rightTabPane.setTitleAt(i, file.getName());
                    rightTabPane.updateUI();
                }
            }
        });
    }
}

