/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.backup;

import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.protocols.jmpprotocol.helpers.DownloadFileHelper;
import com.integ.protocols.websockets.WebSocketClient;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public abstract class DownloadLogic {
    protected final JSONObject _fileJson;
    protected final String _filepath;
    private int _serialNumber;
    protected int _savedDownloadCount = 0;
    protected long _savedDownloadSize = 0L;

    public DownloadLogic(JSONObject fileJson) {
        this._fileJson = fileJson;
        this._filepath = fileJson.getString("path");
    }

    public void setJniorSerialNumber(int serialNumber) {
        this._serialNumber = serialNumber;
    }

    protected int getSerialNumber() {
        if (0 == this._serialNumber) {
            throw new RuntimeException("serial number required for " + this.toString());
        }
        return this._serialNumber;
    }

    public String getRemotePath() {
        return this._filepath;
    }

    public abstract String getStorageDirectory();

    public abstract String getLocalPath();

    public abstract boolean isFileNeeded();

    public String whyNotNeeded() {
        throw new RuntimeException("should not be called because download logic returns that the file is needed unless it is overridden");
    }

    public int getSavedDownloadCount() {
        return this._savedDownloadCount;
    }

    public long getSavedDownloadSize() {
        return this._savedDownloadSize;
    }

    public final File download(WebSocketClient websocketClient) throws NoSuchAlgorithmException {
        DownloadFileHelper downloadFile = new DownloadFileHelper(websocketClient, this._filepath);
        byte[] fileContentBytes = downloadFile.getContents();
        if (null != fileContentBytes && 0 <= fileContentBytes.length) {
            File file = this.saveFileAs(fileContentBytes);
            if (null != file) {
                long dateTimestamp = this._fileJson.getLong("date") * 1000L;
                file.setLastModified(dateTimestamp);
            }
            return file;
        }
        return null;
    }

    public abstract File saveFileAs(byte[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFileAs(String localFilePath, byte[] fileContentBytes) throws IOException {
        File file = new File(localFilePath);
        FileOutputStream outputStream = null;
        try {
            ArrayList<File> parentFiles = new ArrayList<File>();
            File parentFile = file.getParentFile();
            while (!parentFile.exists()) {
                parentFiles.add(0, parentFile);
                parentFile = parentFile.getParentFile();
            }
            while (0 < parentFiles.size()) {
                parentFile = (File)parentFiles.remove(0);
                if (parentFile.exists()) continue;
                System.out.println("create " + parentFile.getPath());
                parentFile.mkdir();
            }
            if (null != fileContentBytes) {
                outputStream = new FileOutputStream(localFilePath);
                outputStream.write(fileContentBytes);
                outputStream.flush();
            }
        }
        finally {
            if (null != outputStream) {
                outputStream.close();
            }
        }
    }

    public String getFileMd5() {
        try {
            byte[] fileContentBytes = FileUtils.readAllBytes(this._filepath);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(fileContentBytes);
            byte[] digest = md.digest();
            return HexUtils.bytesToHex(digest).toUpperCase();
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            Logger.getLogger(DownloadLogic.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(String.format("Unable to get MD5 for %s", this._filepath));
        }
    }
}

