/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.net.beacon.messages;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.messages.BeaconMessage;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.HexUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class AllInfoBeaconMessage
extends BeaconMessage {
    public AllInfoBeaconMessage(int serialNumber) {
        super(serialNumber, "ALL_INFO");
    }

    @Override
    public void parse(byte[] messageBytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(messageBytes);
            DataInputStream dis = new DataInputStream(bais);
            this._jniorInfo.Gateway = Beacon.readString(dis);
            this._jniorInfo.PrimaryDns = Beacon.readString(dis);
            this._jniorInfo.SecondaryDns = Beacon.readString(dis);
            this._jniorInfo.DnsTimeout = dis.readInt();
            this._jniorInfo.DhcpServer = Beacon.readString(dis);
            this._jniorInfo.DomainName = Beacon.readString(dis);
            this._jniorInfo.Timezone = Beacon.readString(dis);
            this._jniorInfo.DhcpEnabled = dis.readBoolean();
            if (0 == dis.available()) {
                return;
            }
            this._jniorInfo.Nonce = Beacon.readString(dis);
        }
        catch (Exception ex) {
            Exception ex2 = new Exception(this._serialNumber + " error", ex);
            String stacktrace = ExceptionUtils.getStackTrace(ex2);
            Beacon.LOGGER.severe(stacktrace);
            Beacon.LOGGER.severe("processAnnouncement:\n" + HexUtils.hexDump(messageBytes, 0, messageBytes.length));
        }
    }
}

