/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.janoslib.net.beacon.Version;
import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.updater.JanosUpd;
import com.integ.supporter.updater.JanosVersion;
import com.integ.supporter.updater.steps.FtpStep;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UpdateSeries4OSStep
extends FtpStep {
    protected String _version = "";
    private JanosVersion _remoteJanosVersion;

    public UpdateSeries4OSStep(String name) {
        super(name);
        this._type = "UpdateSeries4OSProperty";
    }

    public UpdateSeries4OSStep(Element xmlElement) {
        super(xmlElement);
        System.out.println("xmlElement: " + xmlElement.toString());
        this._version = this.getChildNodeString("Version");
        System.out.println("Version: " + this._version);
    }

    @Override
    public final String getRemoteFolder() {
        try {
            if (0 > this._remoteJanosVersion.compareTo(JanosVersion.getFromString("1.0.2"))) {
                return "flash";
            }
        }
        catch (Exception ex) {
            Logger.getLogger(UpdateSeries4OSStep.class.getName()).log(Level.SEVERE, null, ex);
        }
        return "temp";
    }

    @Override
    public void setAbsoluteFilePath(String localFileString) {
        super.setAbsoluteFilePath(localFileString);
        File localFile = new File(localFileString);
        JanosUpd.JanosFileInformation janosFileInformation = JanosUpd.getInformation(localFile);
        if (null != janosFileInformation.BuildTag) {
            this.setVersion(Version.getVersionFromBuildTag(janosFileInformation.BuildTag).toString());
        } else {
            this.setVersion(janosFileInformation.Version);
        }
    }

    public String getVersion() {
        return this._version;
    }

    private JanosVersion getLocalVersion() throws Exception {
        String localVersion = this.getVersion();
        JanosVersion localJanosVersion = JanosVersion.getFromString(localVersion);
        ZipEntry zipEntry = this._updateProjectFile.getEntryForFile(this._localFile);
        if (null != zipEntry) {
            byte[] fileContentBytes = ZipUtils.extractEntry(this._updateProjectFile.getFilePath(), zipEntry.getName());
            JanosUpd.JanosFileInformation janosUpdInformation = JanosUpd.getInformation(fileContentBytes);
            if (null != janosUpdInformation.BuildTag) {
                localJanosVersion = JanosVersion.getFromBuildTag(janosUpdInformation.BuildTag);
                localVersion = localJanosVersion.toString();
            }
        }
        return localJanosVersion;
    }

    private JanosVersion getRemoteVersion() throws Exception {
        String remoteVersion = this._jniorUpdateControlConnection.exec("registry $version");
        int equalPos = remoteVersion.indexOf("=");
        if (-1 != equalPos) {
            remoteVersion = remoteVersion.substring(equalPos + 1);
            remoteVersion = remoteVersion.trim();
            this._logger.info(String.format("  remote version: %s", remoteVersion));
        }
        JanosVersion remoteJanosVersion = JanosVersion.getFromString(remoteVersion);
        String buildTag = this._jniorUpdateControlConnection.exec("registry $buildtag");
        if (!"".equals(buildTag) && !buildTag.contains("not defined") && -1 != (equalPos = buildTag.indexOf("="))) {
            int eolPos = buildTag.indexOf("\r\n", equalPos);
            if (-1 == eolPos) {
                eolPos = buildTag.length();
            }
            buildTag = buildTag.substring(equalPos + 1, eolPos);
            buildTag = buildTag.trim();
            this._logger.info(String.format("  buildTag: %s", buildTag));
            remoteJanosVersion = JanosVersion.getFromBuildTag(buildTag);
            remoteVersion = remoteJanosVersion.toString();
        }
        return remoteJanosVersion;
    }

    void setVersion(String version) {
        String oldVersion = this._version;
        this._version = version;
        this._changes.firePropertyChange("Version", oldVersion, version);
    }

    @Override
    public Element getXmlElement(Document document) {
        Element xmlElement = super.getXmlElement(document);
        Element element = document.createElement("Version");
        element.appendChild(document.createTextNode(this._version));
        xmlElement.appendChild(element);
        return xmlElement;
    }

    @Override
    public boolean execute() throws Exception {
        int retry = 5;
        try {
            String jrupdateCommand;
            this._force = true;
            if (4 != this._jniorInfo.getSeries()) {
                throw new RuntimeException("The target JNIOR is not a series 4 jnior");
            }
            JanosVersion localJanosVersion = this.getLocalVersion();
            this._remoteJanosVersion = this.getRemoteVersion();
            this._logger.info(String.format("    local version: %s, remote version: %s", localJanosVersion, this._remoteJanosVersion));
            if (0 == this._remoteJanosVersion.compareTo(localJanosVersion)) {
                this._summary = "  JANOS " + this._version + " already installed";
                this._logger.info(this._summary);
                return true;
            }
            super.execute();
            this._logger.info("Kill all applications before performing jrupdate");
            this._jniorUpdateControlConnection.exec("kill -a", 10000);
            long start = System.currentTimeMillis();
            if (0 > this._remoteJanosVersion.compareTo(JanosVersion.getFromString("1.0.2"))) {
                jrupdateCommand = "jrupdate -u " + this.getRemotePath() + "\r\n";
                this._logger.info(jrupdateCommand);
                this._jniorUpdateControlConnection.send(jrupdateCommand);
                Thread.sleep(1000L);
                this._jniorUpdateControlConnection.exec("y", 60000);
                this._jniorUpdateControlConnection.exec("reboot -f", 60000);
            } else {
                jrupdateCommand = "jrupdate -fup " + this.getRemotePath();
                this._logger.info(jrupdateCommand);
                this._jniorUpdateControlConnection.exec(jrupdateCommand, 60000);
            }
            long elapsed = System.currentTimeMillis() - start;
            this._logger.info(String.format("  jrupdate took %.2f seconds", (double)elapsed / 1000.0));
            this._summary = "JANOS updated to " + this._version;
            this._jniorUpdateControlConnection.disconnect();
            Thread.sleep(10000L);
            do {
                Thread.sleep(10000L);
                if (!this._jniorUpdateControlConnection.connect()) continue;
                this._updateProjectExecutor.clearRebootFlag();
                break;
            } while (0 < --retry);
        }
        catch (Exception ex) {
            Logger.getLogger(UpdateSeries4OSStep.class.getName()).severe(ex.getMessage());
        }
        return 0 < retry;
    }
}

