/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.toasts;

import com.integ.janoslib.utils.ThreadUtils;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.toasts.EaseOutBounce;
import com.integ.supporter.ui.toasts.OptionPaneToast;
import com.integ.supporter.ui.toasts.ToastAnimation;
import com.integ.supporter.ui.toasts.ToastAnimator;
import com.integ.supporter.ui.toasts.ToastFadeAnimation;
import com.integ.supporter.ui.toasts.ToastMoveAnimation;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class ToastNotifications {
    private static final int MARGIN = 12;
    private static final int ANIMATION_DURATION = 350;
    private static final Object DISPLAY_LOCK = new Object();
    private static final ToastNotifications INSTANCE = new ToastNotifications();
    private static final HashMap<OptionPaneToast, JWindow> Toasts = new HashMap();
    private static final ArrayList<JWindow> ToastList = new ArrayList();
    private final Container _container = SupporterMain.getMainFrame().getContentPane();

    public static ToastNotifications getInstance() {
        return INSTANCE;
    }

    private ToastNotifications() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(OptionPaneToast optionPaneToast) {
        SwingUtilities.invokeLater(() -> {
            if (null == optionPaneToast) {
                throw new RuntimeException("option pane toast is null");
            }
            Object object = DISPLAY_LOCK;
            synchronized (object) {
                JWindow window = new JWindow(SupporterMain.getMainFrame());
                window.add(optionPaneToast);
                window.setBackground(Color.WHITE);
                window.setFocusable(true);
                window.setFocusableWindowState(true);
                window.pack();
                try {
                    HashMap<OptionPaneToast, JWindow> hashMap = Toasts;
                    synchronized (hashMap) {
                        optionPaneToast.updateUI();
                        Toasts.put(optionPaneToast, window);
                        ToastList.add(window);
                        this.fadeIn(window);
                        this.slideIn(window);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        if (optionPaneToast.getModal()) {
            Object object = DISPLAY_LOCK;
            synchronized (object) {
                try {
                    DISPLAY_LOCK.wait();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (-1 != optionPaneToast.getAutoHideDuration()) {
            new Thread(() -> {
                ThreadUtils.sleep(optionPaneToast.getAutoHideDuration());
                this.hide(optionPaneToast);
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide(OptionPaneToast optionPaneToast) {
        Object object = Toasts;
        synchronized (object) {
            if (Toasts.containsKey(optionPaneToast)) {
                try {
                    JWindow window2 = Toasts.remove(optionPaneToast);
                    ToastList.remove(window2);
                    if (null != window2 && this._container.isVisible()) {
                        this.fadeOut(window2);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (optionPaneToast.getModal()) {
            object = DISPLAY_LOCK;
            synchronized (object) {
                DISPLAY_LOCK.notify();
            }
        }
    }

    private void slideIn(JWindow window) {
        System.out.println("slideIn: window = " + window);
        int newToastHeight = window.getSize().height;
        if (!Toasts.isEmpty()) {
            ArrayList toasts = (ArrayList)ToastList.clone();
            System.out.println("slideIn: toasts.size() = " + toasts.size());
            ArrayList<ToastAnimation> animations = ToastAnimator.getAnimations();
            for (ToastAnimation animation : animations) {
                JWindow animationWindow = animation.getWindow();
                if (animationWindow == window || !toasts.contains(window) || !(animation instanceof ToastMoveAnimation)) continue;
                ToastMoveAnimation toastMoveAnimation = (ToastMoveAnimation)animation;
                toasts.remove(toastMoveAnimation.getWindow());
                Point p = toastMoveAnimation.getDestination();
                System.out.println(toastMoveAnimation.getWindow().hashCode() + " slideIn: p = " + p);
                p.y -= newToastHeight + 12;
                toastMoveAnimation.setDestination(p);
                System.out.println(toastMoveAnimation.getWindow().hashCode() + " slideIn: p = " + p);
            }
            System.out.println("slideIn: toasts.size() = " + toasts.size());
            if (!toasts.isEmpty()) {
                for (JWindow toastWindow : toasts) {
                    if (toastWindow == window) continue;
                    try {
                        int newY = toastWindow.getLocation().y - newToastHeight - 12;
                        ToastAnimator.add(new ToastMoveAnimation(toastWindow, new Point(toastWindow.getLocation().x, newY), 350));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        Point startLocation = this.getStartLocation(window);
        window.setLocation(startLocation);
        Point destainationLocation = this.getDestinationLocation(window);
        ToastAnimator.add(new ToastMoveAnimation(window, destainationLocation, 350, new EaseOutBounce()));
    }

    private void fadeIn(JWindow window) {
        window.setOpacity(0.0f);
        window.setVisible(true);
        ToastAnimator.add(new ToastFadeAnimation(window, 1.0f, 350));
    }

    public void fadeOut(JWindow window) {
        ToastAnimator.add(new ToastFadeAnimation(window, 0.0f, 350));
    }

    private Point getStartLocation(JWindow window) {
        Point containerScreenLocation = this._container.getLocationOnScreen();
        int mainFrameWidth = this._container.getWidth();
        int x = mainFrameWidth - window.getWidth() - 12 + containerScreenLocation.x;
        int mainFrameHeight = SupporterMain.getMainFrame().getHeight();
        int y = mainFrameHeight + 12;
        return new Point(x, y);
    }

    private Point getDestinationLocation(JWindow window) {
        Point containerScreenLocation = this._container.getLocationOnScreen();
        int mainFrameWidth = this._container.getWidth();
        int x = mainFrameWidth - window.getWidth() - 12 + containerScreenLocation.x;
        int statusBarHeight = SupporterMain.getMainFrame().getStatusBar().getHeight();
        int y = containerScreenLocation.y + this._container.getHeight() - window.getHeight() - statusBarHeight - 12;
        return new Point(x, y);
    }
}

