/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.layout;

import com.integ.supporter.Constants;
import com.integ.supporter.beacon.BeaconTab;
import com.integ.supporter.config.GeneralConfig;
import com.integ.supporter.jrget.JrGetTab;
import com.integ.supporter.snapshot.SnapshotProgressCollection;
import com.integ.supporter.snapshot.SnapshotTab;
import com.integ.supporter.ui.ActionableTabComponent;
import com.integ.supporter.ui.InProgressTabComponent;
import com.integ.supporter.ui.NotificationPane;
import com.integ.supporter.ui.ResizablePanel;
import com.integ.supporter.ui.StatusBar;
import com.integ.supporter.updater.UpdateProgressCollection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class MainFrame
extends JFrame {
    public static final String SPLIT_PANE_LAYOUT = "split-pane";
    public static final String TABBED_PANE_LAYOUT = "tabbed-pane";
    private final JSplitPane _mainSplitPane = new JSplitPane();
    private final JTabbedPane _leftTabbedPane = new JTabbedPane();
    private final JTabbedPane _rightTabbedPane = new JTabbedPane();
    private final StatusBar StatusBar = new StatusBar();
    private String _className = null;
    private InProgressTabComponent _updatesInProgressTabCompopnent;
    private InProgressTabComponent _snapshotsInProgressTabCompopnent;
    private final JInternalFrame _internalFrame = new JInternalFrame();
    private final JPanel _notificationsGlassPane = new JPanel(new BorderLayout());

    public MainFrame(String title) {
        super(title);
        this.addResizeHandler();
    }

    public void initUI() {
        this.initContentLayer();
        this.initNotificationsGlassPane();
        this.getLayeredPane().add((Component)this._internalFrame, "Center");
    }

    public JInternalFrame getInternalFrame() {
        return this._internalFrame;
    }

    public JTabbedPane getRightTabPane() {
        return this._rightTabbedPane;
    }

    private void initContentLayer() {
        super.setLayout(new BorderLayout());
        this._mainSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this._mainSplitPane.setLeftComponent(this.initLeftTabbedPane());
        this._mainSplitPane.setRightComponent(this.initRightTabbedPane());
        super.add((Component)this._mainSplitPane, "Center");
        super.add((Component)this.StatusBar, "South");
    }

    private Component initLeftTabbedPane() {
        this._leftTabbedPane.setFocusable(false);
        this._leftTabbedPane.addTab("Beacon", BeaconTab.getInstance());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this._leftTabbedPane, "Center");
        return panel;
    }

    private Component initRightTabbedPane() {
        this.addUpdatesTab();
        this.addSnapshotsTab();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this._rightTabbedPane, "Center");
        return panel;
    }

    private void initNotificationsGlassPane() {
        this._notificationsGlassPane.setOpaque(false);
        ResizablePanel resizablePanel = new ResizablePanel();
        resizablePanel.setLayout(new BorderLayout());
        resizablePanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 2));
        resizablePanel.setMinimumSize(new Dimension(300, 0));
        resizablePanel.setMaximumSize(new Dimension(1000, 0));
        NotificationPane notificationPane = new NotificationPane();
        resizablePanel.add((Component)notificationPane, "Center");
        this._notificationsGlassPane.add((Component)resizablePanel, "East");
        final JPanel transparentMenuBarOverlay = new JPanel();
        transparentMenuBarOverlay.setOpaque(false);
        this.getJMenuBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                double osVersion;
                int menuBarHeight = 0;
                if (Constants.OS_NAME.toLowerCase().startsWith("windows") && 10.0 > (osVersion = Double.parseDouble(System.getProperty("os.version")))) {
                    menuBarHeight = MainFrame.this.getJMenuBar().getHeight();
                }
                transparentMenuBarOverlay.setPreferredSize(new Dimension(0, menuBarHeight));
            }
        });
        this._notificationsGlassPane.add((Component)transparentMenuBarOverlay, "North");
        final JPanel transparentStatusBarOverlay = new JPanel();
        transparentStatusBarOverlay.setOpaque(false);
        this.getStatusBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int statusBarHeight = MainFrame.this.getStatusBar().getHeight();
                transparentStatusBarOverlay.setPreferredSize(new Dimension(0, statusBarHeight));
            }
        });
        this._notificationsGlassPane.add((Component)transparentStatusBarOverlay, "South");
        this._notificationsGlassPane.setVisible(false);
    }

    private void addResizeHandler() {
        super.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                String className;
                MainFrame frame = (MainFrame)e.getSource();
                int width = frame.getWidth();
                int height = frame.getHeight();
                String string = className = width >= 1200 && height >= 100 ? MainFrame.SPLIT_PANE_LAYOUT : MainFrame.TABBED_PANE_LAYOUT;
                if (MainFrame.TABBED_PANE_LAYOUT.equals(className)) {
                    MainFrame.this._rightTabbedPane.setTabComponentAt(0, null);
                }
                if (null == MainFrame.this._className) {
                    className = GeneralConfig.getView();
                }
                if (!className.equalsIgnoreCase(MainFrame.this._className)) {
                    MainFrame.this.setView(className);
                }
            }
        });
    }

    private void setView(String className) {
        this._className = className;
        GeneralConfig.setView(className);
        if (TABBED_PANE_LAYOUT.equals(className)) {
            this._rightTabbedPane.insertTab("Beacon", null, BeaconTab.getInstance(), null, 0);
            int width = this.getWidth();
            int height = this.getHeight();
            if (width >= 1200 && height >= 100) {
                ActionableTabComponent actionableTabComponent = new ActionableTabComponent(this._rightTabbedPane, "resources/chevron-left.svg", 0.0234375f, 4);
                actionableTabComponent.addActionListener(e -> this.setView(SPLIT_PANE_LAYOUT));
                this._rightTabbedPane.setTabComponentAt(0, actionableTabComponent);
            }
            this._mainSplitPane.setLeftComponent(null);
            this._mainSplitPane.setDividerSize(0);
            this._rightTabbedPane.setSelectedComponent(BeaconTab.getInstance());
        } else if (SPLIT_PANE_LAYOUT.equals(className)) {
            this._leftTabbedPane.insertTab("Beacon", null, BeaconTab.getInstance(), null, 0);
            ActionableTabComponent actionableTabComponent = new ActionableTabComponent(this._leftTabbedPane, "resources/chevron-right.svg", 0.0234375f);
            actionableTabComponent.addActionListener(e -> this.setView(TABBED_PANE_LAYOUT));
            this._leftTabbedPane.setTabComponentAt(0, actionableTabComponent);
            this._mainSplitPane.setLeftComponent(this._leftTabbedPane);
            this._mainSplitPane.setDividerSize(5);
        }
    }

    public StatusBar getStatusBar() {
        return this.StatusBar;
    }

    public void showSnapshotsPane() {
        this._rightTabbedPane.setSelectedComponent(SnapshotTab.getInstance());
    }

    public void showUpdatesPane() {
        this._rightTabbedPane.setSelectedComponent(JrGetTab.getInstance());
    }

    public void toggleNotifications() {
        if (!this._notificationsGlassPane.isVisible()) {
            this.showNotifications();
        } else {
            this.hideNotifications();
        }
    }

    public void showNotifications() {
        this.setGlassPane(this._notificationsGlassPane);
        this._notificationsGlassPane.setVisible(true);
    }

    public void hideNotifications() {
        this._notificationsGlassPane.setVisible(false);
    }

    private void addUpdatesTab() {
        this._rightTabbedPane.addTab("Updates", JrGetTab.getInstance());
        this._updatesInProgressTabCompopnent = new InProgressTabComponent(this._rightTabbedPane);
        this._rightTabbedPane.setTabComponentAt(0, this._updatesInProgressTabCompopnent);
        UpdateProgressCollection.getInstance().addChangeListener(e -> {
            int activeCount = UpdateProgressCollection.getInstance().getActiveCount();
            this._updatesInProgressTabCompopnent.setInPorgress(0 != activeCount);
        });
    }

    private void addSnapshotsTab() {
        this._rightTabbedPane.addTab("Snapshots", SnapshotTab.getInstance());
        this._snapshotsInProgressTabCompopnent = new InProgressTabComponent(this._rightTabbedPane);
        this._rightTabbedPane.setTabComponentAt(1, this._snapshotsInProgressTabCompopnent);
        SnapshotProgressCollection.getInstance().addChangeListener(e -> {
            int activeCount = SnapshotProgressCollection.getInstance().getActiveCount();
            this._snapshotsInProgressTabCompopnent.setInPorgress(0 != activeCount);
        });
    }
}

