/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon.menus;

import com.integ.janoslib.net.beacon.Beacon;
import com.integ.janoslib.net.beacon.BeaconRebooter;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.net.beacon.commands.QueryCommand;
import com.integ.janoslib.net.beacon.commands.ResetAttentionFlagCommand;
import com.integ.janoslib.net.beacon.commands.SetHostnameCommand;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.JniorItem;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.OpenClassicApplet;
import com.integ.supporter.OpenTaskManagerApplet;
import com.integ.supporter.OpenTelnetConsole;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.WebUrlLauncher;
import com.integ.supporter.beacon.BeaconTab;
import com.integ.supporter.beacon.DoGetNetworkCapture;
import com.integ.supporter.beacon.MemoryPlotPane;
import com.integ.supporter.beacon.dialogs.ConfigurationDialog;
import com.integ.supporter.beacon.menus.SetTime;
import com.integ.supporter.snapshot.SnapshotTab;
import com.integ.supporter.ui.ActionableTabComponent;
import com.integ.supporter.ui.JLinkLabel;
import com.integ.supporter.ui.layout.MainFrame;
import com.integ.supporter.ui.toasts.InProgressMessageToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.net.util.SubnetUtils;

public class BeaconPopupMenu
extends JPopupMenu {
    private final BeaconTab _beaconTab;
    private final JMenuItem _queryAllMenuItem = new JMenuItem("Query All");
    private final JMenuItem _querySubnetMenuItem = new JMenuItem("Query Subnet");
    private final JMenuItem _queryMenuItem = new JMenuItem("Query");
    private final JMenuItem _identifyMenuItem = new JMenuItem("Identify");
    private final JMenuItem _setHostnameMenuItem = new JMenuItem("Set Hostname");
    private final JMenuItem _setTimeMenuItem = new JMenuItem("Set Time");
    private final JMenuItem _enableDHCPMenuItem = new JMenuItem("Enable DHCP");
    private final JMenuItem _disableDHCPMenuItem = new JMenuItem("Disable DHCP");
    private final JMenuItem _configurationMenuItem = new JMenuItem("IP Configuration");
    private final JMenuItem _resetAttentionFlagMenuItem = new JMenuItem("Reset Attention Flag");
    private final JMenuItem _rebootMenuItem = new JMenuItem("Reboot");
    private final JMenuItem _launchDcpMenuItem = new JMenuItem("Launch WebUI...");
    private final JMenuItem _openTelnetMenuItem = new JMenuItem("Open Telnet...");
    private final JMenuItem _openClassicAppletMenuItem = new JMenuItem("Open Classic Applet...");
    private final JMenuItem _openTaskManagerAppletMenuItem = new JMenuItem("Open Task Manager Applet...");
    private final JMenuItem _takeSnapshotMenuItem = new JMenuItem("Take Snapshot...");
    private final JMenuItem _takeBackupMenuItem = new JMenuItem("Take Backup...");
    private final JMenuItem _getNetworkCaptureMenuItem = new JMenuItem("Get Network Capture...");
    private final JMenuItem _backupNowMenuItem = new JMenuItem("Backup Now");
    private final JMenuItem _showJniorsysLogMenuItem = new JMenuItem("Show jniorsys.log");
    private final JMenuItem _showErrorsLogMenuItem = new JMenuItem("Show errors.log");
    private final JMenuItem _removeErrorsLogMenuItem = new JMenuItem("Remove errors.log");
    private final JMenuItem _showDumpLogMenuItem = new JMenuItem("Show dump.log");
    private final JMenuItem _removeDumpLogMenuItem = new JMenuItem("Remove dump.log");
    private final JMenuItem _copyFieldMenuItem = new JMenuItem("Copy Field");
    private final JSeparator _chartSeparator = new JPopupMenu.Separator();
    private final JMenuItem _chartJniorMenuItem = new JMenuItem("Chart Memory and CPU Usage");
    private int _x;
    private int _y;
    private boolean _easterEggModifiersPressed;
    private int authenticationFailedOccurances = 0;

    public BeaconPopupMenu(BeaconTab beaconTab) {
        this.initComponents();
        this._beaconTab = beaconTab;
    }

    private void initComponents() {
        this.setMinimumSize(new Dimension(200, 1));
        this.addPopupMenuListener();
        this.addQueryAllMenuItem();
        this.addSubnetMenuItem();
        this.addQueryMenuItem();
        this.addSeparator();
        this.addIdentifyMenuItem();
        this.addSetHostnameMenuItem();
        this.addSetTimeMenuItem();
        this.addConfigurationMenuItem();
        this.addResetAttentionFlagsMenuItem();
        this.addRebootMenuItem();
        this.addSeparator();
        this.launchWebUIMenuItem();
        this.addOpenClassicAppletMenuItem();
        this.addOpenTaskManagerAppletMenuItem();
        this.addOpenTelnetMenuItem();
        this.addTakeSnapshotMenuItem();
        this.addGetNetworkCaptureMenuItem();
        this.addSeparator();
        this.addShowJniorSysLogMenuItem();
        this.addShowErrorsLogMenuItem();
        this.addRemoveErrorsLogMenuItem();
        this.addShowDumpLogMenuItem();
        this.addRemoveDumpLogMenuItem();
        this.addSeparator();
        this.addCopyFieldMenuItem();
        this.add(this._chartSeparator);
        this.addChartJniorMenutItem();
    }

    private void addPopupMenuListener() {
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JniorItem jniorItem;
                BeaconTab.LOGGER.info("beacon popup will become visible");
                if (!BeaconPopupMenu.this._easterEggModifiersPressed) {
                    BeaconPopupMenu.this._chartSeparator.setVisible(false);
                    BeaconPopupMenu.this._chartJniorMenuItem.setVisible(false);
                }
                int selectedRowCount = BeaconPopupMenu.this._beaconTab.getSelectedRowCount();
                BeaconPopupMenu.this._queryMenuItem.setEnabled(0 < selectedRowCount);
                BeaconPopupMenu.this._identifyMenuItem.setEnabled(0 < selectedRowCount);
                BeaconPopupMenu.this._setHostnameMenuItem.setEnabled(1 == selectedRowCount);
                BeaconPopupMenu.this._configurationMenuItem.setEnabled(1 == selectedRowCount);
                BeaconPopupMenu.this._rebootMenuItem.setEnabled(0 < selectedRowCount);
                BeaconPopupMenu.this._openTelnetMenuItem.setEnabled(0 < selectedRowCount);
                BeaconPopupMenu.this._copyFieldMenuItem.setEnabled(0 < selectedRowCount);
                BeaconPopupMenu.this._setTimeMenuItem.setEnabled(0 < selectedRowCount);
                BeaconPopupMenu.this._showJniorsysLogMenuItem.setEnabled(0 < selectedRowCount);
                BeaconPopupMenu.this._resetAttentionFlagMenuItem.setEnabled(false);
                BeaconPopupMenu.this._showErrorsLogMenuItem.setEnabled(false);
                BeaconPopupMenu.this._removeErrorsLogMenuItem.setEnabled(false);
                BeaconPopupMenu.this._showDumpLogMenuItem.setEnabled(false);
                BeaconPopupMenu.this._removeDumpLogMenuItem.setEnabled(false);
                if (1 == selectedRowCount && null != (jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem())) {
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    BeaconPopupMenu.this._setTimeMenuItem.setVisible(1 == selectedRowCount);
                    BeaconPopupMenu.this._enableDHCPMenuItem.setVisible(1 == selectedRowCount && !jniorInfo.DhcpEnabled);
                    BeaconPopupMenu.this._disableDHCPMenuItem.setVisible(1 == selectedRowCount && jniorInfo.DhcpEnabled);
                    BeaconPopupMenu.this._resetAttentionFlagMenuItem.setEnabled(0 != jniorInfo.AttentionInfo);
                    BeaconPopupMenu.this._showErrorsLogMenuItem.setEnabled(0 != (2 & jniorInfo.AttentionInfo));
                    BeaconPopupMenu.this._removeErrorsLogMenuItem.setEnabled(0 != (2 & jniorInfo.AttentionInfo));
                    BeaconPopupMenu.this._showDumpLogMenuItem.setEnabled(0 != (0x20 & jniorInfo.AttentionInfo));
                    BeaconPopupMenu.this._removeDumpLogMenuItem.setEnabled(0 != (0x20 & jniorInfo.AttentionInfo));
                    if (null != jniorInfo.Model) {
                        BeaconPopupMenu.this._launchDcpMenuItem.setVisible(!jniorInfo.Model.startsWith("3"));
                        BeaconPopupMenu.this._getNetworkCaptureMenuItem.setVisible(!jniorInfo.Model.startsWith("3"));
                        BeaconPopupMenu.this._openClassicAppletMenuItem.setVisible(jniorInfo.Model.startsWith("3"));
                        BeaconPopupMenu.this._openTaskManagerAppletMenuItem.setVisible(jniorInfo.Model.startsWith("3"));
                    }
                    if (BeaconPopupMenu.this._easterEggModifiersPressed) {
                        BeaconPopupMenu.this._chartSeparator.setVisible(true);
                        BeaconPopupMenu.this._chartJniorMenuItem.setVisible(true);
                    }
                }
                if (0 < selectedRowCount && BeaconPopupMenu.this._easterEggModifiersPressed) {
                    BeaconPopupMenu.this._chartSeparator.setVisible(true);
                    BeaconPopupMenu.this._chartJniorMenuItem.setVisible(true);
                }
                if (0 == selectedRowCount) {
                    // empty if block
                }
                BeaconTab.LOGGER.info("beacon is now visible");
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void addQueryAllMenuItem() {
        this._queryAllMenuItem.addActionListener(e -> this._beaconTab.queryAll());
        this.add(this._queryAllMenuItem);
    }

    private void addSubnetMenuItem() {
        this._querySubnetMenuItem.addActionListener(e -> {
            try {
                String queryAddress = JOptionPane.showInputDialog(this, (Object)"What Address Should be Queried?");
                if (null == queryAddress) {
                    return;
                }
                String[] allIps = new String[1];
                if (!queryAddress.contains("/")) {
                    allIps[0] = queryAddress;
                } else {
                    SubnetUtils utils = new SubnetUtils(queryAddress);
                    allIps = utils.getInfo().getAllAddresses();
                }
                for (String destinationIpAddress : allIps) {
                    Beacon.getInstance().sendCommand(InetAddress.getByName(destinationIpAddress), 4444, new QueryCommand(), null);
                    Thread.sleep(1L);
                }
                System.out.println("");
            }
            catch (UnknownHostException ex) {
                Logger.getLogger(BeaconPopupMenu.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SocketException ex) {
                Logger.getLogger(BeaconPopupMenu.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(BeaconPopupMenu.class.getName()).log(Level.SEVERE, null, ex);
            }
        });
        this.add(this._querySubnetMenuItem);
    }

    private void addQueryMenuItem() {
        this._queryMenuItem.addActionListener(e -> {
            try {
                ArrayList<JniorItem> jniorItems = this._beaconTab.getSelectedJniorItems();
                for (JniorItem jniorItem : jniorItems) {
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    Beacon.getInstance().sendCommand(InetAddress.getByName(jniorInfo.getPublicHostAddress()), jniorInfo.BeaconPort, new QueryCommand(jniorInfo.getSerialNumber()), null);
                }
            }
            catch (IOException ex) {
                BeaconTab.LOGGER.log(Level.SEVERE, null, ex);
            }
        });
        this.add(this._queryMenuItem);
    }

    private void addIdentifyMenuItem() {
        this._identifyMenuItem.addActionListener(e -> {
            try {
                ArrayList<JniorItem> selectedJniors = this._beaconTab.getSelectedJniorItems();
                for (JniorItem jniorItem : selectedJniors) {
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    this._beaconTab.identify(jniorInfo);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        this.add(this._identifyMenuItem);
    }

    private void addSetHostnameMenuItem() {
        this._setHostnameMenuItem.addActionListener(e -> new Thread(() -> {
            JniorItem jniorItem = this._beaconTab.getSelectedJniorItem();
            JniorInfo jniorInfo = jniorItem.getJniorInfo();
            this._beaconTab.getInfo(jniorInfo);
            String result = JOptionPane.showInputDialog(this._beaconTab, "Enter the hostname for " + jniorInfo.getSerialNumber(), jniorInfo.Hostname);
            if (null != result && !result.equals(jniorInfo.Hostname) && this._beaconTab.getJniorInfoCredentials(jniorInfo)) {
                Beacon.getInstance().broadcastCommand(new SetHostnameCommand(jniorInfo, result));
            }
        }).start());
        this.add(this._setHostnameMenuItem);
    }

    private void addSetTimeMenuItem() {
        this._setTimeMenuItem.addActionListener(e -> new Thread(() -> {
            JniorItem jniorItem = this._beaconTab.getSelectedJniorItem();
            JniorInfo jniorInfo = jniorItem.getJniorInfo();
            this._beaconTab.getInfo(jniorInfo);
            int result = JOptionPane.showConfirmDialog(SupporterMain.getMainFrame(), "Are you sure you want to set the time for " + jniorInfo.getSerialNumber() + "\r\n\r\nThis will set the JNIOR time to the PC time", "Set Time?", 0);
            if (0 == result) {
                SetTime setTime = new SetTime(jniorInfo);
                setTime.exec();
            }
        }).start());
        this.add(this._setTimeMenuItem);
    }

    private void addConfigurationMenuItem() {
        this._configurationMenuItem.addActionListener(e -> {
            JniorItem jniorItem = this._beaconTab.getSelectedJniorItem();
            JniorInfo jniorInfo = jniorItem.getJniorInfo();
            new Thread(() -> {
                try {
                    this._beaconTab.getInfo(jniorInfo);
                    JniorInfo jniorInfoClone = jniorInfo.clone();
                    JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor(this._beaconTab);
                    ConfigurationDialog dlg = new ConfigurationDialog((Frame)topFrame, true);
                    dlg.setJniorInfo(jniorInfoClone);
                    dlg.setLocationRelativeTo(null);
                    dlg.setVisible(true);
                    jniorInfoClone = dlg.getJniorInfo();
                    if (null != jniorInfoClone && !jniorInfoClone.equals(jniorInfo) && this._beaconTab.getJniorInfoCredentials(jniorInfoClone)) {
                        if (jniorInfoClone.DhcpEnabled != jniorInfo.DhcpEnabled) {
                            this._beaconTab.getInfo(jniorInfo);
                            jniorInfoClone.Nonce = jniorInfo.Nonce;
                            Thread.sleep(500L);
                            this._beaconTab.setDhcp(jniorInfoClone);
                            Thread.sleep(500L);
                        }
                        if (!jniorInfoClone.DhcpEnabled) {
                            System.out.println("_beaconTab.getInfo(jniorInfo)");
                            this._beaconTab.getInfo(jniorInfo);
                            System.out.println("jniorInfo.Nonce = " + jniorInfo.Nonce);
                            jniorInfoClone.Nonce = jniorInfo.Nonce;
                            System.out.println("jniorInfoClone.Nonce = " + jniorInfoClone.Nonce);
                            Thread.sleep(500L);
                            this._beaconTab.setInfo(jniorInfoClone);
                        }
                        Thread.sleep(500L);
                        this._beaconTab.getInfo(jniorInfo);
                    }
                }
                catch (Exception ex) {
                    NotificationCollection.addError("Error setting configuration for " + jniorInfo.getSerialNumber(), ex);
                }
            }).start();
        });
        this.add(this._configurationMenuItem);
    }

    private void addResetAttentionFlagsMenuItem() {
        this._resetAttentionFlagMenuItem.addActionListener(e -> new Thread(() -> {
            JniorItem jniorItem = this._beaconTab.getSelectedJniorItem();
            JniorInfo jniorInfo = jniorItem.getJniorInfo();
            if (this._beaconTab.getJniorInfoCredentials(jniorInfo)) {
                Beacon.getInstance().broadcastCommand(new ResetAttentionFlagCommand(jniorInfo));
            }
        }).start());
        this.add(this._resetAttentionFlagMenuItem);
    }

    private void addRebootMenuItem() {
        this._rebootMenuItem.addActionListener(e -> new Thread(() -> {
            try {
                ArrayList<JniorItem> selectedJniors = this._beaconTab.getSelectedJniorItems();
                for (JniorItem jniorItem : selectedJniors) {
                    new Thread(() -> {
                        JniorInfo jniorInfo = jniorItem.getJniorInfo();
                        int result = JOptionPane.showConfirmDialog(SupporterMain.getMainFrame(), "Are you sure you want to reboot " + jniorInfo.getSerialNumber(), "Confirm Reboot", 0);
                        if (0 == result) {
                            new Thread(() -> {
                                try {
                                    int i = 0;
                                    if (i < 2 && this._beaconTab.getJniorInfoCredentials(jniorInfo)) {
                                        BeaconRebooter beaconRebooter = new BeaconRebooter(jniorInfo);
                                        boolean rebooting = beaconRebooter.reboot();
                                        System.out.println("rebooting = " + rebooting);
                                        if (!rebooting) {
                                            JOptionPane.showMessageDialog(SupporterMain.getMainFrame(), "Sorry the " + jniorInfo.toString() + " failed to reboot", "Reboot Failed", 0);
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    NotificationCollection.addError("Error prompting for reboot confirmation", ex);
                                    ex.printStackTrace();
                                }
                            }).start();
                        }
                    }).start();
                }
                this._beaconTab.clearSelection();
            }
            catch (Exception ex) {
                NotificationCollection.addError("Error prompting for reboot confirmation", ex);
                ex.printStackTrace();
            }
        }).start());
        this.add(this._rebootMenuItem);
    }

    private void launchWebUIMenuItem() {
        this._launchDcpMenuItem.addActionListener(e -> {
            URI uri = null;
            try {
                ArrayList<JniorItem> selectedJniors = this._beaconTab.getSelectedJniorItems();
                for (JniorItem jniorItem : selectedJniors) {
                    String url = "http://jnior:jnior@" + jniorItem.getIpAddress();
                    uri = new URI(url);
                    Desktop.getDesktop().browse(uri);
                }
            }
            catch (IOException ioe) {
                System.out.println("The system cannot find the " + uri + " file specified");
            }
            catch (URISyntaxException use) {
                System.out.println("Illegal character in path");
            }
        });
        this.add(this._launchDcpMenuItem);
    }

    private void addOpenClassicAppletMenuItem() {
        this._openClassicAppletMenuItem.addActionListener(e -> {
            try {
                ArrayList<JniorItem> selectedJniors = this._beaconTab.getSelectedJniorItems();
                for (JniorItem jniorItem : selectedJniors) {
                    final JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    new Thread(){

                        @Override
                        public void run() {
                            OpenClassicApplet openClassicApplet = new OpenClassicApplet(jniorInfo.IpAddress);
                            openClassicApplet.execute();
                        }
                    }.start();
                }
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        });
        this.add(this._openClassicAppletMenuItem);
    }

    private void addOpenTaskManagerAppletMenuItem() {
        this._openTaskManagerAppletMenuItem.addActionListener(e -> {
            try {
                ArrayList<JniorItem> selectedJniors = this._beaconTab.getSelectedJniorItems();
                for (JniorItem jniorItem : selectedJniors) {
                    final JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    new Thread(){

                        @Override
                        public void run() {
                            OpenTaskManagerApplet openTaskManagerApplet = new OpenTaskManagerApplet(jniorInfo.IpAddress);
                            openTaskManagerApplet.execute();
                        }
                    }.start();
                }
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        });
        this.add(this._openTaskManagerAppletMenuItem);
    }

    private void addOpenTelnetMenuItem() {
        this._openTelnetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ArrayList<JniorItem> selectedJniors = BeaconPopupMenu.this._beaconTab.getSelectedJniorItems();
                    for (JniorItem jniorItem : selectedJniors) {
                        final JniorInfo jniorInfo = jniorItem.getJniorInfo();
                        new Thread(){

                            @Override
                            public void run() {
                                OpenTelnetConsole openTelnetConsole = new OpenTelnetConsole(jniorInfo.IpAddress);
                                openTelnetConsole.execute();
                            }
                        }.start();
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
                }
            }
        });
        this.add(this._openTelnetMenuItem);
    }

    private void addTakeSnapshotMenuItem() {
        this._takeSnapshotMenuItem.addActionListener(e -> {
            ArrayList<JniorItem> selectedJniors = this._beaconTab.getSelectedJniorItems();
            for (JniorItem jniorItem : selectedJniors) {
                JniorInfo jniorInfo = jniorItem.getJniorInfo();
                SnapshotTab.getInstance().startSnapshot(jniorInfo);
            }
            SupporterMain.getMainFrame().showSnapshotsPane();
        });
        this.add(this._takeSnapshotMenuItem);
    }

    private void addGetNetworkCaptureMenuItem() {
        this._getNetworkCaptureMenuItem.addActionListener(e -> {
            JPanel panel = new JPanel();
            panel.setLayout(new GridLayout(0, 1));
            panel.add(new JLabel("Are you sure you want to take a Network Capture for the selected JNIORs?"));
            panel.add(Box.createVerticalStrut(12));
            panel.add(new JLabel("A Network Capture application like WireShark will be needed to view the packet information."));
            final JLinkLabel linkLabel = new JLinkLabel("https://www.wireshark.org");
            linkLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WebUrlLauncher.go(linkLabel.getURL());
                }
            });
            panel.add(linkLabel);
            int takeNetworkCaptureChoice = JOptionPane.showConfirmDialog(null, panel, "Take Network Capture?", 0, 3);
            if (0 == takeNetworkCaptureChoice) {
                ArrayList<JniorItem> selectedJniors = this._beaconTab.getSelectedJniorItems();
                for (JniorItem jniorItem : selectedJniors) {
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    jniorInfo.AttentionInfo = (short)(jniorInfo.AttentionInfo | 0x100);
                    DoGetNetworkCapture doGetNetworkCapture = new DoGetNetworkCapture(jniorInfo);
                    InProgressMessageToast inProgressMessageToast = new InProgressMessageToast(doGetNetworkCapture);
                    ToastNotifications.getInstance().display(inProgressMessageToast);
                    doGetNetworkCapture.execute();
                }
            }
        });
        this.add(this._getNetworkCaptureMenuItem);
    }

    private void addShowJniorSysLogMenuItem() {
        this._showJniorsysLogMenuItem.addActionListener(e -> {
            try {
                JniorItem jniorItem = this._beaconTab.getSelectedJniorItem();
                JniorInfo jniorInfo = jniorItem.getJniorInfo();
                this._beaconTab.retrieveAndDisplayRemoteFiles(jniorInfo, new String[]{"jniorsys.log.bak", "jniorsys.log"}, true);
            }
            catch (IOException ex) {
                BeaconTab.LOGGER.severe(String.format("error getting jniorsys.log: %s", ExceptionUtils.getStackTrace(ex)));
                NotificationCollection.addError("Error getting jniorsys.log", ex);
            }
        });
        this.add(this._showJniorsysLogMenuItem);
    }

    private void addShowErrorsLogMenuItem() {
        this._showErrorsLogMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JniorItem jniorItem = BeaconPopupMenu.this._beaconTab.getSelectedJniorItem();
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    BeaconPopupMenu.this._beaconTab.retrieveAndDisplayRemoteFiles(jniorInfo, new String[]{"errors.log.bak", "errors.log"}, true);
                }
                catch (IOException ex) {
                    BeaconTab.LOGGER.severe(String.format("error getting errors.log: %s", ExceptionUtils.getStackTrace(ex)));
                }
            }
        });
        this.add(this._showErrorsLogMenuItem);
    }

    private void addRemoveErrorsLogMenuItem() {
        this._removeErrorsLogMenuItem.addActionListener(e -> {
            try {
                JniorItem jniorItem = this._beaconTab.getSelectedJniorItem();
                JniorInfo jniorInfo = jniorItem.getJniorInfo();
                int result = JOptionPane.showConfirmDialog(this._beaconTab, "Would you like to remove the errors.log file?", "Remove the errors.log file?", 2, 3);
                if (0 == result) {
                    boolean fileRemoved = this._beaconTab.removeRemoteFiles(jniorInfo, new String[]{"errors.log"});
                    if (!fileRemoved) {
                        JOptionPane.showMessageDialog(this._beaconTab, "There was an error trying to remove the errors.log file", "Error removing the errors.log file?", 0);
                    } else {
                        jniorInfo.AttentionInfo = (short)(jniorInfo.AttentionInfo ^ 2);
                        if (0 == jniorInfo.AttentionInfo) {
                            new Thread(() -> {
                                if (this._beaconTab.getJniorInfoCredentials(jniorInfo)) {
                                    Beacon.getInstance().broadcastCommand(new ResetAttentionFlagCommand(jniorInfo));
                                }
                            }).start();
                        }
                    }
                }
            }
            catch (IOException ex) {
                BeaconTab.LOGGER.severe(String.format("error getting errors.log: %s", ExceptionUtils.getStackTrace(ex)));
            }
        });
        this.add(this._removeErrorsLogMenuItem);
    }

    private void addShowDumpLogMenuItem() {
        this._showDumpLogMenuItem.addActionListener(e -> {
            try {
                JniorItem jniorItem = this._beaconTab.getSelectedJniorItem();
                JniorInfo jniorInfo = jniorItem.getJniorInfo();
                this._beaconTab.retrieveAndDisplayRemoteFiles(jniorInfo, new String[]{"dump.log.bak", "dump.log"}, false);
            }
            catch (IOException ex) {
                BeaconTab.LOGGER.severe(String.format("error getting dump.log: %s", ExceptionUtils.getStackTrace(ex)));
            }
        });
        this.add(this._showDumpLogMenuItem);
    }

    private void addRemoveDumpLogMenuItem() {
        this._removeDumpLogMenuItem.addActionListener(e -> {
            try {
                JniorItem jniorItem = this._beaconTab.getSelectedJniorItem();
                JniorInfo jniorInfo = jniorItem.getJniorInfo();
                int result = JOptionPane.showConfirmDialog(this._beaconTab, "Would you like to remove the dump.log file?", "Remove the dump.log file?", 2, 3);
                if (0 == result) {
                    boolean fileRemoved = this._beaconTab.removeRemoteFiles(jniorInfo, new String[]{"dump.log"});
                    if (!fileRemoved) {
                        JOptionPane.showMessageDialog(this._beaconTab, "There was an error trying to remove the dump.log file", "Error removing the dump.log file?", 0);
                    } else {
                        jniorInfo.AttentionInfo = (short)(jniorInfo.AttentionInfo ^ 0x20);
                        if (0 == jniorInfo.AttentionInfo) {
                            new Thread(() -> {
                                if (this._beaconTab.getJniorInfoCredentials(jniorInfo)) {
                                    Beacon.getInstance().broadcastCommand(new ResetAttentionFlagCommand(jniorInfo));
                                }
                            }).start();
                        }
                    }
                }
            }
            catch (IOException ex) {
                BeaconTab.LOGGER.severe(String.format("error getting dump.log: %s", ExceptionUtils.getStackTrace(ex)));
            }
        });
        this.add(this._removeDumpLogMenuItem);
    }

    private void addCopyFieldMenuItem() {
        this._copyFieldMenuItem.addActionListener(e -> {
            try {
                JTable table = this._beaconTab.getTable();
                Point point = new Point(this._x, this._y);
                int row = table.rowAtPoint(point);
                int column = table.columnAtPoint(point);
                String value = table.getValueAt(row, column).toString();
                StringSelection stringSelection = new StringSelection(value);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        this.add(this._copyFieldMenuItem);
    }

    private void addChartJniorMenutItem() {
        this._chartJniorMenuItem.addActionListener(e -> {
            try {
                ArrayList<JniorItem> jniorItems = this._beaconTab.getSelectedJniorItems();
                for (JniorItem jniorItem : jniorItems) {
                    JniorInfo jniorInfo = jniorItem.getJniorInfo();
                    MemoryPlotPane memoryPlotPane = new MemoryPlotPane();
                    memoryPlotPane.setJniorSerialNumber(jniorInfo.getSerialNumber());
                    memoryPlotPane.setIPAddress(jniorInfo.IpAddress);
                    memoryPlotPane.start();
                    MainFrame mainFrame = SupporterMain.getMainFrame();
                    JTabbedPane rightTabPane = mainFrame.getRightTabPane();
                    rightTabPane.addTab(jniorInfo.Hostname + " Memory", memoryPlotPane);
                    rightTabPane.setSelectedComponent(memoryPlotPane);
                    int tabIndex = rightTabPane.indexOfComponent(memoryPlotPane);
                    ActionableTabComponent closeTabComponent = new ActionableTabComponent(rightTabPane);
                    closeTabComponent.addActionListener(e2 -> {
                        memoryPlotPane.stop();
                        rightTabPane.remove(memoryPlotPane);
                    });
                    rightTabPane.setTabComponentAt(tabIndex, closeTabComponent);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        this.add(this._chartJniorMenuItem);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        this._x = x;
        this._y = y;
        BeaconTab.LOGGER.info(String.format("show popup at (%d, %d)", x, y));
        super.show(invoker, x, y);
    }

    private void setDHCP(JniorInfo jniorInfo, boolean enabled) throws InterruptedException {
        jniorInfo.DhcpEnabled = enabled;
        String ipAddress = jniorInfo.IpAddress;
        this._beaconTab.setDhcp(jniorInfo);
        long timeout = System.currentTimeMillis() + 15000L;
        while (System.currentTimeMillis() < timeout) {
            Thread.sleep(2000L);
            this._beaconTab.getInfo(jniorInfo);
            if (ipAddress.equals(jniorInfo.IpAddress)) continue;
            break;
        }
    }

    public void setCtrlDown(boolean controlDown) {
        this._easterEggModifiersPressed = controlDown;
    }
}

