/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Random;

public class Encryption {
    private static final int KEY_LEN = 16;
    private static final BigInteger N = new BigInteger("262955313974371039274527008763701416617");
    private static final int E = 65537;
    private static final int PADDING_LENGTH = 1;
    private final ByteArrayOutputStream _encrypted = new ByteArrayOutputStream();
    private final DataOutputStream _encryptedOutputStream = new DataOutputStream(this._encrypted);
    private final ByteArrayOutputStream _decrypted = new ByteArrayOutputStream();
    private final DataOutputStream _decryptedOutputStream = new DataOutputStream(this._decrypted);

    public byte[] rsa_encrypt(byte[] plainMessage) throws IOException {
        System.out.println(plainMessage);
        int pos = 0;
        int blockLength = 12;
        int ceil = (int)Math.ceil((float)plainMessage.length / (float)blockLength);
        for (int i = 0; i < ceil; ++i) {
            if (plainMessage.length <= pos + blockLength) {
                blockLength = plainMessage.length - pos;
            }
            byte[] block = new byte[blockLength];
            System.arraycopy(plainMessage, pos, block, 0, blockLength);
            this.rsa_encrypt_block(block);
            pos += blockLength;
        }
        byte[] encryptedBytes = this._encrypted.toByteArray();
        System.out.println("");
        System.out.println(HexUtils.hexDump(encryptedBytes));
        return encryptedBytes;
    }

    private void rsa_encrypt_block(byte[] plain_message_block) throws IOException {
        System.out.println(HexUtils.bytesToHex(plain_message_block));
        byte[] padded_message = this.pad_for_encryption(plain_message_block, 16);
        BigInteger paddedBlock = new BigInteger(padded_message);
        System.out.println(HexUtils.bytesToHex(paddedBlock.toByteArray()));
        BigInteger encrypted = this.mpnPow(paddedBlock);
        BigInteger decryptedBlock = this.mpnPow(encrypted);
        System.out.println(HexUtils.bytesToHex(decryptedBlock.toByteArray()));
        this._encryptedOutputStream.write(encrypted.toByteArray());
    }

    private byte[] pad_for_encryption(byte[] messageBytes, int targetLength) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int msglength = messageBytes.length;
        int max_msglength = targetLength - 4;
        if (msglength > max_msglength) {
            throw new RuntimeException(String.format("%d bytes needed for message, but there is only space for %d", msglength, max_msglength));
        }
        int padding_length = targetLength - msglength - 3;
        byte[] padding_bytes = new byte[padding_length];
        new Random().nextBytes(padding_bytes);
        for (int i = 0; i < padding_bytes.length; ++i) {
            if (padding_bytes[i] != 0) continue;
            int n = i;
            padding_bytes[n] = (byte)(padding_bytes[n] + 1);
        }
        baos.write(new byte[]{0, 2});
        baos.write(padding_bytes);
        baos.write(0);
        baos.write(messageBytes);
        return baos.toByteArray();
    }

    public byte[] rsa_decrypt(byte[] encryptedBytes) throws IOException {
        int pos = 0;
        int blockLength = 16;
        int ceil = (int)Math.ceil((float)encryptedBytes.length / (float)blockLength);
        for (int i = 0; i < ceil; ++i) {
            if (encryptedBytes.length <= pos + blockLength) {
                blockLength = encryptedBytes.length - pos;
            }
            byte[] block = new byte[blockLength];
            System.arraycopy(encryptedBytes, pos, block, 0, blockLength);
            this.rsa_decrypt_block(block);
            pos += blockLength;
        }
        return this._decrypted.toByteArray();
    }

    private void rsa_decrypt_block(byte[] encryptedBytes) throws IOException {
        BigInteger block = new BigInteger(encryptedBytes);
        BigInteger decrypted = this.mpnPow(block);
        byte[] decryptedBytes = decrypted.toByteArray();
        System.out.println(HexUtils.bytesToHex(decryptedBytes));
        int padding_separator_index = -1;
        for (int i = 2; i < decryptedBytes.length; ++i) {
            if (0 != decryptedBytes[i]) continue;
            padding_separator_index = i;
            break;
        }
    }

    private BigInteger mpnPow(BigInteger encryptedBytes) {
        BigInteger result = BigInteger.ONE;
        for (int exponent = 65537; 0 < exponent; exponent >>= 1) {
            if (0 == (exponent & 1)) {
                result = result.multiply(encryptedBytes);
                result = result.mod(N);
            }
            encryptedBytes = encryptedBytes.multiply(encryptedBytes);
            encryptedBytes = encryptedBytes.mod(N);
        }
        return result;
    }
}

