/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.updater.steps.ProjectStep;
import com.integ.supporter.updater.steps.ProjectStepFactory;
import com.integ.supporter.updater.steps.UnknownStepException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateProjectFile {
    private File _projectFile;
    private String _loaderFileContents;
    private final ArrayList<ZipEntry> _fileContentsArrayList = new ArrayList();
    private String _title;
    private final ArrayList<ProjectStep> _projectStepsArrayList = new ArrayList();

    public UpdateProjectFile() {
        this._title = "New";
    }

    public UpdateProjectFile(File selectedFile) {
        this._projectFile = selectedFile;
    }

    public void load() throws IOException {
        if (null != this.getFile()) {
            this.readZipFile();
        }
    }

    public void setFile(File file) {
        this._projectFile = file;
    }

    public File getFile() {
        return this._projectFile;
    }

    public String getFilePath() {
        if (null == this._projectFile) {
            return "";
        }
        return this._projectFile.getPath();
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public ZipEntry getEntryForFile(String localFile) {
        for (ZipEntry zipEntry : this._fileContentsArrayList) {
            File zipFileEntry = new File(zipEntry.getName());
            if (!zipFileEntry.getName().equalsIgnoreCase(localFile)) continue;
            return zipEntry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readZipFile() {
        System.out.println("Iterating over zip file : " + this._projectFile.getPath());
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this._projectFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryName = zipEntry.getName();
                System.out.printf("File: %s Size %d  Modified on %TD \n", entryName, zipEntry.getSize(), new Date(zipEntry.getTime()));
                if (entryName.endsWith(".ldr")) {
                    InputStream zipInputStream = zipFile.getInputStream(zipEntry);
                    byte[] entryContentBytes = ZipUtils.getEntryBytes(zipInputStream);
                    this._loaderFileContents = new String(entryContentBytes);
                    System.out.println("loaderFileContents: " + this._loaderFileContents);
                    ByteArrayInputStream loaderFileStream = new ByteArrayInputStream(this._loaderFileContents.getBytes());
                    this.getXmlFromLoaderFile(loaderFileStream);
                    continue;
                }
                this._fileContentsArrayList.add(zipEntry);
            }
            System.out.printf("Zip file %s has been loaded\n", this._projectFile.getPath());
        }
        catch (IOException ex) {
            Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
        }
        finally {
            try {
                if (null != zipFile) {
                    zipFile.close();
                }
            }
            catch (IOException ex) {
                Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
            }
        }
    }

    private void getXmlFromLoaderFile(InputStream inputStream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            document.getDocumentElement().normalize();
            Element root = document.getDocumentElement();
            System.out.println(root.getNodeName());
            Node titleNode = root.getElementsByTagName("Title").item(0);
            this._title = titleNode.getTextContent();
            System.out.println("Title: " + this._title);
            Node stepNode = root.getElementsByTagName("Steps").item(0);
            NodeList stepNodes = stepNode.getChildNodes();
            System.out.println(stepNodes.getLength() + " Steps");
            this._projectStepsArrayList.clear();
            for (int index = 0; index < stepNodes.getLength(); ++index) {
                stepNode = stepNodes.item(index);
                if (stepNode.getNodeType() != 1) continue;
                try {
                    Element xmlElement = (Element)stepNode;
                    ProjectStep projectStep = ProjectStepFactory.getProjectStep(xmlElement);
                    if (null == projectStep) continue;
                    projectStep.setUpdateProject(this);
                    projectStep.setLogger(Logger.getGlobal());
                    System.out.println(projectStep.getClass().getName() + ": " + projectStep);
                    this._projectStepsArrayList.add(projectStep);
                    continue;
                }
                catch (UnknownStepException ex) {
                    Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
                }
            }
        }
        catch (SAXException ex) {
            Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
        }
        catch (IOException ex) {
            Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
        }
        catch (ParserConfigurationException ex) {
            Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
        }
    }

    public ArrayList<ProjectStep> getSteps() {
        return this._projectStepsArrayList;
    }

    public void addStep(ProjectStep projectStep) {
        this._projectStepsArrayList.add(projectStep);
    }

    void save(File selectedFile) {
        this.buildLoaderXMLFile();
    }

    private void buildLoaderXMLFile() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement("LoadProperties");
            rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            rootElement.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            document.appendChild(rootElement);
            Element element = document.createElement("Title");
            element.appendChild(document.createTextNode(this.getTitle()));
            rootElement.appendChild(element);
            Element stepsElement = document.createElement("Steps");
            rootElement.appendChild(stepsElement);
            for (ProjectStep projectStep : this._projectStepsArrayList) {
                stepsElement.appendChild(projectStep.getXmlElement(document));
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(document);
            StreamResult console = new StreamResult(System.out);
            transformer.transform(source, console);
            File tempLdrFile = new File(SupporterMain.TEMP_DIRECTORY + this.getTitle() + ".ldr");
            StreamResult file = new StreamResult(tempLdrFile);
            transformer.transform(source, file);
            ZipUtils.addFile(this.getFile().getPath(), tempLdrFile.getPath(), "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

