/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui;

import com.integ.janoslib.utils.ExceptionUtils;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.text.Caret;
import javax.swing.text.Document;

public class TextPaneLog
extends Handler {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd-yy HH:mm:ss");
    private final JTextPane _textPane;

    public TextPaneLog(JTextPane textPane) {
        this._textPane = textPane;
        this._textPane.setFont(new Font("Courier New", 0, 11));
        this._textPane.setEditable(false);
        this._textPane.getCaret().setVisible(true);
    }

    public void log(String text) {
        try {
            Document doc = this._textPane.getDocument();
            Caret caret = this._textPane.getCaret();
            int currentCaretPos = caret.getDot();
            int textLength = doc.getLength();
            byte[] bytes = text.getBytes();
            doc.insertString(doc.getLength(), text, null);
            if (currentCaretPos == textLength) {
                textLength = doc.getLength();
                this._textPane.setCaretPosition(textLength);
            }
        }
        catch (Exception ex) {
            Logger.getGlobal().severe(ExceptionUtils.getStackTrace(ex));
        }
    }

    @Override
    public void publish(LogRecord record) {
        byte[] bytes = record.getMessage().getBytes();
        this.log(String.format("%s, %s\n", DATE_FORMAT.format(System.currentTimeMillis()), record.getMessage()));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

