/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.beacon.Beacon;
import com.integ.beacon.BeaconListener;
import com.integ.beacon.JniorInfo;
import com.integ.beacon.commands.QueryCommand;
import com.integ.janoslib.net.LoginFailedException;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.AssemblyInfo;
import com.integ.supporter.JniorControlConnection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.snapshot.FileInfo;
import com.integ.supporter.snapshot.SnapshotListener;
import com.integ.supporter.snapshot.SnapshotResult;
import java.awt.TrayIcon;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPFile;

public class Snapshot {
    private final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat SNAPSHOT_DATE_FORMAT = new SimpleDateFormat("ddMMMyyyy_HHmmss");
    private static final String[] PRE_SNAPSHOT_COMMANDS = new String[]{"date", "stats", "jrflash", "ps", "ipconfig", "netstat"};
    private static final String[] SERIES4_PRE_SNAPSHOT_COMMANDS = new String[]{"ps -v", "thd", "iolog", "extern", "netstat -c", "reg * > temp/registry.ini"};
    private static final String[] SERIES4_POST_SNAPSHOT_COMMANDS = new String[]{"rm jniorio.log", "rm auxio.log"};
    private Logger _logger;
    private JniorInfo _jniorInfo;
    private JniorControlConnection _jniorControlConnection;
    private String _rootFolder;
    private final ArrayList<FTPFile> _remoteFilesList = new ArrayList();
    private SnapshotListener _snapshotListener = null;
    private Exception _exception;
    private String _exceptionString;
    private boolean _abort;
    private File _zipFile;

    public Snapshot(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
    }

    public Logger getLogger() {
        return this._logger;
    }

    public void setLogger(Logger logger) {
        this._logger = logger;
    }

    public void setFolder(String folder) {
        this._rootFolder = folder;
    }

    public void setSnapshotListener(SnapshotListener listener) {
        this._snapshotListener = listener;
    }

    public Exception getLastException() {
        return this._exception;
    }

    public String getLastExceptionString() {
        return this._exceptionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute() throws InterruptedException {
        block68: {
            SnapshotResult result;
            long startTime;
            block66: {
                String response;
                startTime = System.currentTimeMillis();
                result = SnapshotResult.Success;
                this._logger.info(String.format("%s, Starting Snapshot for %s...\n", this.SIMPLE_DATE_FORMAT.format(new Date()), this._jniorInfo.IpAddress));
                this._logger.info(String.format("%s v%s", AssemblyInfo.getName(), AssemblyInfo.getVersion()));
                if (0 >= this._jniorInfo.getSerialNumber()) {
                    this._logger.info("Serial number is unknown, query Beacon for information...");
                    BeaconListener temporaryBeaconListener = new BeaconListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void unitUpdated(JniorInfo jniorInfo) {
                            Snapshot.this._logger.info("Beacon response for " + jniorInfo.toString());
                            Snapshot.this._jniorInfo = jniorInfo;
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                this.notifyAll();
                            }
                        }
                    };
                    Beacon.getInstance().addBeaconListener(temporaryBeaconListener);
                    Beacon.getInstance().send(InetAddress.getByName(this._jniorInfo.IpAddress), 4444, new QueryCommand());
                    Snapshot snapshot = this;
                    synchronized (snapshot) {
                        try {
                            this.wait(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    Beacon.getInstance().removeBeaconListener(temporaryBeaconListener);
                }
                this._jniorControlConnection = JniorControlConnection.getFor(this._jniorInfo, this._logger);
                String serialNumberResponse = this._jniorControlConnection.exec("registry $SerialNumber");
                Pattern pattern = Pattern.compile("= (?<serial>\\d{9})");
                String[] matcher = pattern.matcher(serialNumberResponse);
                if (matcher.find()) {
                    this._jniorInfo.setSerialNumber(Integer.valueOf(matcher.group("serial")));
                }
                String hostname = this._jniorControlConnection.exec("registry IpConfig/HostName");
                this._jniorInfo.Hostname = hostname = hostname.substring(hostname.indexOf(" = ") + 3);
                for (String preSnapshotAction : PRE_SNAPSHOT_COMMANDS) {
                    if (this._abort) {
                        throw new InterruptedException("User Aborted");
                    }
                    try {
                        this._logger.info(preSnapshotAction + "...");
                        response = this._jniorControlConnection.exec(preSnapshotAction, 120000);
                        if (null == response || "".equals(response)) continue;
                        this._logger.info(response + "\n");
                    }
                    catch (Exception ex) {
                        if (this._abort) continue;
                        result = SnapshotResult.Errors;
                        this._logger.severe(ExceptionUtils.getStackTrace(ex));
                        this._jniorControlConnection.disconnect();
                    }
                }
                if (3 != this._jniorInfo.getSeries()) {
                    for (String preSnapshotAction : SERIES4_PRE_SNAPSHOT_COMMANDS) {
                        if (this._abort) {
                            throw new InterruptedException("User Aborted");
                        }
                        try {
                            this._logger.info(preSnapshotAction + "...");
                            response = this._jniorControlConnection.exec(preSnapshotAction);
                            if (null == response || "".equals(response)) continue;
                            this._logger.info(response + "\n");
                        }
                        catch (Exception ex) {
                            if (this._abort) continue;
                            result = SnapshotResult.Errors;
                            this._logger.severe(ExceptionUtils.getStackTrace(ex));
                            this._jniorControlConnection.disconnect();
                        }
                    }
                }
                if (this._jniorControlConnection.login(this._jniorInfo.UserName, this._jniorInfo.Password)) {
                    this._logger.info("collect the files that should be downloaded\r\n");
                    this.getDirectory("/");
                    if (this._abort) {
                        throw new InterruptedException("User Aborted");
                    }
                    this._logger.info("download the collected files\r\n");
                    this.downloadFiles();
                }
                if (3 != this._jniorInfo.getSeries()) {
                    for (String postSnapshotAction : SERIES4_POST_SNAPSHOT_COMMANDS) {
                        try {
                            this._logger.info(String.format("execute %s\n", postSnapshotAction));
                            response = this._jniorControlConnection.exec(postSnapshotAction);
                            if (null == response || "".equals(response)) continue;
                            this._logger.info(response + "\n");
                        }
                        catch (Exception ex) {
                            if (this._abort) continue;
                            result = SnapshotResult.Errors;
                            this._logger.severe(ExceptionUtils.getStackTrace(ex));
                            this._jniorControlConnection.disconnect();
                        }
                    }
                }
                if (null == this._jniorControlConnection) break block66;
                try {
                    this._jniorControlConnection.disconnect();
                }
                catch (IOException ex) {
                    Logger.getLogger(Snapshot.class.getName()).severe(ex.getMessage());
                }
            }
            if (this._abort) {
                result = SnapshotResult.Aborted;
            }
            long snapshotEndTime = System.currentTimeMillis();
            long elapsedMillis = snapshotEndTime - startTime;
            long elapsedSeconds = elapsedMillis / 1000L;
            long minutes = elapsedSeconds % 3600L / 60L;
            long seconds = elapsedSeconds % 60L;
            String resultString = "completed SUCCESSFULLY";
            switch (result) {
                case Errors: {
                    resultString = "had ERRORS but COMPLETED";
                    break;
                }
                case Failed: {
                    resultString = "FAILED";
                    break;
                }
                case Aborted: {
                    resultString = "was ABORTED";
                    break;
                }
            }
            resultString = String.format("snapshot %s in %d:%02d\n", resultString, minutes, seconds);
            this._logger.info(resultString);
            SupporterMain.INSTANCE.playSound("pristine.wav");
            SupporterMain.INSTANCE.displayMessage(String.format("Snapshot for %s Complete", this._jniorInfo.IpAddress), resultString, TrayIcon.MessageType.INFO);
            if (SnapshotResult.Success == result || SnapshotResult.Errors == result) {
                try {
                    this.zipTempFolder();
                }
                catch (IOException ex) {
                    ex = new IOException("Unable to create zip file", ex);
                    this._logger.severe(ExceptionUtils.getStackTrace(ex));
                }
            }
            if (null != this._snapshotListener) {
                this._snapshotListener.snapshotResult(this, result);
            }
            break block68;
            catch (Exception ex) {
                block67: {
                    try {
                        if (!this._abort) {
                            this._logger.severe(ExceptionUtils.getStackTrace(ex));
                        }
                        result = SnapshotResult.Failed;
                        if (null == this._jniorControlConnection) break block67;
                    }
                    catch (Throwable throwable) {
                        if (null != this._jniorControlConnection) {
                            try {
                                this._jniorControlConnection.disconnect();
                            }
                            catch (IOException ex2) {
                                Logger.getLogger(Snapshot.class.getName()).severe(ex2.getMessage());
                            }
                        }
                        if (this._abort) {
                            result = SnapshotResult.Aborted;
                        }
                        long snapshotEndTime2 = System.currentTimeMillis();
                        long elapsedMillis2 = snapshotEndTime2 - startTime;
                        long elapsedSeconds2 = elapsedMillis2 / 1000L;
                        long minutes2 = elapsedSeconds2 % 3600L / 60L;
                        long seconds2 = elapsedSeconds2 % 60L;
                        String resultString2 = "completed SUCCESSFULLY";
                        switch (result) {
                            case Errors: {
                                resultString2 = "had ERRORS but COMPLETED";
                                break;
                            }
                            case Failed: {
                                resultString2 = "FAILED";
                                break;
                            }
                            case Aborted: {
                                resultString2 = "was ABORTED";
                                break;
                            }
                        }
                        resultString2 = String.format("snapshot %s in %d:%02d\n", resultString2, minutes2, seconds2);
                        this._logger.info(resultString2);
                        SupporterMain.INSTANCE.playSound("pristine.wav");
                        SupporterMain.INSTANCE.displayMessage(String.format("Snapshot for %s Complete", this._jniorInfo.IpAddress), resultString2, TrayIcon.MessageType.INFO);
                        if (SnapshotResult.Success == result || SnapshotResult.Errors == result) {
                            try {
                                this.zipTempFolder();
                            }
                            catch (IOException ex3) {
                                ex3 = new IOException("Unable to create zip file", ex3);
                                this._logger.severe(ExceptionUtils.getStackTrace(ex3));
                            }
                        }
                        if (null != this._snapshotListener) {
                            this._snapshotListener.snapshotResult(this, result);
                        }
                        throw throwable;
                    }
                    try {
                        this._jniorControlConnection.disconnect();
                    }
                    catch (IOException ex4) {
                        Logger.getLogger(Snapshot.class.getName()).severe(ex4.getMessage());
                    }
                }
                if (this._abort) {
                    result = SnapshotResult.Aborted;
                }
                snapshotEndTime = System.currentTimeMillis();
                elapsedMillis = snapshotEndTime - startTime;
                elapsedSeconds = elapsedMillis / 1000L;
                minutes = elapsedSeconds % 3600L / 60L;
                seconds = elapsedSeconds % 60L;
                resultString = "completed SUCCESSFULLY";
                switch (result) {
                    case Errors: {
                        resultString = "had ERRORS but COMPLETED";
                        break;
                    }
                    case Failed: {
                        resultString = "FAILED";
                        break;
                    }
                    case Aborted: {
                        resultString = "was ABORTED";
                        break;
                    }
                }
                resultString = String.format("snapshot %s in %d:%02d\n", resultString, minutes, seconds);
                this._logger.info(resultString);
                SupporterMain.INSTANCE.playSound("pristine.wav");
                SupporterMain.INSTANCE.displayMessage(String.format("Snapshot for %s Complete", this._jniorInfo.IpAddress), resultString, TrayIcon.MessageType.INFO);
                if (SnapshotResult.Success == result || SnapshotResult.Errors == result) {
                    try {
                        this.zipTempFolder();
                    }
                    catch (IOException ex5) {
                        ex5 = new IOException("Unable to create zip file", ex5);
                        this._logger.severe(ExceptionUtils.getStackTrace(ex5));
                    }
                }
                if (null != this._snapshotListener) {
                    this._snapshotListener.snapshotResult(this, result);
                }
            }
        }
    }

    public static boolean deleteDirectory(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            for (int i = 0; i < children.length; ++i) {
                boolean success = Snapshot.deleteDirectory(children[i]);
                if (success) continue;
                return false;
            }
        }
        boolean deleteResult = file.delete();
        System.out.println("removing file or directory : " + file.getAbsolutePath() + ": " + deleteResult);
        return deleteResult;
    }

    private boolean login() {
        block3: {
            try {
                this._logger.info("log into telnet connection");
                if (this._jniorControlConnection.login(this._jniorInfo.UserName, this._jniorInfo.Password)) {
                    this._logger.info("successfully logged into jnior connection");
                    return true;
                }
            }
            catch (LoginFailedException ex) {
                this._logger.info("login failed for telnet connection");
                if (null == this._snapshotListener) break block3;
                this._snapshotListener.loginFailed();
            }
        }
        return false;
    }

    private void getDirectory(String directory) throws InterruptedException {
        if (this._abort) {
            throw new InterruptedException("User Aborted");
        }
        try {
            FTPFile[] ftpFiles = this._jniorControlConnection.listFiles(directory);
            this._logger.info(String.format("%d files in %s", ftpFiles.length, directory));
            for (FTPFile ftpFile : ftpFiles) {
                System.out.println(String.format("  %s", ftpFile.getName()));
                if (".".equals(ftpFile.getName()) || "..".equals(ftpFile.getName())) continue;
                FileInfo fileInfo = new FileInfo(ftpFile.getName());
                String filePath = directory + "/" + ftpFile.getName();
                filePath = filePath.replaceAll("//", "/");
                ftpFile.setName(filePath);
                if (ftpFile.isDirectory()) {
                    this.getDirectory(filePath);
                    continue;
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat("mm-dd-yy H:mm:ss");
                Date date = ftpFile.getTimestamp().getTime();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                ftpFile.setTimestamp(calendar);
                this._remoteFilesList.add(ftpFile);
            }
        }
        catch (IOException ex) {
            String stackTrace = ExceptionUtils.getStackTrace(ex);
            this._logger.severe(stackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFiles() throws InterruptedException {
        File tempDirectory = new File(this._rootFolder);
        if (tempDirectory.exists()) {
            tempDirectory.delete();
        } else {
            tempDirectory.mkdir();
        }
        this._logger.info("retrieve remote files...");
        int remoteFileCount = this._remoteFilesList.size();
        block5: for (int i = 0; !this._abort && i < remoteFileCount; ++i) {
            FTPFile ftpFile = this._remoteFilesList.get(i);
            if (ftpFile.getType() == 1) continue;
            String remoteFile = ftpFile.getName();
            boolean retry = true;
            while (true) {
                try {
                    File parentFile;
                    if (this._abort) {
                        throw new InterruptedException("User Aborted");
                    }
                    this._exception = null;
                    this._exceptionString = null;
                    if (null != this._snapshotListener) {
                        this._snapshotListener.downloadFileAttempt(i + 1, remoteFileCount, remoteFile);
                    }
                    if (!remoteFile.startsWith("/")) {
                        remoteFile = "/" + remoteFile;
                    }
                    String localFileString = tempDirectory.getPath() + remoteFile;
                    File localFile = new File(localFileString);
                    ArrayList<File> parentFiles = new ArrayList<File>();
                    for (parentFile = localFile.getParentFile(); null != parentFile && !parentFile.exists(); parentFile = parentFile.getParentFile()) {
                        parentFiles.add(0, parentFile);
                    }
                    while (0 < parentFiles.size()) {
                        parentFile = (File)parentFiles.remove(0);
                        if (parentFile.exists()) continue;
                        parentFile.mkdir();
                    }
                    FileOutputStream out = new FileOutputStream(localFile.getPath());
                    try {
                        boolean result = this._jniorControlConnection.retrieveFile(remoteFile, out);
                        if (null != this._snapshotListener) {
                            this._snapshotListener.downloadFileResult(i + 1, remoteFileCount, remoteFile, result);
                        }
                        if (result) {
                            continue block5;
                        }
                    }
                    finally {
                        if (null != out) {
                            out.close();
                        }
                        System.out.println(new Date(ftpFile.getTimestamp().getTimeInMillis()));
                        localFile.setLastModified(ftpFile.getTimestamp().getTimeInMillis());
                    }
                }
                catch (Exception ex) {
                    if (!this._abort) {
                        String stacktrace;
                        this._exception = ex;
                        this._exceptionString = stacktrace = ExceptionUtils.getStackTrace(ex);
                        this._logger.severe(stacktrace);
                    }
                    if (null == this._snapshotListener) continue block5;
                    this._snapshotListener.downloadFileResult(i, remoteFileCount, remoteFile, false);
                    continue block5;
                }
                if (!retry) continue block5;
                retry = false;
            }
        }
    }

    private void zipTempFolder() throws IOException {
        File folder = new File(this._rootFolder);
        String zipFilename = String.format("%s/%d_%s@%s.zip", folder.getParent(), this._jniorInfo.getSerialNumber(), this._jniorInfo.Hostname, this.SNAPSHOT_DATE_FORMAT.format(new Date()));
        this._logger.info(String.format("create %s\n", zipFilename));
        String[] fileNames = folder.list();
        for (int i = 0; i < fileNames.length; ++i) {
            fileNames[i] = String.format("%s/%s", this._rootFolder, fileNames[i]);
        }
        ZipUtils.zip(fileNames, zipFilename);
        Snapshot.deleteDirectory(new File(this._rootFolder));
        File tempZipFile = new File(zipFilename);
        this._zipFile = new File(SupporterMain.SNAPSHOTS_FOLDER + tempZipFile.getName());
        tempZipFile.renameTo(this._zipFile);
    }

    void abort() {
        this._abort = true;
    }

    File getZipFile() {
        return this._zipFile;
    }
}

