/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.dialogs;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.RollingLog;
import com.integ.supporter.SelectedJniorItem;
import com.integ.supporter.beacon.ColumnTableSorter;
import com.integ.supporter.beacon.IpAddressComparator;
import com.integ.supporter.dialogs.IPAddressFormattedTextField;
import com.integ.supporter.dialogs.JniorSelectionTableModel;
import com.integ.supporter.helpers.IP4Validator;
import com.integ.supporter.ui.TableHeaderRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class JniorSelectionDialog
extends JDialog {
    private static final Logger LOGGER = RollingLog.getLogger("JniorSelectionDialog");
    private final ColumnTableSorter _sorter;
    private final JniorSelectionTableModel _tableModel;
    private final Hashtable<Integer, Boolean> _selectedRows = new Hashtable();
    private JTable _table;
    private JButton btnCancel;
    private JButton btnOk;
    private IPAddressFormattedTextField ipManuallyEntered;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;

    public JniorSelectionDialog(Frame parent) {
        this(parent, new JniorSelectionTableModel());
    }

    public JniorSelectionDialog(Frame parent, boolean modal) {
        this(parent, new JniorSelectionTableModel());
    }

    public JniorSelectionDialog(Frame parent, JniorSelectionTableModel tableModel) {
        super(parent, true);
        this.initComponents();
        this.setTitle("Select JNIORs");
        this._tableModel = tableModel;
        this._table = new JTable(this._tableModel);
        this._table.setSelectionMode(2);
        this._table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this._table.setFillsViewportHeight(true);
        JTableHeader header = this._table.getTableHeader();
        header.setDefaultRenderer(new TableHeaderRenderer(this._table));
        this._table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        this._table.setRowHeight(24);
        this._table.setShowVerticalLines(false);
        this._table.setShowHorizontalLines(false);
        TableColumnModel columnModel = this._table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            int width = tableModel.getColumnWidth(i);
            columnModel.getColumn(i).setPreferredWidth(width);
        }
        this._table.setAutoResizeMode(0);
        this._sorter = new ColumnTableSorter(this._table.getModel());
        this._sorter.addTableColumnComparator(4, new IpAddressComparator());
        this._table.setRowSorter(this._sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(4, SortOrder.ASCENDING));
        this._sorter.setSortKeys(sortKeys);
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int firstIndex = e.getFirstIndex();
                int lastIndex = e.getLastIndex();
                LOGGER.info(e.toString());
                if (!e.getValueIsAdjusting()) {
                    JniorSelectionDialog.this._selectedRows.clear();
                    for (int i = firstIndex; i <= lastIndex; ++i) {
                        boolean isSelected = JniorSelectionDialog.this._table.getSelectionModel().isSelectedIndex(i);
                        JniorSelectionDialog.this._selectedRows.put(i, isSelected);
                        LOGGER.info(i + " selected: " + isSelected);
                    }
                }
            }
        });
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    JTable target = (JTable)me.getSource();
                    int row = target.getSelectedRow();
                    boolean selected = (Boolean)JniorSelectionDialog.this._table.getValueAt(row, 0);
                    JniorSelectionDialog.this._table.setValueAt(!selected, row, 0);
                }
            }
        });
        this._tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (0 == e.getColumn()) {
                    LOGGER.info(String.format("type: %d, first row: %d, last row: %d, column: %d", e.getType(), e.getFirstRow(), e.getLastRow(), e.getColumn()));
                    int changedRow = e.getFirstRow();
                    int viewRow = JniorSelectionDialog.this._table.convertRowIndexToView(changedRow);
                    JniorSelectionDialog.this._table.changeSelection(viewRow, e.getColumn(), true, true);
                    Object value = JniorSelectionDialog.this._table.getValueAt(viewRow, e.getColumn());
                    int selectionMode = JniorSelectionDialog.this._table.getSelectionModel().getSelectionMode();
                    if (0 == selectionMode) {
                        for (int rowIndex = 0; rowIndex < JniorSelectionDialog.this._table.getRowCount(); ++rowIndex) {
                            boolean isSelected = JniorSelectionDialog.this._selectedRows.containsKey(rowIndex);
                            if (isSelected) continue;
                            JniorSelectionDialog.this._table.setValueAt(false, rowIndex, 0);
                        }
                    } else {
                        Enumeration keys = JniorSelectionDialog.this._selectedRows.keys();
                        while (keys.hasMoreElements()) {
                            boolean isSelected;
                            int rowIndex = (Integer)keys.nextElement();
                            if (viewRow == rowIndex || !(isSelected = ((Boolean)JniorSelectionDialog.this._selectedRows.get(rowIndex)).booleanValue())) continue;
                            JniorSelectionDialog.this._table.setValueAt(value, rowIndex, e.getColumn());
                        }
                    }
                    JniorSelectionDialog.this.checkForSelectedJnior();
                }
            }
        });
        this.jScrollPane1.setViewportView(this._table);
        this.pack();
        this.setMinimumSize(new Dimension(800, 600));
    }

    private void checkForSelectedJnior() {
        boolean jniorSelected;
        boolean selectedJniorFound = false;
        for (int rowIndex = 0; !selectedJniorFound && rowIndex < this._table.getRowCount(); selectedJniorFound |= jniorSelected, ++rowIndex) {
            jniorSelected = (Boolean)this._table.getValueAt(rowIndex, 0);
        }
        try {
            String manuallyEnteredIPAddress = this.ipManuallyEntered.getText();
            selectedJniorFound |= IP4Validator.isValid(manuallyEnteredIPAddress);
        }
        catch (Exception ex) {
            RuntimeException rex = new RuntimeException("Error getting manually entered IP Address", ex);
            String stacktrace = ExceptionUtils.getStackTrace(rex);
            Logger.getLogger(JniorSelectionDialog.class.getName()).severe(stacktrace);
        }
        this.btnOk.setEnabled(selectedJniorFound);
    }

    public void addRowSorter(int column, Comparator comparator) {
        this._sorter.addTableColumnComparator(column, comparator);
    }

    public void setSelectionType(int selectionType) {
        this._table.setSelectionMode(selectionType);
    }

    public JniorInfo[] getSelectedJniors() {
        SelectedJniorItem[] jniors;
        ArrayList<JniorInfo> selectedJniorList = new ArrayList<JniorInfo>();
        for (SelectedJniorItem selectedJniorItem : jniors = this._tableModel.getJniors()) {
            if (!selectedJniorItem.Selected) continue;
            selectedJniorList.add(selectedJniorItem.getJniorInfo());
        }
        return selectedJniorList.toArray(new JniorInfo[selectedJniorList.size()]);
    }

    public String getManuallyEneteredIPAddress() {
        return this.ipManuallyEntered.getText();
    }

    private void initComponents() {
        this.jPanel3 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.ipManuallyEntered = new IPAddressFormattedTextField();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel2.setLayout(new FlowLayout(2));
        this.ipManuallyEntered.setText("0.0.0.0");
        this.ipManuallyEntered.setMinimumSize(new Dimension(96, 20));
        this.ipManuallyEntered.setPreferredSize(new Dimension(96, 20));
        this.ipManuallyEntered.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JniorSelectionDialog.this.ipManuallyEnteredKeyReleased(evt);
            }
        });
        this.jPanel2.add(this.ipManuallyEntered);
        this.btnOk.setText("OK");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JniorSelectionDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnOk);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JniorSelectionDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnCancel);
        this.getContentPane().add((Component)this.jPanel2, "Last");
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jLabel1.setText("Use the checkboxes to select one or more JNIORs.  You can select multiple rows in the table\nbefore ticking the checkbox to select multiple JNIORs at once.");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        this.jLabel1.setVerticalTextPosition(1);
        this.jPanel1.add(this.jLabel1);
        this.getContentPane().add((Component)this.jPanel1, "First");
        this.pack();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        SelectedJniorItem[] jniors;
        for (SelectedJniorItem selectedJniorItem : jniors = this._tableModel.getJniors()) {
            selectedJniorItem.Selected = false;
        }
        this.setVisible(false);
    }

    private void ipManuallyEnteredKeyReleased(KeyEvent evt) {
        if ('\n' == evt.getKeyChar()) {
            this.setVisible(false);
        } else {
            this.checkForSelectedJnior();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(JniorSelectionDialog.class.getName()).severe(stacktrace);
        }
        catch (InstantiationException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(JniorSelectionDialog.class.getName()).severe(stacktrace);
        }
        catch (IllegalAccessException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(JniorSelectionDialog.class.getName()).severe(stacktrace);
        }
        catch (UnsupportedLookAndFeelException ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getLogger(JniorSelectionDialog.class.getName()).severe(stacktrace);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JniorSelectionDialog dialog = new JniorSelectionDialog((Frame)new JFrame(), new JniorSelectionTableModel());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

