/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema.macro;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.cinema.macro.Action;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class ActionsTableModel
extends AbstractTableModel {
    public static final int NAME_INDEX = 0;
    public static final int DEVICE_INDEX = 1;
    public static final int ACTION_INDEX = 2;
    public static final int DATA_INDEX = 3;
    private final ArrayList<ColumnInfo> _columns = new ArrayList<ColumnInfo>(Arrays.asList(new ColumnInfo("Name", 256), new ColumnInfo("Device", 160), new ColumnInfo("Action", 160), new ColumnInfo("Data", 512)));
    private final ArrayList<Action> _macroActions;

    public ActionsTableModel(ArrayList<Action> macroActions) {
        this._macroActions = macroActions;
    }

    public ArrayList<Action> getMacroActions() {
        return this._macroActions;
    }

    @Override
    public String getColumnName(int column) {
        return this._columns.get((int)column).Name;
    }

    public int getColumnWidth(int column) {
        return this._columns.get((int)column).Width;
    }

    @Override
    public int getColumnCount() {
        return this._columns.size();
    }

    @Override
    public int getRowCount() {
        return this._macroActions.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Action macroAction = this._macroActions.get(row);
        try {
            switch (col) {
                case 0: {
                    return macroAction.getName();
                }
                case 1: {
                    return macroAction.getDevice();
                }
                case 2: {
                    return macroAction.getAction();
                }
                case 3: {
                    return macroAction.getData();
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).severe(ExceptionUtils.getStackTrace(ex));
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    class ColumnInfo {
        public String Name;
        public int Width;

        public ColumnInfo(String name, int width) {
            this.Name = name;
            this.Width = width;
        }
    }
}

