/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.beacon.JniorCollection;
import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import com.integ.supporter.SupporterMain;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.Iterator;
import java.util.logging.Logger;
import org.json.JSONObject;

public class JniorsConfig {
    private static final File JNIORS_CONFIG_JSON_FILE = new File(SupporterMain.CONFIG_DIRECTORY + "JniorsConfig.json");
    private static JSONObject _configJson = new JSONObject();
    private static JSONObject _jniorsConfigJson = new JSONObject();
    private static long _lastModifiedTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        File file = JNIORS_CONFIG_JSON_FILE;
        synchronized (file) {
        }
    }

    private static void shouldReloadConfig() {
        if (JNIORS_CONFIG_JSON_FILE.exists() && _lastModifiedTime != JNIORS_CONFIG_JSON_FILE.lastModified()) {
            _lastModifiedTime = JNIORS_CONFIG_JSON_FILE.lastModified();
            JniorsConfig.loadConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConfig() {
        File file = JNIORS_CONFIG_JSON_FILE;
        synchronized (file) {
            long configLoadStart = System.currentTimeMillis();
            if (JNIORS_CONFIG_JSON_FILE.exists()) {
                try {
                    String _jniorsConfigJsonFileContent = FileUtils.readAllText(JNIORS_CONFIG_JSON_FILE.getPath());
                    _configJson = new JSONObject(_jniorsConfigJsonFileContent);
                    if (!_configJson.has("Jniors")) {
                        _configJson.put("Jniors", new JSONObject());
                    }
                    _jniorsConfigJson = _configJson.getJSONObject("Jniors");
                    Iterator<String> keys = _jniorsConfigJson.keys();
                    while (keys.hasNext()) {
                        String key = keys.next();
                        int serialNumber = Integer.parseInt(key);
                        JSONObject jniorJson = _jniorsConfigJson.getJSONObject(key);
                        Logger.getLogger(JniorsConfig.class.getName()).info(jniorJson.toString());
                        JniorInfo jniorInfo = JniorCollection.getJniorInfoBySerialNumber(serialNumber);
                        if (jniorJson.has("Username")) {
                            jniorInfo.Password = jniorJson.getString("Username");
                        }
                        if (!jniorJson.has("Password")) continue;
                        try {
                            String encodedPassword = jniorJson.getString("Password");
                            byte[] passwordBytes = Base64.getDecoder().decode(encodedPassword);
                            jniorInfo.Password = new String(passwordBytes);
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(JniorsConfig.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
                }
            }
            long configLoadElapsed = System.currentTimeMillis() - configLoadStart;
            Logger.getLogger(JniorsConfig.class.getName()).info(String.format("took %.2f to load the jniors config file", (double)configLoadElapsed / 1000.0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveConfig() {
        File file = JNIORS_CONFIG_JSON_FILE;
        synchronized (file) {
            try {
                String fileContentString = _configJson.toString(2);
                byte[] fileContentBytes = fileContentString.getBytes();
                FileUtils.writeAllBytes(JNIORS_CONFIG_JSON_FILE.getPath(), fileContentBytes);
                _lastModifiedTime = JNIORS_CONFIG_JSON_FILE.lastModified();
            }
            catch (IOException ex) {
                Logger.getLogger(JniorsConfig.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        }
    }

    private static JSONObject getJniorJsonObjectForSerialNumber(int serialNumber) {
        String key = Integer.toString(serialNumber);
        if (!_jniorsConfigJson.has(key)) {
            return new JSONObject();
        }
        JSONObject jniorJson = _jniorsConfigJson.getJSONObject(key);
        return jniorJson;
    }

    private static JSONObject ensureJniorJsonObjectForSerialNumber(int serialNumber) {
        String key = Integer.toString(serialNumber);
        if (!_jniorsConfigJson.has(key)) {
            _jniorsConfigJson.put(key, new JSONObject());
        }
        JSONObject jniorJson = _jniorsConfigJson.getJSONObject(key);
        return jniorJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateUsernamePassword(JniorInfo jniorInfo) {
        File file = JNIORS_CONFIG_JSON_FILE;
        synchronized (file) {
            JniorsConfig.shouldReloadConfig();
            JSONObject jniorJson = JniorsConfig.ensureJniorJsonObjectForSerialNumber(jniorInfo.getSerialNumber());
            jniorJson.put("Username", jniorInfo.UserName);
            byte[] passwordBytes = jniorInfo.Password.getBytes();
            String encodedString = Base64.getEncoder().encodeToString(passwordBytes);
            jniorJson.put("Password", encodedString);
            JniorsConfig.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getUsePassiveFtp(int serialNumber) {
        File file = JNIORS_CONFIG_JSON_FILE;
        synchronized (file) {
            JniorsConfig.shouldReloadConfig();
            JSONObject jniorJson = JniorsConfig.getJniorJsonObjectForSerialNumber(serialNumber);
            boolean userPassiveFtp = jniorJson.optBoolean("PassiveFtp", true);
            return userPassiveFtp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUsePassiveFtp(int serialNumber, boolean setUsePassiveFtp) {
        File file = JNIORS_CONFIG_JSON_FILE;
        synchronized (file) {
            JniorsConfig.shouldReloadConfig();
            JSONObject jniorJson = JniorsConfig.ensureJniorJsonObjectForSerialNumber(serialNumber);
            jniorJson.put("PassiveFtp", setUsePassiveFtp);
            JniorsConfig.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastSnapshotTime(int serialNumber) {
        File file = JNIORS_CONFIG_JSON_FILE;
        synchronized (file) {
            JniorsConfig.shouldReloadConfig();
            JSONObject jniorJson = JniorsConfig.getJniorJsonObjectForSerialNumber(serialNumber);
            long lastSnapshotTime = 0L;
            if (jniorJson.has("LastSnapshotTime")) {
                lastSnapshotTime = jniorJson.getLong("LastSnapshotTime");
            }
            return lastSnapshotTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSnapshotTime(int serialNumber, long snapshotEndTime) {
        File file = JNIORS_CONFIG_JSON_FILE;
        synchronized (file) {
            JniorsConfig.shouldReloadConfig();
            JSONObject jniorJson = JniorsConfig.ensureJniorJsonObjectForSerialNumber(serialNumber);
            jniorJson.put("LastSnapshotTime", snapshotEndTime);
            JniorsConfig.saveConfig();
        }
    }
}

