/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.net.LoginFailedException;
import com.integ.janoslib.net.TelnetClient;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.JniorControlConnection;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;

public class JniorSeries3ControlConnection
extends JniorControlConnection {
    private TelnetClient _telnetClient = null;
    private FTPClient _ftpClient = null;

    public JniorSeries3ControlConnection(JniorInfo targetJniorInfo, Logger logger) {
        super(targetJniorInfo, logger);
    }

    @Override
    protected boolean init() {
        return this.initTelnetClient() & this.initFtpClient();
    }

    private boolean initTelnetClient() {
        this._telnetClient = new TelnetClient(this._targetJniorInfo.IpAddress);
        this._telnetClient.setCredentials(this._targetJniorInfo.UserName, this._targetJniorInfo.Password);
        return true;
    }

    private boolean initFtpClient() {
        try {
            this._ftpClient = new FTPClient();
            this._logger.info("  connecting to ftp client...");
            this._ftpClient.connect(this._targetJniorInfo.IpAddress, 21);
            int reply = this._ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                this._ftpClient.disconnect();
                throw new IOException("Exception in connecting to FTP Server");
            }
            this._logger.info("  logging into ftp client...");
            if (this._ftpClient.login(this._targetJniorInfo.UserName, this._targetJniorInfo.Password)) {
                this._logger.info("  ftp client ready.");
                return true;
            }
        }
        catch (UnknownHostException ex) {
            this._logger.severe(ExceptionUtils.getStackTrace(ex));
        }
        catch (IOException ex) {
            this._logger.severe(ExceptionUtils.getStackTrace(ex));
        }
        return false;
    }

    @Override
    public boolean isCommandConnectionConnected() {
        return this._telnetClient.isConnected();
    }

    @Override
    public boolean connect() {
        try {
            this._logger.info("  reconnecting to telnet client...");
            if (this._telnetClient.connect(this._telnetClient.getHostAddress())) {
                this._logger.info("  logging into telnet client...");
                if (this._telnetClient.login()) {
                    this._logger.info("  telnet client ready.");
                    long timeout = System.currentTimeMillis() + 60000L;
                    this._logger.info("  check the boot.log for boot completion");
                    while (System.currentTimeMillis() < timeout) {
                        String[] lines;
                        String bootLog = this._telnetClient.exec("cat jniorboot.log");
                        String lastLine = "";
                        for (String line : lines = bootLog.split("\r\n")) {
                            if ("".equals(line) || !line.contains(", ")) continue;
                            lastLine = line;
                        }
                        this._logger.info(String.format("  %s", lastLine));
                        if (bootLog.contains("Boot Completed")) break;
                        Thread.sleep(15000L);
                    }
                    this._logger.info("  connecting to ftp client...");
                    this._ftpClient.connect(this._targetJniorInfo.IpAddress, 21);
                    int reply = this._ftpClient.getReplyCode();
                    if (!FTPReply.isPositiveCompletion(reply)) {
                        this._ftpClient.disconnect();
                        throw new IOException("Exception in connecting to FTP Server");
                    }
                    this._logger.info("  logging into ftp client...");
                    if (this._ftpClient.login(this._targetJniorInfo.UserName, this._targetJniorInfo.Password)) {
                        this._logger.info("  ftp client ready.");
                        return true;
                    }
                }
            }
            this._logger.info("  reboot has completed");
        }
        catch (Exception ex) {
            this._logger.severe(String.format("  %s", ex.getMessage()));
        }
        return false;
    }

    @Override
    public void disconnect() throws IOException {
        if (null != this._telnetClient) {
            this._telnetClient.disconnect();
            if (this._telnetClient.isConnected()) {
                this._logger.severe("  telnet client did not disconnect");
            } else {
                this._logger.info("  telnet client disconnected");
            }
        }
        if (null != this._ftpClient) {
            this._ftpClient.disconnect();
            if (this._ftpClient.isConnected()) {
                this._logger.severe("  ftp client did not disconnect");
            } else {
                this._logger.info("  ftp client disconnected");
            }
        }
    }

    @Override
    public boolean storeFile(String _remotePath, InputStream inputStream) throws IOException {
        this._ftpClient.setFileType(2);
        return this._ftpClient.storeFile(_remotePath, inputStream);
    }

    @Override
    public void send(String string) throws Exception {
        this._telnetClient.send(string);
    }

    @Override
    public String exec(String command) throws Exception {
        return this.exec(command, 120000);
    }

    @Override
    public String exec(String command, int timeout) throws Exception {
        return this._telnetClient.exec(command);
    }

    @Override
    public boolean retrieveFile(String remotePath, FileOutputStream fileOutputStream) throws IOException {
        return this._ftpClient.retrieveFile(remotePath, fileOutputStream);
    }

    @Override
    public boolean login(String userName, String password) throws LoginFailedException {
        return true;
    }

    @Override
    public FTPFile[] listFiles(String directory) throws IOException {
        return this._ftpClient.listFiles(directory);
    }
}

