/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.FileUtils;
import com.integ.supporter.SupporterMain;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.logging.Logger;
import org.json.JSONObject;

public class JniorAnnouncementStore {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM-dd-yy HH:mm:ss zzz");
    private static final File JNIORS_ANNOUNCEMENT_JSON_FILE = new File(SupporterMain.CONFIG_DIRECTORY + "JniorAnnouncement.json");
    private static JSONObject StoreJson = new JSONObject();
    private static long LastModifiedTime = 0L;
    private static int LoadCount = 0;
    private static int SaveCount = 0;
    private static boolean Dirty = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        File file = JNIORS_ANNOUNCEMENT_JSON_FILE;
        synchronized (file) {
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(5000L);
                            if (!Dirty) continue;
                            JniorAnnouncementStore.saveConfigToFile();
                        }
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(JniorAnnouncementStore.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    private static void shouldReloadConfig() {
        if (JNIORS_ANNOUNCEMENT_JSON_FILE.exists() && LastModifiedTime != JNIORS_ANNOUNCEMENT_JSON_FILE.lastModified()) {
            LastModifiedTime = JNIORS_ANNOUNCEMENT_JSON_FILE.lastModified();
            JniorAnnouncementStore.loadConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadConfig() {
        File file = JNIORS_ANNOUNCEMENT_JSON_FILE;
        synchronized (file) {
            long configLoadStart = System.currentTimeMillis();
            if (JNIORS_ANNOUNCEMENT_JSON_FILE.exists()) {
                try {
                    String _jniorsConfigJsonFileContent = FileUtils.readAllText(JNIORS_ANNOUNCEMENT_JSON_FILE.getPath());
                    if (null != _jniorsConfigJsonFileContent && !"".equalsIgnoreCase(_jniorsConfigJsonFileContent)) {
                        StoreJson = new JSONObject(_jniorsConfigJsonFileContent);
                        System.out.println(String.format("%s load count: %d", JNIORS_ANNOUNCEMENT_JSON_FILE, ++LoadCount));
                    }
                    Dirty = false;
                }
                catch (IOException ex) {
                    Logger.getLogger(JniorAnnouncementStore.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
                }
            }
            long configLoadElapsed = System.currentTimeMillis() - configLoadStart;
            Logger.getLogger(JniorAnnouncementStore.class.getName()).info(String.format("took %.2f to load the jniors announcement file", (double)configLoadElapsed / 1000.0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveConfig() {
        File file = JNIORS_ANNOUNCEMENT_JSON_FILE;
        synchronized (file) {
            Dirty = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveConfigToFile() {
        File file = JNIORS_ANNOUNCEMENT_JSON_FILE;
        synchronized (file) {
            long startTime = System.currentTimeMillis();
            try {
                String fileContentString = StoreJson.toString(2);
                byte[] fileContentBytes = fileContentString.getBytes();
                FileUtils.writeAllBytes(JNIORS_ANNOUNCEMENT_JSON_FILE.getPath(), fileContentBytes);
                LastModifiedTime = JNIORS_ANNOUNCEMENT_JSON_FILE.lastModified();
                System.out.println(String.format("%s save count: %d", JNIORS_ANNOUNCEMENT_JSON_FILE, ++SaveCount));
                Dirty = false;
            }
            catch (IOException ex) {
                Logger.getLogger(JniorAnnouncementStore.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
            long elapsedMillis = System.currentTimeMillis() - startTime;
            System.out.println("elapsedMillis = " + elapsedMillis);
        }
    }

    private static JSONObject ensureJniorJsonObjectForSerialNumber(int serialNumber) {
        String key = Integer.toString(serialNumber);
        if (!StoreJson.has(key)) {
            StoreJson.put(key, new JSONObject());
        }
        JSONObject jniorJson = StoreJson.getJSONObject(key);
        return jniorJson;
    }

    public static JSONObject getStoreJSONObject() {
        JSONObject copyJson = new JSONObject();
        for (String key : StoreJson.keySet()) {
            copyJson.put(key, StoreJson.get(key));
        }
        return copyJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAnnouncementJsonObject(int serialNumber, JSONObject jsonObject) {
        File file = JNIORS_ANNOUNCEMENT_JSON_FILE;
        synchronized (file) {
            JniorAnnouncementStore.shouldReloadConfig();
            JSONObject jniorJson = JniorAnnouncementStore.ensureJniorJsonObjectForSerialNumber(serialNumber);
            jniorJson.put("Data", jsonObject);
            JniorAnnouncementStore.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementBeaconSeenCount(int serialNumber) {
        File file = JNIORS_ANNOUNCEMENT_JSON_FILE;
        synchronized (file) {
            JniorAnnouncementStore.shouldReloadConfig();
            JSONObject jniorJson = JniorAnnouncementStore.ensureJniorJsonObjectForSerialNumber(serialNumber);
            if (!jniorJson.has("BeaconSeenCount")) {
                jniorJson.put("BeaconSeenCount", 0);
            }
            int beaconSeenCount = jniorJson.getInt("BeaconSeenCount");
            jniorJson.put("BeaconSeenCount", beaconSeenCount + 1);
            JniorAnnouncementStore.saveConfig();
        }
    }
}

