/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.utils;

import com.integ.janoslib.utils.ExceptionUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Logger;

public class FileUtils {
    public static void writeAllBytes(String filename, byte[] bytes) throws IOException {
        FileUtils.writeBytes(filename, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBytes(String filename, byte[] bytes, int offset, int length) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            fos.write(bytes, offset, length);
            fos.flush();
        }
        finally {
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                String stacktrace = ExceptionUtils.getStackTrace(ex);
                Logger.getGlobal().severe(stacktrace);
            }
        }
    }

    public static void appendAllBytes(String filename, byte[] bytes) throws IOException {
        FileUtils.appendBytes(filename, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendBytes(String filename, byte[] bytes, int offset, int length) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename, true);
            fos.write(bytes, offset, length);
            fos.flush();
        }
        finally {
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                String stacktrace = ExceptionUtils.getStackTrace(ex);
                Logger.getGlobal().severe(stacktrace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAllBytes(String filename) throws IOException {
        File file = new File(filename);
        int fileLength = (int)file.length();
        if (0 > fileLength) {
            throw new RuntimeException(filename + " is too large");
        }
        byte[] bytes = new byte[fileLength];
        FileInputStream fis = new FileInputStream(file.getPath());
        try (DataInputStream dis = new DataInputStream(fis);){
            dis.readFully(bytes);
        }
        return bytes;
    }

    public static String readAllText(String filename) throws IOException {
        byte[] fileBytes = FileUtils.readAllBytes(filename);
        String fileContent = new String(fileBytes);
        return fileContent;
    }

    public static void copyfile(File srcFile, int srPos, File dstFile, int dtPos) {
        try {
            int len;
            long start = System.currentTimeMillis();
            RandomAccessFile in = new RandomAccessFile(srcFile, "r");
            in.seek(srPos);
            RandomAccessFile out = new RandomAccessFile(dstFile, "rw");
            out.seek(dtPos);
            byte[] buf = new byte[16384];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.close();
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("took " + elapsed + " to copy " + srcFile.getAbsolutePath() + " to " + dstFile.getAbsolutePath());
        }
        catch (Exception ex) {
            String stacktrace = ExceptionUtils.getStackTrace(ex);
            Logger.getGlobal().severe("Error copying file " + srcFile.getPath() + " to " + dstFile.getPath() + ": " + stacktrace);
        }
    }

    public static boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            File[] children = dir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDirectory(children[i]);
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

