/*
 * Decompiled with CFR 0.152.
 */
package com.integ.beacon.commands;

import com.integ.beacon.Beacon;
import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.HexUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BeaconCommand {
    protected final Object _lock = new Object();
    protected int SerialNumber = -1;
    protected String Command;
    private byte[] _bytes = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() {
        Object object = this._lock;
        synchronized (object) {
            if (null == this._bytes) {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(baos);
                    dos.writeShort(0);
                    dos.writeInt(this.SerialNumber);
                    dos.writeShort((short)this.Command.length());
                    dos.write(this.Command.getBytes(), 0, this.Command.length());
                    this.appendCommandBytes(dos);
                    byte[] bytes = baos.toByteArray();
                    int length = bytes.length - 2;
                    bytes[0] = (byte)(length >> 8 & 0xFF);
                    bytes[1] = (byte)(length & 0xFF);
                    this._bytes = bytes;
                }
                catch (Exception ex) {
                    String stacktrace = ExceptionUtils.getStackTrace(ex);
                    Beacon.LOGGER.severe(stacktrace);
                    this._bytes = null;
                }
            }
            return this._bytes;
        }
    }

    protected void appendCommandBytes(DataOutputStream dos) throws IOException {
    }

    protected void writeString(DataOutputStream dos, String string) throws IOException {
        dos.writeShort((short)string.length());
        dos.write(string.getBytes(), 0, string.length());
    }

    protected void appendSecurity(DataOutputStream dos, JniorInfo jniorInfo) throws IOException {
        if (null != jniorInfo.Nonce) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] hashBytes = (jniorInfo.UserName + ":" + jniorInfo.Nonce + ":" + jniorInfo.Password).getBytes();
                md.update(hashBytes);
                byte[] digest = md.digest();
                String digestString = HexUtils.bytesToHex(digest);
                digestString = jniorInfo.UserName + ":" + digestString;
                this.writeString(dos, digestString);
                jniorInfo.Nonce = null;
            }
            catch (NoSuchAlgorithmException ex) {
                String stacktrace = ExceptionUtils.getStackTrace(ex);
                Beacon.LOGGER.severe(stacktrace);
            }
        } else {
            throw new IOException("Command is missing the security nonce");
        }
    }
}

