/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

public class JanosVersion
implements Comparable<JanosVersion> {
    private static final int ALPHA = 0;
    private static final int BETA = 1;
    private static final int RELEASE_CANDIDATE = 2;
    private static final int RELEASED = 3;
    private final int _major;
    private final int _minor;
    private final int _update;
    private final int _status;
    private final int _build;
    private final int _compile;

    public JanosVersion(int major, int minor, int update, int status, int build, int compile) {
        this._major = major;
        this._minor = minor;
        this._update = update;
        this._status = status;
        this._build = build;
        this._compile = compile;
    }

    public static JanosVersion getFromBuildTag(String buildTag) {
        if (buildTag.startsWith("0x")) {
            buildTag = buildTag.substring(2);
        }
        Long buildVersionNum = Long.valueOf(buildTag, 16);
        int major = (int)(buildVersionNum >> 44 & 0xFL);
        int minor = (int)(buildVersionNum >> 40 & 0xFL);
        int update = (int)(buildVersionNum >> 36 & 0xFL);
        int status = (int)(buildVersionNum >> 32 & 0xFL);
        int build = (int)(buildVersionNum >> 16 & 0xFFFFL);
        int compile = (int)(buildVersionNum & 0xFFFFL);
        return new JanosVersion(major, minor, update, status, build, compile);
    }

    public static JanosVersion getFromString(String versionString) throws Exception {
        try {
            if ('v' == versionString.charAt(0)) {
                versionString = versionString.substring(1);
            }
            int[] versionParts = new int[6];
            versionParts[PARSE_STATE.GET_STATUS.ordinal()] = 3;
            PARSE_STATE state = PARSE_STATE.GET_MAJOR;
            for (int i = 0; i < versionString.length(); ++i) {
                char c = versionString.charAt(i);
                if ('.' == c) {
                    state = PARSE_STATE.values()[state.ordinal() + 1];
                    continue;
                }
                if ('-' == c) {
                    state = PARSE_STATE.GET_STATUS;
                    continue;
                }
                if (PARSE_STATE.GET_STATUS == state) {
                    versionParts[state.ordinal()] = 'a' == c ? 0 : ('b' == c ? 1 : ('r' == c && 'c' == versionString.charAt(++i) ? 2 : 3));
                    state = PARSE_STATE.GET_BUILD;
                    continue;
                }
                versionParts[state.ordinal()] = versionParts[state.ordinal()] * 10 + (c - 48);
            }
            JanosVersion version = new JanosVersion(versionParts[0], versionParts[1], versionParts[2], versionParts[3], versionParts[4], versionParts[5]);
            return version;
        }
        catch (Exception ex) {
            throw new Exception("Error parsing " + versionString, ex);
        }
    }

    public String toString() {
        Object buildTagVersion = String.format("v%d.%d", this._major, this._minor);
        if (0 < this._update) {
            buildTagVersion = (String)buildTagVersion + String.format(".%d", this._update);
        }
        String statusString = "";
        if (0 == this._status) {
            statusString = "-a";
        } else if (1 == this._status) {
            statusString = "-b";
        } else if (2 == this._status) {
            statusString = "-rc";
        } else if (3 == this._status) {
            statusString = " build ";
        }
        if (3 != this._status || 0 != this._build) {
            buildTagVersion = (String)buildTagVersion + String.format("%s%d", statusString, this._build);
            if (0 != this._compile) {
                buildTagVersion = (String)buildTagVersion + String.format(".%d", this._compile);
            }
        }
        return buildTagVersion;
    }

    @Override
    public int compareTo(JanosVersion v) {
        if (this._major > v._major) {
            return 1;
        }
        if (this._major < v._major) {
            return -1;
        }
        if (this._minor > v._minor) {
            return 1;
        }
        if (this._minor < v._minor) {
            return -1;
        }
        if (this._update > v._update) {
            return 1;
        }
        if (this._update < v._update) {
            return -1;
        }
        if (this._status > v._status) {
            return 1;
        }
        if (this._status < v._status) {
            return -1;
        }
        if (this._build > v._build) {
            return 1;
        }
        if (this._build < v._build) {
            return -1;
        }
        if (this._compile > v._compile) {
            return 1;
        }
        if (this._compile < v._compile) {
            return -1;
        }
        return 0;
    }

    private static enum PARSE_STATE {
        GET_MAJOR,
        GET_MINOR,
        GET_UPDATE,
        GET_STATUS,
        GET_BUILD,
        GET_COMPILE;

    }
}

