/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.DetailsFileChooser;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.dialogs.JniorSelectionDialog;
import com.integ.supporter.updater.JniorUpdateTab;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.UpdateTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class UpdateProjectMainMenu {
    private final JMenuBar _menuBar;
    private JMenuItem _menuCloseUpdateProject;
    private JMenuItem _menuPublishUpdateProject;
    private JMenuItem _menuAbortUpdateProject;

    public UpdateProjectMainMenu(JMenuBar menuBar) {
        this._menuBar = menuBar;
        this.createMenu();
    }

    private void createMenu() {
        JMenu menuUpdate = new JMenu("Update Project");
        this._menuBar.add(menuUpdate);
        menuUpdate.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                JTabbedPane tabbedPane = SupporterMain.getTabPane();
                Component component = tabbedPane.getSelectedComponent();
                if (component instanceof UpdateTab) {
                    UpdateTab updateTab = (UpdateTab)component;
                    boolean updateProjectRunning = updateTab.isUpdateInProgress();
                    UpdateProjectMainMenu.this._menuCloseUpdateProject.setEnabled(!updateProjectRunning);
                    UpdateProjectMainMenu.this._menuPublishUpdateProject.setEnabled(!updateProjectRunning);
                    UpdateProjectMainMenu.this._menuAbortUpdateProject.setEnabled(updateProjectRunning);
                } else {
                    UpdateProjectMainMenu.this._menuCloseUpdateProject.setEnabled(false);
                    UpdateProjectMainMenu.this._menuPublishUpdateProject.setEnabled(false);
                    UpdateProjectMainMenu.this._menuAbortUpdateProject.setEnabled(false);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.addCreateNewUpdateProject(menuUpdate);
        this.addOpenUpdateProject(menuUpdate);
        this.addOpenSnapshotUpdateProject(menuUpdate);
        this.addCloseUpdateProject(menuUpdate);
        this.addPublishUpdateProject(menuUpdate);
        this.addAbortUpdateProject(menuUpdate);
    }

    private void addCreateNewUpdateProject(JMenu menu) {
        JMenuItem menuNewUpdateProject = new JMenuItem("Create New Update Project");
        menuNewUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    UpdateProjectFile updateProjectFile = new UpdateProjectFile();
                    JTabbedPane tabbedPane = SupporterMain.getTabPane();
                    UpdateTab updateTab = new UpdateTab(updateProjectFile);
                    String title = String.format("Update - %s", updateProjectFile.getTitle());
                    int tabCount = tabbedPane.getTabCount();
                    tabbedPane.insertTab(title, null, updateTab, title, tabCount);
                    tabbedPane.setSelectedIndex(tabCount);
                    updateTab.showEditProjectDialog();
                }
                catch (Exception ex) {
                    String stacktrace = ExceptionUtils.getStackTrace(ex);
                    Logger.getGlobal().severe(stacktrace);
                }
            }
        });
        menu.add(menuNewUpdateProject);
    }

    private void addOpenUpdateProject(JMenu menu) {
        JMenuItem menuOpenUpdateProject = new JMenuItem("Open Update Project");
        menuOpenUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailsFileChooser fileChooser = new DetailsFileChooser();
                fileChooser.setCurrentDirectory(new File(UpdateTab.UPDATE_PROJECTS_FOLDER));
                fileChooser.setFileSelectionMode(0);
                fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("JNIOR Update Project", "zip"));
                fileChooser.setAcceptAllFileFilterUsed(true);
                int result = fileChooser.showOpenDialog(UpdateProjectMainMenu.this._menuBar.getRootPane());
                if (result == 0) {
                    try {
                        File selectedFile = fileChooser.getSelectedFile();
                        UpdateProjectFile updateProjectFile = new UpdateProjectFile(selectedFile);
                        updateProjectFile.load();
                        JTabbedPane tabbedPane = SupporterMain.getTabPane();
                        UpdateTab updateTab = new UpdateTab(updateProjectFile);
                        String title = String.format("Update - %s", updateProjectFile.getTitle());
                        int tabCount = tabbedPane.getTabCount();
                        tabbedPane.insertTab(title, null, updateTab, title, tabCount);
                        tabbedPane.setSelectedIndex(tabCount);
                        if (-1 != tabbedPane.indexOfComponent(SupporterMain.BLANK_UPDATE_TAB)) {
                            tabbedPane.remove(SupporterMain.BLANK_UPDATE_TAB);
                        }
                    }
                    catch (IOException ex) {
                        String stacktrace = ExceptionUtils.getStackTrace(ex);
                        Logger.getGlobal().severe(stacktrace);
                    }
                }
            }
        });
        menu.add(menuOpenUpdateProject);
    }

    private void addOpenSnapshotUpdateProject(JMenu menu) {
        JMenuItem menuSnapshotOpenUpdateProject = new JMenuItem("Open Snapshot Update Project");
        menuSnapshotOpenUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailsFileChooser fileChooser = new DetailsFileChooser();
                fileChooser.setCurrentDirectory(new File(UpdateTab.UPDATE_PROJECTS_FOLDER));
                fileChooser.setFileSelectionMode(0);
                fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("JNIOR Update Project", "zip"));
                fileChooser.setAcceptAllFileFilterUsed(true);
                int result = fileChooser.showOpenDialog(UpdateProjectMainMenu.this._menuBar.getRootPane());
                if (result == 0) {
                    try {
                        File selectedFile = fileChooser.getSelectedFile();
                        UpdateProjectFile updateProjectFile = new UpdateProjectFile(selectedFile);
                        updateProjectFile.load();
                        JTabbedPane tabbedPane = SupporterMain.getTabPane();
                        UpdateTab updateTab = new UpdateTab(updateProjectFile);
                        String title = String.format("Update - %s", updateProjectFile.getTitle());
                        int tabCount = tabbedPane.getTabCount();
                        tabbedPane.insertTab(title, null, updateTab, title, tabCount);
                        tabbedPane.setSelectedIndex(tabCount);
                    }
                    catch (IOException ex) {
                        String stacktrace = ExceptionUtils.getStackTrace(ex);
                        Logger.getGlobal().severe(stacktrace);
                    }
                }
            }
        });
        menu.add(menuSnapshotOpenUpdateProject);
    }

    private void addCloseUpdateProject(JMenu menuUpdate) {
        this._menuCloseUpdateProject = new JMenuItem("Close Update Project");
        this._menuCloseUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTabbedPane tabbedPane = SupporterMain.getTabPane();
                Component component = tabbedPane.getSelectedComponent();
                if (component instanceof UpdateTab) {
                    UpdateTab updateTab = (UpdateTab)component;
                    updateTab.close();
                    tabbedPane.remove(updateTab);
                } else {
                    Logger.getGlobal().severe("Selected tab is not an update tab");
                }
            }
        });
        this._menuCloseUpdateProject.setEnabled(false);
        menuUpdate.add(this._menuCloseUpdateProject);
    }

    private void addPublishUpdateProject(JMenu menuUpdate) {
        this._menuPublishUpdateProject = new JMenuItem("Publish Update Project");
        this._menuPublishUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTabbedPane tabbedPane = SupporterMain.getTabPane();
                Component component = tabbedPane.getSelectedComponent();
                if (component instanceof UpdateTab) {
                    UpdateTab updateTab = (UpdateTab)component;
                    JniorSelectionDialog dlg = new JniorSelectionDialog(null, true);
                    dlg.setVisible(true);
                    JniorInfo[] selectedJniors = dlg.getSelectedJniors();
                    if (null != selectedJniors && 0 < selectedJniors.length) {
                        for (JniorInfo selectedRemoteJniorInfo : selectedJniors) {
                            try {
                                updateTab.publish(selectedRemoteJniorInfo);
                            }
                            catch (IOException ex) {
                                Logger.getLogger(UpdateProjectMainMenu.class.getName()).severe(ex.getMessage());
                            }
                        }
                    } else {
                        Logger.getGlobal().severe("Selected tab is not an update tab");
                    }
                }
            }
        });
        menuUpdate.add(this._menuPublishUpdateProject);
    }

    private void addAbortUpdateProject(JMenu menuUpdate) {
        this._menuAbortUpdateProject = new JMenuItem("Abort Update Project");
        this._menuAbortUpdateProject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTabbedPane tabbedPane = SupporterMain.getTabPane();
                Component component = tabbedPane.getSelectedComponent();
                if (component instanceof UpdateTab) {
                    UpdateTab updateTab = (UpdateTab)component;
                    JniorUpdateTab jniorUpdateTab = updateTab.getSelectedJniorUpdateTab();
                    if (null != jniorUpdateTab) {
                        jniorUpdateTab.abort();
                    }
                } else {
                    Logger.getGlobal().severe("Selected tab is not an update tab");
                }
            }
        });
        this._menuAbortUpdateProject.setEnabled(false);
        menuUpdate.add(this._menuAbortUpdateProject);
    }
}

