/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.jtable;

import com.integ.supporter.ApplicationConfig;
import com.integ.supporter.ui.jtable.ResizeColumnListener;
import com.integ.supporter.ui.jtable.TableColumnsListener;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;

public class ColumnWidthPersistance
implements TableColumnsListener {
    private final JTable _table;
    private final TableColumnModel _columnModel;

    public ColumnWidthPersistance(String name, JTable table) {
        this._table = table;
        this._columnModel = table.getColumnModel();
        this.loadSavedWidths();
        this.setColumnResizeListener();
    }

    private void loadSavedWidths() {
        int[] savedWidths = ApplicationConfig.getBeaconColumnWidths();
        for (int i = 0; i < savedWidths.length; ++i) {
            this._columnModel.getColumn(i).setPreferredWidth(savedWidths[i]);
        }
    }

    private void setColumnResizeListener() {
        ResizeColumnListener resizeColumnListener = new ResizeColumnListener(this._table);
        resizeColumnListener.addColumnResizeListener(this);
    }

    @Override
    public void columnWidthChanged(EventObject e) {
        ResizeColumnListener resizeColumnListener = (ResizeColumnListener)e.getSource();
        int[] columnWidths = resizeColumnListener.getWidths();
        ApplicationConfig.setBeaconColumnWidths(columnWidths);
    }
}

