/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.supporter.snapshot.SnapshotFile;
import com.integ.supporter.snapshot.SnapshotTab;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SnapshotLogFile {
    private static final Pattern SUPPORT_TOOL_VERSION_V1_PATTERN = Pattern.compile("Support Tool Version: (?<version>.*)");
    private static final Pattern SUPPORT_TOOL_VERSION_V2_PATTERN = Pattern.compile("Jnior Support Tool (?<version>.*)");
    private static final Pattern JNIOR_SUPPORTER_VERSION_PATTERN = Pattern.compile("Jnior Supporter v(?<version>.*)", 2);
    private static final Pattern SERIAL_NUMBER_PATTERN = Pattern.compile("S/N (?<serialnumber>.*)");
    private static final Pattern JANOS_VERSION_PATTERN = Pattern.compile("JANOS v(?<version>.*)");
    private static final Pattern SERIES3_VERSION_PATTERN = Pattern.compile("JNIOR OS (?<version>.*)");
    private static final Pattern RECORD_UPTIME_PATTERN = Pattern.compile("Record up time: ((?<weeks>\\d+) Weeks? )?((?<days>\\d+) Days? )?(\\d+ Hours? )?\\d+:\\d+.\\d+");
    private static final Pattern TOTAL_UPTIME_PATTERN = Pattern.compile("Total run time: ((?<years>\\d+) Years? )?((?<weeks>\\d+) Weeks? )?((?<days>\\d+) Days? )?(\\d+ Hours? )?\\d+:\\d+.\\d+");
    private static final Pattern DAYS_PATTERN = Pattern.compile(": Run/(?<days>\\d*)");
    private static final Pattern RUN_PATTERN = Pattern.compile("Days :/(?<application>.*)");
    private static final Pattern PROCESSES_PATTERN = Pattern.compile("\\d+: (?<application>.*) \\(Owner jnior\\)");
    private static final Pattern LISTENING_PORT_PATTERN = Pattern.compile(": *(?<port>\\d*).*LISTEN");
    private final SnapshotFile _snapshotFile;
    private final ArrayList<String> _applications = new ArrayList();
    private final ArrayList<String> _listeneingPorts = new ArrayList();
    private String _snapshotLogContent;
    private String _supportToolVersion;
    private Integer _serialNumber;
    private String _osVersion;
    private int _recordUptime;
    private int _totalUptime;

    public SnapshotLogFile(SnapshotFile snapshotFile) {
        this._snapshotFile = snapshotFile;
    }

    public void analyze() {
        try {
            byte[] contents = this._snapshotFile.getFileEntry("_snapshot.log");
            this._snapshotLogContent = new String(contents);
            Matcher matcher = SUPPORT_TOOL_VERSION_V1_PATTERN.matcher(this._snapshotLogContent);
            if (matcher.find()) {
                this._supportToolVersion = matcher.group("version");
            } else {
                matcher = SUPPORT_TOOL_VERSION_V2_PATTERN.matcher(this._snapshotLogContent);
                if (matcher.find()) {
                    this._supportToolVersion = matcher.group("version");
                } else {
                    matcher = JNIOR_SUPPORTER_VERSION_PATTERN.matcher(this._snapshotLogContent);
                    if (matcher.find()) {
                        this._supportToolVersion = matcher.group("version");
                    } else {
                        this._supportToolVersion = "unknown";
                        System.out.println(this._snapshotFile.getFile().getPath() + " support tool version not found");
                    }
                }
            }
            matcher = SERIAL_NUMBER_PATTERN.matcher(this._snapshotLogContent);
            if (matcher.find()) {
                this._serialNumber = Integer.valueOf(matcher.group("serialnumber"));
            }
            if ((matcher = JANOS_VERSION_PATTERN.matcher(this._snapshotLogContent)).find()) {
                this._osVersion = matcher.group("version");
            } else {
                matcher = SERIES3_VERSION_PATTERN.matcher(this._snapshotLogContent);
                if (matcher.find()) {
                    this._osVersion = matcher.group("version");
                } else {
                    this._osVersion = "unknown";
                    System.out.println(this._snapshotFile.getFile().getPath() + " os version not found");
                }
            }
            if (3 == this.getSeries()) {
                matcher = DAYS_PATTERN.matcher(this._snapshotLogContent);
                if (matcher.find()) {
                    int days;
                    this._totalUptime = days = Integer.valueOf(matcher.group("days")).intValue();
                }
            } else if (4 == this.getSeries()) {
                matcher = RECORD_UPTIME_PATTERN.matcher(this._snapshotLogContent);
                if (matcher.find()) {
                    String weeksString = matcher.group("weeks");
                    int weeks = null != weeksString ? Integer.valueOf(weeksString) : 0;
                    String daysString = matcher.group("days");
                    int days = null != daysString ? Integer.valueOf(daysString) : 0;
                    this._recordUptime = weeks * 7 + days;
                }
                if ((matcher = TOTAL_UPTIME_PATTERN.matcher(this._snapshotLogContent)).find()) {
                    String yearsString = matcher.group("years");
                    int years = null != yearsString ? Integer.valueOf(yearsString) : 0;
                    String weeksString = matcher.group("weeks");
                    int weeks = null != weeksString ? Integer.valueOf(weeksString) : 0;
                    String daysString = matcher.group("days");
                    int days = null != daysString ? Integer.valueOf(daysString) : 0;
                    this._totalUptime = years * 365 + weeks * 7 + days;
                }
            }
            if (3 == this.getSeries()) {
                matcher = PROCESSES_PATTERN.matcher(this._snapshotLogContent);
                while (matcher.find()) {
                    String application = matcher.group("application");
                    this._applications.add(application);
                }
            } else if (4 == this.getSeries()) {
                matcher = RUN_PATTERN.matcher(this._snapshotLogContent);
                while (matcher.find()) {
                    String application = matcher.group("application");
                    this._applications.add(application);
                }
            }
            matcher = LISTENING_PORT_PATTERN.matcher(this._snapshotLogContent);
            while (matcher.find()) {
                String port = matcher.group("port");
                this._listeneingPorts.add(port);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(SnapshotTab.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getSnapshotLogContent() {
        return this._snapshotLogContent;
    }

    public String getSupportToolVersion() {
        return this._supportToolVersion;
    }

    public Integer getSerialNumber() {
        return this._serialNumber;
    }

    public int getSeries() {
        if (null != this._serialNumber) {
            int firstDigit = this._serialNumber / 100000000;
            if (5 > firstDigit) {
                return 3;
            }
            if (6 <= firstDigit) {
                return 4;
            }
        }
        throw new RuntimeException("Invalid Serial Number: " + this._serialNumber);
    }

    public String getModel() {
        if (null != this._serialNumber) {
            int firstDigit = this._serialNumber / 100000000;
            switch (firstDigit) {
                case 0: 
                case 1: 
                case 2: {
                    return "310";
                }
                case 3: {
                    return "312";
                }
                case 4: {
                    return "314";
                }
                case 6: {
                    return "410";
                }
                case 7: {
                    return "412";
                }
                case 8: {
                    return "414";
                }
                case 9: {
                    return "412DMX";
                }
            }
        }
        throw new RuntimeException("Invalid Serial Number: " + this._serialNumber);
    }

    public String getOsVersion() {
        return this._osVersion;
    }

    public int getRecordUptime() {
        return this._recordUptime;
    }

    public int getTotalUptime() {
        return this._totalUptime;
    }

    public ArrayList<String> getApplications() {
        return this._applications;
    }

    public ArrayList<String> getListeningPorts() {
        return this._listeneingPorts;
    }
}

