/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot.menus;

import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.snapshot.ZipFileNode;
import com.integ.supporter.snapshot.menus.SnapshotPopupMenu;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;

public class SnapshotTreePopupMenu
extends JPopupMenu {
    public SnapshotTreePopupMenu() {
        this.init();
    }

    private void init() {
        this.addShowInFolderMenuItem();
    }

    private void addShowInFolderMenuItem() {
        JMenuItem openFolderLocationMenuItem = new JMenuItem("Show in Folder");
        openFolderLocationMenuItem.addActionListener(e -> EventQueue.invokeLater(() -> {
            try {
                JTree tree = (JTree)e.getSource();
                Object lastSelectedPathComponent = tree.getLastSelectedPathComponent();
                if (lastSelectedPathComponent instanceof ZipFileNode) {
                    ZipFileNode selectedZipFileNode = (ZipFileNode)lastSelectedPathComponent;
                    File file = selectedZipFileNode.getFile();
                    File parentFolder = file.getParentFile();
                    if (Constants.IS_WINDOWS) {
                        Runtime.getRuntime().exec("explorer.exe /select," + file.getPath());
                    } else {
                        Desktop desktop = Desktop.getDesktop();
                        desktop.open(parentFolder);
                    }
                }
            }
            catch (IOException | IllegalArgumentException ex) {
                Logger.getLogger(SnapshotPopupMenu.class.getName()).severe(ExceptionUtils.getStackTrace(ex));
            }
        }));
        super.add(openFolderLocationMenuItem);
    }
}

