/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.jrget;

import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.Constants;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.jrget.DescendingDateFileChooser;
import java.io.File;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileFilter;

class UpdateProjectFileChooser
extends DescendingDateFileChooser {
    public UpdateProjectFileChooser() {
        super.removeChoosableFileFilter(super.getChoosableFileFilters()[0]);
        super.setCurrentDirectory(new File(Constants.UPDATE_PROJECTS_DIRECTORY));
        super.addChoosableFileFilter(new FileFilter(){
            private final Pattern LdrPattern = Pattern.compile("\\.ldr$", 2);

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String name = file.getName();
                boolean isUpdateProject = name.endsWith(".zip");
                if (isUpdateProject) {
                    try {
                        boolean ldrFound = ZipUtils.findEntry(file.getPath(), this.LdrPattern);
                        isUpdateProject &= ldrFound;
                    }
                    catch (Exception ex) {
                        NotificationCollection.addError("Error looking for ldr file in potential update project" + file.getPath(), ex);
                    }
                }
                return isUpdateProject;
            }

            @Override
            public String getDescription() {
                return "Update Projects";
            }
        });
    }
}

