/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.cinema;

import com.integ.supporter.cinema.MacroAction;
import com.integ.supporter.cinema.MacroActionNode;
import com.integ.supporter.cinema.MacroNode;
import com.integ.supporter.ui.jtreetable.AbstractTreeTableModel;
import com.integ.supporter.ui.jtreetable.TreeTableModel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.tree.TreeNode;

public class MacroTreeTableModel
extends AbstractTreeTableModel {
    protected static String[] ColumnNames = new String[]{"Name", "Timing", "Action Description"};
    protected static Class[] ClassTypes = new Class[]{TreeTableModel.class, String.class, String.class};
    private final ArrayList<MacroNode> _macroNodes = new ArrayList();

    public MacroTreeTableModel(Object root) {
        super(root);
    }

    public void clear() {
        this._macroNodes.clear();
    }

    public void addMacroNode(MacroNode macroNode) {
        this._macroNodes.add(macroNode);
        super.fireTreeStructureChanged(this, null, null, null);
    }

    public TreeNode[] getPathToRoot(TreeNode aNode) {
        return this.getPathToRoot(aNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = aNode == this.root ? new TreeNode[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public void removeMacroNode(MacroNode macroNode) {
        this._macroNodes.remove(macroNode);
        this.fireTreeStructureChanged(this, null, null, null);
    }

    public void moveMacroNode(MacroNode macroNode, int direction) {
        int macroNodeIndex = this._macroNodes.indexOf(macroNode);
        this._macroNodes.remove(macroNode);
        this._macroNodes.add(macroNodeIndex + direction, macroNode);
        this.fireTreeStructureChanged(this, null, null, null);
    }

    public void structureChanged() {
        this.fireTreeStructureChanged(this, null, null, null);
    }

    public ArrayList<MacroNode> getMacroNodes() {
        return this._macroNodes;
    }

    @Override
    public int getColumnCount() {
        return ColumnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return ColumnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return ClassTypes[columnIndex];
    }

    @Override
    public Object getValueAt(Object node, int columnIndex) {
        if (node instanceof MacroNode) {
            MacroNode macroNode = (MacroNode)node;
            if (0 == columnIndex) {
                return macroNode.Name;
            }
            return "";
        }
        if (node instanceof MacroActionNode) {
            MacroActionNode macroActionNode = (MacroActionNode)node;
            if (0 == columnIndex) {
                return macroActionNode.getName();
            }
            if (1 == columnIndex) {
                return macroActionNode.getTiming();
            }
            if (2 == columnIndex) {
                return macroActionNode.getDescription();
            }
            return "";
        }
        throw new RuntimeException("Error in MacroTreeModel::getValueAt(");
    }

    @Override
    public boolean isCellEditable(Object node, int columnIndex) {
        if (node instanceof MacroNode) {
            return 0 == columnIndex;
        }
        if (node instanceof MacroActionNode) {
            return 1 == columnIndex;
        }
        return false;
    }

    @Override
    public void setValueAt(Object value, Object node, int columnIndex) {
        if (node instanceof MacroNode) {
            if (0 == columnIndex) {
                ((MacroNode)node).Name = (String)value;
            }
        } else if (node instanceof MacroActionNode && 1 == columnIndex) {
            Date date = (Date)value;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int minutes = calendar.get(12);
            int seconds = calendar.get(13);
            ((MacroActionNode)node).setTiming(minutes * 60 + seconds);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this._macroNodes.get(index);
        }
        if (parent instanceof MacroNode) {
            MacroNode macroNode = (MacroNode)parent;
            return macroNode.getMacroActionNodes().get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this._macroNodes.size();
        }
        if (parent instanceof MacroNode) {
            return ((MacroNode)parent).getMacroActionNodes().size();
        }
        return 0;
    }

    public int getRowForMacroNode(MacroNode macroNode) {
        int row = this._macroNodes.indexOf(macroNode);
        return row;
    }

    void sort(MacroNode macroNode) {
        macroNode.sort();
        this.fireTreeStructureChanged(this, null, null, null);
    }

    void removeActionFromMacros(MacroAction selectedMacroAction) {
        boolean removed = false;
        for (MacroNode macroNode : this._macroNodes) {
            for (int i = 0; i < macroNode.getMacroActionNodes().size(); ++i) {
                MacroActionNode macroActionNode = macroNode.getMacroActionNodes().get(i);
                if (macroActionNode.getMacroAction() != selectedMacroAction) continue;
                macroNode.removeMacroAction(macroActionNode);
                removed = true;
            }
        }
        if (removed) {
            this.fireTreeStructureChanged(this, null, null, null);
        }
    }

    public void updateTimingForAction(MacroActionNode macroActionNode, int newSeconds) {
        macroActionNode.setTiming(newSeconds);
        for (MacroNode macroNode : this._macroNodes) {
            if (!macroNode.getMacroActionNodes().contains(macroActionNode)) continue;
            macroNode.getMacroActionNodes().sort((o1, o2) -> {
                if (o1.getTimingSeconds() < o2.getTimingSeconds()) {
                    return -1;
                }
                if (o1.getTimingSeconds() > o2.getTimingSeconds()) {
                    return -1;
                }
                return 0;
            });
            super.fireTreeStructureChanged(this, null, null, null);
        }
    }
}

