/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.beacon.dialogs;

import com.integ.supporter.beacon.dialogs.XY;
import com.integ.supporter.ui.ColorConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import javax.swing.JPanel;

public class Graph
extends JPanel {
    private static final int BORDER_GAP = 30;
    private static final Color GRAPH_POINT_COLOR = new Color(150, 50, 50, 180);
    private static final Stroke GRAPH_STROKE = new BasicStroke(1.2f);
    private static final int GRAPH_POINT_WIDTH = 12;
    private double _yMin = 0.0;
    private double _yMax = 100.0;
    private long _xMin = System.currentTimeMillis();
    private long _xMax = this._xMin + 300000L;
    private double _xRange;
    private double _xScale;
    private double _yRange;
    private double _yScale;
    private int _durationInMinutes;
    private final ArrayList<XY> _dataSeries = new ArrayList();
    private Color _graphColor = ColorConstants.NOTIFICATION_COLOR;

    public void setXMin(long xMin) {
        this._xMin = xMin;
    }

    public void setXMax(long xMax) {
        this._xMax = xMax;
    }

    public void setXDurationInMinutes(int durationInMinutes) {
        this._durationInMinutes = durationInMinutes;
    }

    public void setYMin(double yMin) {
        this._yMin = yMin;
    }

    public void setYMax(double yMax) {
        this._yMax = yMax;
    }

    public void setColor(String colorString) {
        this._graphColor = Color.decode(colorString);
    }

    public void addDataPoint(long x, double y) {
        this._dataSeries.add(new XY(x, y));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (0 != this._durationInMinutes) {
            this.setXMin(this._xMax - (long)(this._durationInMinutes * 60000));
        }
        this._xRange = this._xMax - this._xMin;
        this._xScale = ((double)this.getWidth() - 60.0) / this._xRange;
        this._yRange = this._yMax - this._yMin;
        this._yScale = ((double)this.getHeight() - 60.0) / this._yRange;
        this.drawChartArea(g2);
        g.setColor(Color.decode("#444444"));
        g2.drawLine(30, this.getHeight() - 30, 30, 30);
        g2.drawLine(30, this.getHeight() - 30, this.getWidth() - 30, this.getHeight() - 30);
        int fontHeight = g2.getFontMetrics().getHeight();
        String s = String.valueOf((int)this._yMax);
        int sWidth = g2.getFontMetrics().stringWidth(s);
        g2.drawString(s, 26 - sWidth, 30 + fontHeight / 2 - 4);
        s = String.valueOf((int)this._yMin);
        sWidth = g2.getFontMetrics().stringWidth(s);
        g2.drawString(s, 26 - sWidth, this.getHeight() - 30 + fontHeight / 2 - 4);
        for (int i = 0; i <= this._durationInMinutes; ++i) {
            int x0;
            double x = this._xRange / (double)this._durationInMinutes * (double)i;
            int x1 = x0 = (int)(30.0 + x * this._xScale);
            int y0 = this.getHeight() - 30;
            int y1 = y0 + 4;
            g2.drawLine(x0, y0, x1, y1);
        }
        String xTitle = this._durationInMinutes + " Minutes";
        int stringWidth = (int)Math.ceil(g2.getFontMetrics().stringWidth(xTitle));
        g2.drawString(xTitle, (this.getWidth() - stringWidth) / 2, this.getHeight() - 10);
        this.drawData(g2);
    }

    private void drawChartArea(Graphics2D g2) {
        int chartWidth = this.getWidth() - 60;
        g2.setColor(Color.decode("#eeeeee"));
        g2.fillRect(30, 30, chartWidth, this.getHeight() - 60);
        g2.setColor(Color.decode("#aaaaaa"));
        int i = 1;
        while ((double)i <= this._yRange) {
            int y0;
            int stepCnt = (int)(this._yRange < 100.0 ? this._yRange : 10.0);
            double y = this._yRange / (double)stepCnt * (double)i;
            int y1 = y0 = (int)((double)(this.getHeight() - 30) - y * this._yScale);
            g2.drawLine(30, y0, 30 + chartWidth, y1);
            ++i;
        }
    }

    private void drawData(Graphics2D g2) {
        Rectangle rect = new Rectangle(30, 30, this.getWidth() - 60, this.getHeight() - 60);
        g2.clip(rect);
        g2.setStroke(GRAPH_STROKE);
        for (int i = 0; i < this._dataSeries.size() - 1; ++i) {
            g2.setColor(this._graphColor);
            XY thisXY = this._dataSeries.get(i);
            XY nextXY = this._dataSeries.get(i + 1);
            long elapsed = nextXY.getX() - thisXY.getX();
            if (10000L < elapsed) continue;
            if (2000L < elapsed) {
                g2.setColor(Color.decode("#cccccc"));
            }
            double x1 = (double)(thisXY.getX() - this._xMin) * this._xScale + 30.0;
            double y1 = (double)(this.getHeight() - 30) - (thisXY.getY() - this._yMin) * this._yScale;
            double x2 = (double)(nextXY.getX() - this._xMin) * this._xScale + 30.0;
            double y2 = (double)(this.getHeight() - 30) - (nextXY.getY() - this._yMin) * this._yScale;
            g2.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        }
    }
}

