/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.supporter.BackgroundAction;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

public class BackgroundActionTableModel
extends AbstractTableModel {
    private final String[] columnNames = new String[]{"Time", "Title", "Status"};
    private final ArrayList<BackgroundAction> _inProgressActions = new ArrayList();

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public int getRowCount() {
        return this._inProgressActions.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowForBackgroundAction(BackgroundAction backgroundAction) {
        int row = this._inProgressActions.indexOf(backgroundAction);
        return row;
    }

    public BackgroundAction getBackgroundActionAt(int row) {
        BackgroundAction backgroundAction = this._inProgressActions.get(row);
        return backgroundAction;
    }

    @Override
    public Object getValueAt(int row, int col) {
        BackgroundAction backgroundAction = this._inProgressActions.get(row);
        switch (col) {
            case 0: {
                Date startTime = backgroundAction.getStartTime();
                return startTime;
            }
            case 1: {
                return backgroundAction.getTitle();
            }
            case 2: {
                return backgroundAction.getDescription();
            }
            case 3: {
                return backgroundAction.getPercentage();
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public boolean add(BackgroundAction backgroundAction) {
        if (!this._inProgressActions.contains(backgroundAction)) {
            backgroundAction.addProgressUpdateListener(e -> {
                BackgroundAction ba = (BackgroundAction)e.getSource();
                int row = this.getRowForBackgroundAction(backgroundAction);
                this.fireTableRowsInserted(row, row);
            });
            boolean added = this._inProgressActions.add(backgroundAction);
            int row = this.getRowForBackgroundAction(backgroundAction);
            this.fireTableRowsInserted(row, row);
            return added;
        }
        return false;
    }
}

