/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.supporter.Notification;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class BackgroundAction
extends Notification
implements Runnable {
    private Thread _thread = null;
    private final ArrayList<ChangeListener> _progressListeners = new ArrayList();
    private JniorInfo _jniorInfo;
    private Date _startedTime = null;
    private int _percentage = 0;
    protected boolean _isRunning;
    protected boolean _aborted;
    private boolean _complete = false;

    protected BackgroundAction(JniorInfo jniorInfo) {
        this._jniorInfo = jniorInfo;
    }

    public JniorInfo getJniorInfo() {
        return this._jniorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressUpdateListener(ChangeListener changeListener) {
        ArrayList<ChangeListener> arrayList = this._progressListeners;
        synchronized (arrayList) {
            this._progressListeners.add(changeListener);
        }
    }

    protected void update(String description) {
        this.update(description, this._percentage);
    }

    protected void update(String desctiption, int percent) {
        if (null == this._jniorInfo) {
            throw new RuntimeException("Must set Jnior Info object");
        }
        this._timestamp = System.currentTimeMillis();
        this._description = desctiption;
        this._percentage = percent;
        this.updateChangeListeners();
    }

    public void abort() {
        this._aborted = true;
    }

    protected void complete() {
        this._complete = true;
        this.updateChangeListeners();
    }

    public boolean isComplete() {
        return this._complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChangeListeners() {
        ArrayList<ChangeListener> arrayList = this._progressListeners;
        synchronized (arrayList) {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : this._progressListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public void start() {
        if (null == this._thread) {
            this._startedTime = new Date();
            this._thread = new Thread(this);
            this._thread.start();
        }
    }

    public abstract String getTitle();

    public Date getStartTime() {
        return this._startedTime;
    }

    public int getPercentage() {
        return this._percentage;
    }

    @Override
    public abstract void run();
}

