/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter;

import com.integ.janoslib.net.beacon.Version;
import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.supporter.AssemblyInfo;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.config.GeneralConfig;
import com.integ.supporter.jrget.jniordotcom.OfficialReleasesJson;
import com.integ.supporter.jrget.jniordotcom.ReleasesDownloadedEvent;
import com.integ.supporter.jrget.jniordotcom.ReleasesDownloadedEventListener;
import com.integ.supporter.ui.toasts.NewVersionAvailableToast;
import com.integ.supporter.ui.toasts.OptionPaneToast;
import com.integ.supporter.ui.toasts.RunningLatestVersionToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;
import org.json.JSONObject;

public class ApplicationUpdater
implements Runnable,
ReleasesDownloadedEventListener {
    private static Timer Timer;
    private final boolean _force;

    public static void CheckForUpdates() {
        int fifteenMinutesMillis = 900000;
        Timer = new Timer(fifteenMinutesMillis, e -> {
            try {
                ApplicationUpdater.CheckForUpdate(false);
            }
            catch (Exception ex) {
                Logger.getGlobal().log(Level.SEVERE, "Error checking for updates");
                Timer.stop();
            }
        });
        Timer.setInitialDelay(2000);
        Timer.start();
    }

    public static void CheckForUpdate(boolean force) {
        new Thread(new ApplicationUpdater(force)).start();
    }

    private ApplicationUpdater(boolean force) {
        this._force = force;
    }

    @Override
    public void run() {
        try {
            OfficialReleasesJson officialReleasesJson = new OfficialReleasesJson();
            officialReleasesJson.addReleaseDownloadListener(this);
            officialReleasesJson.fetch("jnior-supporter");
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error checking for the latest version of the Supporter", ex);
        }
    }

    @Override
    public void releasesDownloadedEvent(ReleasesDownloadedEvent releasesDownloadedEvent) {
        try {
            OptionPaneToast toast;
            boolean updateAvailable;
            CodeSource codeSource = this.getClass().getProtectionDomain().getCodeSource();
            URL codeSourceLocation = codeSource.getLocation();
            URI executableUri = codeSourceLocation.toURI();
            String executingFilePath = new File(executableUri).getPath();
            JSONObject releasesJson = releasesDownloadedEvent.getReleasesJson();
            JSONObject downloadsJson = releasesJson.getJSONObject("downloads");
            JSONObject supporterJson = downloadsJson.getJSONObject("jnior-supporter");
            JSONObject latestVersionJson = supporterJson.getJSONObject("latest_version");
            String latestReleaseMd5 = latestVersionJson.getString("md5").toLowerCase();
            String latestReleaseVersion = latestVersionJson.getString("version").toLowerCase();
            Version remoteVersion = Version.parse(latestReleaseVersion);
            String skipVersion = GeneralConfig.getSkipVersion();
            if (!this._force && skipVersion.equals(latestReleaseVersion)) {
                return;
            }
            Version localVersion = Version.parse(AssemblyInfo.getVersion());
            int versionComparison = remoteVersion.compareTo(localVersion);
            boolean bl = updateAvailable = 1 == versionComparison;
            if (0 == versionComparison && !updateAvailable && executingFilePath.toLowerCase().endsWith(".jar")) {
                byte[] contents = FileUtils.readAllBytes(executingFilePath);
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.update(contents);
                byte[] digest = md.digest();
                String executingFileMd5 = HexUtils.bytesToHex(digest).toLowerCase();
                boolean bl2 = updateAvailable = !latestReleaseMd5.equalsIgnoreCase(executingFileMd5);
            }
            if (updateAvailable) {
                Timer.stop();
                toast = new NewVersionAvailableToast(localVersion, latestVersionJson);
                ToastNotifications.getInstance().display(toast);
            } else if (this._force) {
                toast = new RunningLatestVersionToast(localVersion);
                ToastNotifications.getInstance().display(toast);
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error checking for new release", ex);
        }
    }
}

