/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater.steps;

import com.integ.janoslib.utils.FileUtils;
import com.integ.janoslib.utils.HexUtils;
import com.integ.janoslib.utils.ZipUtils;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.steps.FtpStep;
import com.integ.supporter.updater.steps.ProjectStep;
import com.integ.supporter.updater.steps.ProjectStepPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JTextField;

public class FtpStepPanel
extends ProjectStepPanel {
    protected JTextField _remoteFolderField;

    public FtpStepPanel(ProjectStep projectStep) throws IntrospectionException {
        super(projectStep);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.loadFileSelectionField("localFile");
        this.loadTextField("remoteFile");
        this._remoteFolderField = this.loadTextField("remoteFolder");
        final JTextField remotePathTextField = this.loadTextField("remotePath");
        final JTextField md5TextField = this.loadTextField("md5");
        final FtpStep ftpProjectStep = (FtpStep)this._projectStep;
        this._projectStep.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                block8: {
                    String name = evt.getPropertyName();
                    try {
                        if ("AbsoluteFilePath".equalsIgnoreCase(name)) break block8;
                        if ("remotePath".equalsIgnoreCase(name)) {
                            remotePathTextField.setText(evt.getNewValue().toString());
                            break block8;
                        }
                        if (!"Md5".equalsIgnoreCase(name)) break block8;
                        md5TextField.setText(evt.getNewValue().toString());
                        try {
                            UpdateProjectFile updateProjectFile = FtpStepPanel.this._projectStep.getUpdateProjectFile();
                            File file = updateProjectFile.getFile();
                            String title = updateProjectFile.getTitle();
                            ZipUtils.addFile(file.getPath(), ftpProjectStep._absoluteFile, title);
                            if (null != evt.getOldValue()) {
                                File oldFile = new File(evt.getOldValue().toString());
                                String pathToOldFileInZip = title + "/" + oldFile.getName();
                                ZipUtils.deleteEntry(file.getPath(), pathToOldFileInZip);
                            }
                            if (null == ftpProjectStep._remoteFile || "".equals(ftpProjectStep._remoteFile)) {
                                ftpProjectStep._remoteFile = ftpProjectStep._localFile;
                            }
                        }
                        catch (IllegalStateException updateProjectFile) {
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            Logger.getLogger(FtpStepPanel.class.getName()).severe(ex.getMessage());
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }
        });
        if (ftpProjectStep.isUpdateAvailable()) {
            final JButton fileSelectButton = new JButton("Update Reference");
            fileSelectButton.setBackground(Color.decode("#ccffcc"));
            fileSelectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        byte[] fileContentBytes = FileUtils.readAllBytes(ftpProjectStep.getAbsoluteFilePath());
                        MessageDigest md = MessageDigest.getInstance("MD5");
                        md.update(fileContentBytes);
                        byte[] digest = md.digest();
                        String newMd5String = HexUtils.bytesToHex(digest).toUpperCase();
                        ftpProjectStep.setMd5(newMd5String);
                        UpdateProjectFile updateProjectFile = FtpStepPanel.this._projectStep.getUpdateProjectFile();
                        File file = updateProjectFile.getFile();
                        String title = updateProjectFile.getTitle();
                        ZipUtils.addFile(file.getPath(), ftpProjectStep.getAbsoluteFilePath(), title);
                        ftpProjectStep.checkForUpdate();
                        if (!ftpProjectStep.isUpdateAvailable()) {
                            FtpStepPanel.this.remove(fileSelectButton);
                            FtpStepPanel.this.repaint();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        Logger.getLogger(FtpStepPanel.class.getName()).severe(ex.getMessage());
                    }
                    catch (NoSuchAlgorithmException ex) {
                        ex.printStackTrace();
                        Logger.getLogger(FtpStepPanel.class.getName()).severe(ex.getMessage());
                    }
                }
            });
            this.add(fileSelectButton);
        }
    }
}

