/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.updater;

import com.integ.janoslib.net.LoginFailedException;
import com.integ.janoslib.net.beacon.JniorInfo;
import com.integ.janoslib.utils.ExceptionUtils;
import com.integ.janoslib.utils.ThreadUtils;
import com.integ.protocols.events.ConnectionEvent;
import com.integ.supporter.BackgroundAction;
import com.integ.supporter.JniorControlConnection;
import com.integ.supporter.JniorControlConnectionAuthenticationEvent;
import com.integ.supporter.JniorControlConnectionAuthenticationListener;
import com.integ.supporter.JniorControlConnectionListener;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.SupporterMain;
import com.integ.supporter.ui.ColorConstants;
import com.integ.supporter.ui.dialogs.LoginDialog;
import com.integ.supporter.ui.toasts.ErrorMessageToast;
import com.integ.supporter.ui.toasts.MessageToast;
import com.integ.supporter.ui.toasts.ToastNotifications;
import com.integ.supporter.updater.UpdateProjectFile;
import com.integ.supporter.updater.UpdateProjectListener;
import com.integ.supporter.updater.steps.ProjectStep;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class UpdateProjectExecutor
extends BackgroundAction
implements Runnable {
    private final UpdateProjectFile _updateProjectFile;
    private final JniorInfo _targetJniorInfo;
    private final ArrayList<ProjectStep> _steps;
    private Logger _logger = Logger.getGlobal();
    private UpdateProjectListener _updateProjectListener;
    private JniorControlConnection _jniorControlConnection;
    private boolean _rebootNeeded = false;
    private int authenticationFailedOccurances = 0;

    public UpdateProjectExecutor(UpdateProjectFile updateProjectFile, JniorInfo targetJniorInfo, ArrayList<ProjectStep> steps) {
        super(targetJniorInfo);
        this._updateProjectFile = updateProjectFile;
        this._targetJniorInfo = targetJniorInfo;
        this._steps = steps;
    }

    public UpdateProjectExecutor setLogger(Logger logger) {
        this._logger = logger;
        return this;
    }

    public void setListener(UpdateProjectListener updateProjectListener) {
        this._updateProjectListener = updateProjectListener;
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    public boolean wasAborted() {
        return this._aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._aborted = false;
        this._isRunning = true;
        boolean projectResult = true;
        try {
            ProjectStep step;
            int i;
            this._logger.info(String.format("Publishing %s to %s", this._updateProjectFile.getFilePath(), this._targetJniorInfo.IpAddress));
            int requiredSeries = this._updateProjectFile.getRequiredSeries();
            if (-1 != requiredSeries && this._targetJniorInfo.getSeries() != requiredSeries) {
                String message = String.format("%s is an incorrect series JNIOR.  Series %d required", this._targetJniorInfo.toString(), requiredSeries);
                ErrorMessageToast errorMessageToast = new ErrorMessageToast(message);
                ToastNotifications.getInstance().display(errorMessageToast);
                this._isRunning = false;
                throw new Exception(message);
            }
            long start = System.currentTimeMillis();
            this._jniorControlConnection = JniorControlConnection.getFor(this._targetJniorInfo, this._logger);
            this._jniorControlConnection.addConnectionListener(new JniorControlConnectionListener(){

                @Override
                public void onConnected(ConnectionEvent event) {
                    UpdateProjectExecutor.this.authenticationFailedOccurances = 0;
                }

                @Override
                public void onClosed(ConnectionEvent event) {
                }

                @Override
                public void onError(ConnectionEvent event) {
                    System.out.println("jnior connection failed.  we should fallback!");
                }
            });
            this._jniorControlConnection.addAuthenticationListener(new JniorControlConnectionAuthenticationListener(){

                @Override
                public void onAuthenticationSuccess(JniorControlConnectionAuthenticationEvent event) {
                }

                @Override
                public void onAuthenticationFailed(JniorControlConnectionAuthenticationEvent event) {
                    try {
                        ++UpdateProjectExecutor.this.authenticationFailedOccurances;
                        JniorInfo jniorInfo = UpdateProjectExecutor.this.getJniorInfo();
                        if (1 < UpdateProjectExecutor.this.authenticationFailedOccurances) {
                            LoginDialog loginDialog = new LoginDialog((Frame)SupporterMain.getMainFrame(), true);
                            loginDialog.setDescription("Snapshot for " + jniorInfo.IpAddress);
                            loginDialog.centerParent();
                            loginDialog.setVisible(true);
                            if (loginDialog.getResult() == 1) {
                                jniorInfo.Username = loginDialog.getUsername();
                                jniorInfo.Password = loginDialog.getPassword();
                            } else {
                                try {
                                    UpdateProjectExecutor.this._jniorControlConnection.disconnect();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                        UpdateProjectExecutor.this._jniorControlConnection.login(jniorInfo.Username, jniorInfo.Password);
                    }
                    catch (LoginFailedException ex) {
                        NotificationCollection.addError("Error providing custom credentials for " + UpdateProjectExecutor.this._jniorControlConnection.toString(), ex);
                    }
                }
            });
            this._jniorControlConnection.init();
            while (!this._jniorControlConnection.isLoggedIn()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (-1 != requiredSeries) {
                int serialNumber = this._jniorControlConnection.getUnitSerialNumber();
                System.out.println("serialNumber = " + serialNumber);
                if (requiredSeries == 4 && serialNumber < 600000000) {
                    throw new RuntimeException("JNIOR incorrect series.  Series " + requiredSeries + " required");
                }
                if (requiredSeries == 3 && serialNumber > 600000000) {
                    throw new RuntimeException("JNIOR incorrect series.  Series " + requiredSeries + " required");
                }
            }
            ArrayList<ProjectStep> projectStepArrayList = this._steps;
            int projectStepCount = projectStepArrayList.size();
            for (i = 0; i < projectStepCount; ++i) {
                if (this._aborted) {
                    throw new Exception("User Aborted");
                }
                step = projectStepArrayList.get(i);
                this._logger.info(String.format("Execute %s", step.toString()));
                this.update(String.format("Execute %s", step.toString()));
                step.setExecutor(this);
                step.setLogger(this._logger);
                step.setJniorInfo(this._targetJniorInfo);
                step.setJniorUpdateControlConnection(this._jniorControlConnection);
                boolean result = step.execute();
                if (null != this._updateProjectListener) {
                    int percentage = (int)((double)(i + 1) / (double)projectStepCount * 100.0);
                    this._updateProjectListener.updateProjectStepResult(step, result, i + 1, projectStepCount);
                    this.update(String.format("Execute %s", step.toString()), percentage);
                }
                if (result) continue;
                this._logger.severe(step + " FAILED!");
                projectResult = false;
                break;
            }
            this._isRunning = false;
            this._logger.info("Summary:");
            for (i = 0; i < projectStepCount; ++i) {
                step = projectStepArrayList.get(i);
                String summary = step.getSummary();
                if (null == summary) continue;
                this._logger.info(String.format("  %s: %s", step.getName(), summary));
            }
            long elapsed = System.currentTimeMillis() - start;
            long elapsedSeconds = elapsed / 1000L;
            long minutes = elapsedSeconds % 3600L / 60L;
            long seconds = elapsedSeconds % 60L;
            String resultString = String.format("Update project for %s has %s in %d:%02d", this._targetJniorInfo.IpAddress, projectResult ? "completed SUCCESSFULLY" : "FAILED", minutes, seconds);
            this._logger.info(resultString);
            MessageToast toast = new MessageToast(resultString);
            toast.setColor(projectResult ? ColorConstants.SUCCESS_COLOR : ColorConstants.ERROR_COLOR);
            ToastNotifications.getInstance().display(toast);
            new Thread(() -> {
                ThreadUtils.sleep(5000);
                ToastNotifications.getInstance().hide(toast);
            }).start();
            this.update(resultString);
            this.setLevel(projectResult ? 1 : 4);
            if (null != this._updateProjectListener) {
                this._updateProjectListener.updateProjectResult(this, projectResult);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (!this._aborted) {
                this._logger.severe(String.format("error in UpdateProject.run(): %s", ExceptionUtils.getStackTrace(ex)));
                if (null != this._updateProjectListener) {
                    this._updateProjectListener.updateProjectResult(this, false);
                }
            } else {
                this._isRunning = false;
                this._logger.info("user aborted");
                this.update("user aborted");
                if (null != this._updateProjectListener) {
                    this._updateProjectListener.updateProjectResult(this, false);
                }
            }
        }
        finally {
            if (null != this._jniorControlConnection) {
                try {
                    this._jniorControlConnection.disconnect();
                }
                catch (IOException ex) {
                    Logger.getLogger(UpdateProjectExecutor.class.getName()).severe(ex.getMessage());
                }
            }
        }
        this.complete();
        this._isRunning = false;
    }

    public void setRebootNeededFlag() {
        this._logger.info("Setting reboot needed flag");
        this._rebootNeeded = true;
    }

    public boolean isRebootNeeded() {
        return this._rebootNeeded;
    }

    public void clearRebootFlag() {
        this._logger.info("Clear reboot needed flag");
        this._rebootNeeded = false;
    }

    @Override
    public JniorInfo getJniorInfo() {
        return this._targetJniorInfo;
    }

    @Override
    public String getTitle() {
        File fileFromPath = new File(this._updateProjectFile.getFilePath());
        return String.format("%s -> %s", fileFromPath.getName(), this._targetJniorInfo.IpAddress);
    }
}

