/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.toasts;

import com.integ.supporter.ui.toasts.CubicOutEasing;
import com.integ.supporter.ui.toasts.Easing;
import com.integ.supporter.ui.toasts.ToastAnimation;
import javax.swing.JWindow;

public class ToastFadeAnimation
extends ToastAnimation {
    private final float _startOpacity;
    private final float _newOpacity;
    private final float _deltaOpactiy;
    private final Easing _easing = new CubicOutEasing();

    public ToastFadeAnimation(JWindow window, float newOpacity, int duration) {
        super(window, duration);
        this._startOpacity = window.getOpacity();
        this._newOpacity = newOpacity;
        this._deltaOpactiy = this._newOpacity - this._startOpacity;
    }

    @Override
    protected void update() {
        long timeDelta = System.currentTimeMillis() - this._start;
        if (timeDelta > (long)this._duration) {
            timeDelta = this._duration;
        }
        float opacity = (float)this._easing.ease(timeDelta, this._startOpacity, this._deltaOpactiy, this._duration);
        this._toastWindow.setOpacity(opacity);
        double timePercentage = (double)timeDelta / (double)this._duration;
        if (1.0 <= timePercentage) {
            this.done();
            if ((double)opacity == 0.0) {
                this._toastWindow.setVisible(false);
            }
        }
    }
}

