/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.ui.properties;

import com.integ.janoslib.collections.NameValuePair;
import com.integ.supporter.config.BackupServicesConfig;
import com.integ.supporter.ui.properties.BackupIntervalModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;

public class BackupPropertiesPanel
extends JPanel {
    private JCheckBox backupEnabledCheckBox;
    private JPanel backupSettingsPanel;
    private JPanel enabledPanel;
    private JList<String> excludedHostnamesList;
    private JList<String> excludedIpAddressesList;
    private JList<String> excludedSerialNumberList;
    private JPanel exclusionsPanel;
    private JComboBox<Object> intervalInHoursDropDown;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JComboBox<String> jComboBox1;
    private JComboBox<String> jComboBox2;
    private JComboBox<String> jComboBox3;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JSpinner jSpinner1;
    private JSpinner jSpinner2;
    private JSpinner jSpinner3;
    private JPanel validWindowPanel;

    public BackupPropertiesPanel() {
        this.initComponents();
        this.loadConfig();
    }

    private void loadConfig() {
        BackupIntervalModel model = new BackupIntervalModel();
        this.intervalInHoursDropDown.setModel(model);
        this.loadExclusions();
    }

    private void loadExclusions() {
        DefaultListModel<String> exludedSerialNumbersModel = new DefaultListModel<String>();
        this.excludedSerialNumberList.setModel(exludedSerialNumbersModel);
        for (int excludedSerialNumber : BackupServicesConfig.getExcludedSerialNumbersArray()) {
            exludedSerialNumbersModel.addElement(String.valueOf(excludedSerialNumber));
        }
        DefaultListModel<String> exludedHostnamesModel = new DefaultListModel<String>();
        this.excludedHostnamesList.setModel(exludedHostnamesModel);
        for (String excludedHostname : BackupServicesConfig.getExcludedHostnameArray()) {
            exludedHostnamesModel.addElement(excludedHostname);
        }
        DefaultListModel<String> exludedIpAddressesModel = new DefaultListModel<String>();
        this.excludedIpAddressesList.setModel(exludedIpAddressesModel);
        for (String excludedIpAddress : BackupServicesConfig.getExcludedIpAddressArray()) {
            exludedIpAddressesModel.addElement(excludedIpAddress);
        }
    }

    private void initComponents() {
        this.enabledPanel = new JPanel();
        this.backupEnabledCheckBox = new JCheckBox();
        this.validWindowPanel = new JPanel();
        this.jLabel6 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel8 = new JLabel();
        this.jSpinner2 = new JSpinner();
        this.jLabel7 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel10 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jComboBox3 = new JComboBox();
        this.backupSettingsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.intervalInHoursDropDown = new JComboBox();
        this.jSpinner3 = new JSpinner();
        this.exclusionsPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.excludedSerialNumberList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.excludedHostnamesList = new JList();
        this.jScrollPane3 = new JScrollPane();
        this.excludedIpAddressesList = new JList();
        this.jButton1 = new JButton();
        this.jButton4 = new JButton();
        this.jButton6 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton5 = new JButton();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                BackupPropertiesPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new BoxLayout(this, 1));
        this.enabledPanel.setLayout(new FlowLayout(0));
        this.backupEnabledCheckBox.setText("Backup Enabled");
        this.backupEnabledCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BackupPropertiesPanel.this.backupEnabledCheckBoxItemStateChanged(evt);
            }
        });
        this.enabledPanel.add(this.backupEnabledCheckBox);
        this.validWindowPanel.setLayout(new FlowLayout(0));
        this.jLabel6.setText("Define valid window");
        this.validWindowPanel.add(this.jLabel6);
        this.jSpinner1.setModel(new SpinnerNumberModel(0, 0, 23, 1));
        this.jSpinner1.setPreferredSize(new Dimension(48, 22));
        this.validWindowPanel.add(this.jSpinner1);
        this.jLabel8.setText(":");
        this.validWindowPanel.add(this.jLabel8);
        this.jSpinner2.setModel(new SpinnerListModel(new String[]{"00", "15", "30", "45"}));
        this.jSpinner2.setPreferredSize(new Dimension(48, 22));
        this.validWindowPanel.add(this.jSpinner2);
        this.jLabel7.setText("to");
        this.validWindowPanel.add(this.jLabel7);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11"}));
        this.jComboBox1.setMinimumSize(new Dimension(48, 22));
        this.jComboBox1.setPreferredSize(new Dimension(48, 22));
        this.validWindowPanel.add(this.jComboBox1);
        this.jLabel10.setText(":");
        this.validWindowPanel.add(this.jLabel10);
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"00", "15", "30", "45"}));
        this.jComboBox2.setMinimumSize(new Dimension(48, 22));
        this.jComboBox2.setPreferredSize(new Dimension(48, 22));
        this.validWindowPanel.add(this.jComboBox2);
        this.jComboBox3.setModel(new DefaultComboBoxModel<String>(new String[]{"am", "pm"}));
        this.jComboBox3.setMinimumSize(new Dimension(56, 22));
        this.jComboBox3.setPreferredSize(new Dimension(56, 22));
        this.validWindowPanel.add(this.jComboBox3);
        this.enabledPanel.add(this.validWindowPanel);
        this.add(this.enabledPanel);
        this.backupSettingsPanel.setLayout(new FlowLayout(0));
        this.jLabel1.setText("Interval in Hours");
        this.backupSettingsPanel.add(this.jLabel1);
        this.intervalInHoursDropDown.setModel(new DefaultComboBoxModel<String>(new String[]{"30 minutes", "1 hour", "2 hours", "4 hours", "8 hours", "12 hours", "24 hours", "2 days", "7 days"}));
        this.intervalInHoursDropDown.setSelectedIndex(5);
        this.intervalInHoursDropDown.setEnabled(false);
        this.intervalInHoursDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackupPropertiesPanel.this.intervalInHoursDropDownActionPerformed(evt);
            }
        });
        this.backupSettingsPanel.add(this.intervalInHoursDropDown);
        this.jSpinner3.setModel(new SpinnerDateModel(new Date(), null, null, 13));
        this.jSpinner3.setEditor(new JSpinner.DateEditor(this.jSpinner3, "mm:ss"));
        this.jSpinner3.setRequestFocusEnabled(false);
        this.backupSettingsPanel.add(this.jSpinner3);
        this.add(this.backupSettingsPanel);
        this.exclusionsPanel.setPreferredSize(new Dimension(400, 280));
        this.jLabel2.setText("Exlusions:");
        this.jLabel3.setText("By Serial Number");
        this.jLabel4.setText("By Hostname");
        this.jLabel5.setText("By IP Address");
        this.excludedSerialNumberList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.excludedSerialNumberList);
        this.excludedHostnamesList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.excludedHostnamesList);
        this.excludedIpAddressesList.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane3.setViewportView(this.excludedIpAddressesList);
        this.jButton1.setText("Add");
        this.jButton4.setText("Add");
        this.jButton6.setText("Add");
        this.jButton2.setText("Remove");
        this.jButton3.setText("Remove");
        this.jButton5.setText("Remove");
        GroupLayout exclusionsPanelLayout = new GroupLayout(this.exclusionsPanel);
        this.exclusionsPanel.setLayout(exclusionsPanelLayout);
        exclusionsPanelLayout.setHorizontalGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 576, Short.MAX_VALUE).addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exclusionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addGroup(exclusionsPanelLayout.createSequentialGroup().addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exclusionsPanelLayout.createSequentialGroup().addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -2, 138, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jScrollPane2, -2, 138, -2))).addGroup(exclusionsPanelLayout.createSequentialGroup().addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, GroupLayout.Alignment.LEADING, -2, 138, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton4, GroupLayout.Alignment.LEADING, -2, 138, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.jScrollPane3, -2, 138, -2).addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton5, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton6, GroupLayout.Alignment.LEADING, -2, 138, -2))))).addContainerGap(144, Short.MAX_VALUE))));
        exclusionsPanelLayout.setVerticalGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 281, Short.MAX_VALUE).addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exclusionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(exclusionsPanelLayout.createSequentialGroup().addComponent(this.jScrollPane3, -2, 123, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5)).addGroup(exclusionsPanelLayout.createSequentialGroup().addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(exclusionsPanelLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 123, -2)).addGroup(exclusionsPanelLayout.createSequentialGroup().addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 123, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(exclusionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exclusionsPanelLayout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2)).addGroup(exclusionsPanelLayout.createSequentialGroup().addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3))))).addContainerGap(-1, Short.MAX_VALUE))));
        this.add(this.exclusionsPanel);
    }

    void setPanelEnabled(JPanel panel, Boolean isEnabled) {
        Component[] components;
        panel.setEnabled(isEnabled);
        for (Component component : components = panel.getComponents()) {
            if (component instanceof JPanel) {
                this.setPanelEnabled((JPanel)component, isEnabled);
            }
            component.setEnabled(isEnabled);
        }
    }

    private void formComponentShown(ComponentEvent evt) {
        this.backupEnabledCheckBox.setSelected(BackupServicesConfig.isEnabled());
        this.setPanelEnabled(this.backupSettingsPanel, this.backupEnabledCheckBox.isSelected());
    }

    private void backupEnabledCheckBoxItemStateChanged(ItemEvent evt) {
        BackupServicesConfig.setEnabled(this.backupEnabledCheckBox.isSelected());
        this.setPanelEnabled(this.backupSettingsPanel, this.backupEnabledCheckBox.isSelected());
    }

    private void intervalInHoursDropDownActionPerformed(ActionEvent evt) {
        NameValuePair selectedNameValuePair = (NameValuePair)this.intervalInHoursDropDown.getSelectedItem();
        BackupServicesConfig.setBackupIntervalInHours((Double)selectedNameValuePair.getValue());
    }
}

