/*
 * Decompiled with CFR 0.152.
 */
package com.integ.supporter.snapshot;

import com.integ.janoslib.utils.ThreadUtils;
import com.integ.supporter.NotificationCollection;
import com.integ.supporter.snapshot.DefaultMutableTreeNode2;
import com.integ.supporter.snapshot.SnapshotFile;
import com.integ.supporter.snapshot.TreeNodeWithCount;
import com.integ.supporter.snapshot.ZipEntryNode;
import com.integ.supporter.snapshot.ZipFileNode;
import com.integ.supporter.snapshot.library.SnapshotLibrary;
import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class SnapshotTreeModel
extends DefaultTreeModel {
    private final SnapshotLibrary _snapshotLibrary;
    private final TreeNodeWithCount _bySerialNode;
    private final TreeNodeWithCount _byHostnameNode;
    private final TreeNodeWithCount _byDateNode;
    private final TreeNodeWithCount _otherSnapshotsNode;

    public SnapshotTreeModel(DefaultMutableTreeNode2 rootNode, SnapshotLibrary snapshotLibrary) {
        super(rootNode);
        this._snapshotLibrary = snapshotLibrary;
        this._bySerialNode = new TreeNodeWithCount("By Serial");
        rootNode.add(this._bySerialNode);
        this._byHostnameNode = new TreeNodeWithCount("By Hostname");
        rootNode.add(this._byHostnameNode);
        this._byDateNode = new TreeNodeWithCount("By Date");
        rootNode.add(this._byDateNode);
        this._otherSnapshotsNode = new TreeNodeWithCount("All");
        rootNode.add(this._otherSnapshotsNode);
        ThreadUtils.execute(new Runnable(){

            @Override
            public void run() {
                SnapshotTreeModel.this.refresh();
            }
        });
    }

    public void addSnapshotFile(SnapshotFile snapshotFile) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        SnapshotTreeModel snapshotTreeModel = this;
        synchronized (snapshotTreeModel) {
            try {
                this._bySerialNode.removeAllChildren();
                this._byHostnameNode.removeAllChildren();
                this._byDateNode.removeAllChildren();
                this._otherSnapshotsNode.removeAllChildren();
                this.enumerateBySerial();
                this.enumerateByHostname();
                this.enumerateByDate();
                this.enumerateOther();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                NotificationCollection.addError("Error refreshing Snapshots", ex);
            }
        }
    }

    private void enumerateBySerial() {
        String[] serialNumberStrings;
        for (String serialNumberString : serialNumberStrings = this._snapshotLibrary.getSerialNumbers()) {
            File[] files;
            TreeNodeWithCount serialNode = null;
            Enumeration<TreeNode> enumeration = this._bySerialNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNodeWithCount treeNode = (TreeNodeWithCount)enumeration.nextElement();
                if (!treeNode.getText().equals(serialNumberString)) continue;
                serialNode = treeNode;
                break;
            }
            if (null == serialNode) {
                serialNode = new TreeNodeWithCount(serialNumberString);
                super.insertNodeInto(serialNode, this._bySerialNode, this._bySerialNode.getChildCount());
            }
            for (File file : files = this._snapshotLibrary.getFilesForSerialNumber(serialNumberString)) {
                this.tryAddFileNode(serialNode, file);
            }
        }
        super.nodeStructureChanged(this._bySerialNode);
    }

    private void enumerateByHostname() {
        String[] hostnameStrings;
        for (String hostnameString : hostnameStrings = this._snapshotLibrary.getHostnames()) {
            File[] files;
            TreeNodeWithCount hostnameNode = null;
            Enumeration<TreeNode> enumeration = this._byHostnameNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNodeWithCount treeNode = (TreeNodeWithCount)enumeration.nextElement();
                if (!treeNode.getText().equals(hostnameString)) continue;
                hostnameNode = treeNode;
                break;
            }
            if (null == hostnameNode) {
                hostnameNode = new TreeNodeWithCount(hostnameString);
                super.insertNodeInto(hostnameNode, this._byHostnameNode, this._byHostnameNode.getChildCount());
            }
            for (File file : files = this._snapshotLibrary.getFilesForHostname(hostnameString)) {
                this.tryAddFileNode(hostnameNode, file);
            }
        }
        super.nodeStructureChanged(this._byHostnameNode);
    }

    private void enumerateByDate() {
        String[] dateStrings;
        for (String dateString : dateStrings = this._snapshotLibrary.getDates()) {
            File[] files;
            TreeNodeWithCount dateNode = null;
            Enumeration<TreeNode> enumeration = this._byDateNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNodeWithCount treeNode = (TreeNodeWithCount)enumeration.nextElement();
                if (!treeNode.getText().equals(dateString)) continue;
                dateNode = treeNode;
                break;
            }
            if (null == dateNode) {
                dateNode = new TreeNodeWithCount(dateString);
                super.insertNodeInto(dateNode, this._byDateNode, this._byDateNode.getChildCount());
            }
            for (File file : files = this._snapshotLibrary.getFilesForDate(dateString)) {
                this.tryAddFileNode(dateNode, file);
            }
        }
        super.nodeStructureChanged(this._byDateNode);
    }

    private void enumerateOther() {
        File[] files;
        for (File file : files = this._snapshotLibrary.getAllSnapshotFiles()) {
            this.tryAddFileNode(this._otherSnapshotsNode, file);
        }
        super.nodeStructureChanged(this._otherSnapshotsNode);
    }

    private void tryAddFileNode(DefaultMutableTreeNode2 treeNode, File file) {
        try {
            ZipFileNode zipNode = null;
            Enumeration<TreeNode> treeNodeEnumeration = treeNode.children();
            while (treeNodeEnumeration.hasMoreElements()) {
                ZipFileNode zipFileNode = (ZipFileNode)treeNodeEnumeration.nextElement();
                if (!zipFileNode.getFile().equals(file)) continue;
                zipNode = zipFileNode;
                break;
            }
            if (null == zipNode) {
                zipNode = new ZipFileNode(file);
                this.buildFileInfoStructureFromZip(file, zipNode);
                super.insertNodeInto(zipNode, treeNode, 0);
            }
        }
        catch (Exception ex) {
            NotificationCollection.addError("Error adding file to " + treeNode.toString(), ex);
        }
    }

    private void buildFileInfoStructureFromZip(File file, DefaultMutableTreeNode2 node) {
        if (file.isFile()) {
            try (ZipFile zipFile = new ZipFile(file.getPath());){
                Enumeration<? extends ZipEntry> zipEnumeration = zipFile.entries();
                while (zipEnumeration.hasMoreElements()) {
                    ZipEntry zipEntry = zipEnumeration.nextElement();
                    String[] zipEntryPath = zipEntry.getName().split("/");
                    DefaultMutableTreeNode2 treeNode = node;
                    for (String part : zipEntryPath) {
                        boolean found = false;
                        for (int childIndex = 0; childIndex < treeNode.getChildCount(); ++childIndex) {
                            DefaultMutableTreeNode2 tn = (DefaultMutableTreeNode2)treeNode.getChildAt(childIndex);
                            if (!part.equals(tn.toString())) continue;
                            treeNode = tn;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        ZipEntryNode cn = new ZipEntryNode(part);
                        cn.setZipInfo(file.getPath(), zipEntry.getName());
                        treeNode.add(cn);
                        treeNode = cn;
                    }
                }
            }
            catch (Exception e) {
                e = new Exception("error opening " + file.getPath(), e);
                e.printStackTrace();
            }
        }
    }
}

